/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.misc.jmh;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfiguratorException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.benchmark.jmh.JmhBenchmark;
import jenkins.benchmark.jmh.JmhBenchmarkState;

public abstract class CascJmhBenchmarkState
extends JmhBenchmarkState {
    private static final Logger LOGGER = Logger.getLogger(CascJmhBenchmarkState.class.getName());

    @NonNull
    protected abstract String getResourcePath();

    @NonNull
    protected abstract Class<?> getEnclosingClass();

    public void setup() throws Exception {
        Class<?> enclosingClass = this.getEnclosingClass();
        if (!enclosingClass.isAnnotationPresent(JmhBenchmark.class)) {
            throw new IllegalStateException("The enclosing class must be annotated with @JmhBenchmark");
        }
        String config = Objects.requireNonNull(this.getEnclosingClass().getResource(this.getResourcePath()), "Unable to find YAML config file").toExternalForm();
        try {
            ConfigurationAsCode.get().configure(new String[]{config});
        }
        catch (ConfiguratorException e) {
            LOGGER.log(Level.SEVERE, "Unable to configure using configuration as code. Aborting.");
            this.terminateJenkins();
            throw e;
        }
    }
}

