/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.Resource;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class BlueTestSummary
extends Resource {
    public static final String TOTAL = "total";
    public static final String SKIPPED = "skipped";
    public static final String FAILED = "failed";
    public static final String PASSED = "passed";
    public static final String FIXED = "fixed";
    public static final String EXISTING_FAILED = "existingFailed";
    public static final String REGRESSIONS = "regressions";
    private final long passedTotal;
    private final long failedTotal;
    private final long fixedTotal;
    private final long existingFailedTotal;
    private final long regressionsTotal;
    private final long skippedTotal;
    private final long total;
    private final Link parent;
    private Link selfLink;

    public BlueTestSummary(long passedTotal, long failedTotal, long fixedTotal, long existingFailedTotal, long regressionsTotal, long skippedTotal, long total, Link parent) {
        this.passedTotal = passedTotal;
        this.failedTotal = failedTotal;
        this.fixedTotal = fixedTotal;
        this.existingFailedTotal = existingFailedTotal;
        this.regressionsTotal = regressionsTotal;
        this.skippedTotal = skippedTotal;
        this.total = total;
        this.parent = parent;
    }

    @Exported(name="passed")
    public long getPassedTotal() {
        return this.passedTotal;
    }

    @Exported(name="failed")
    public long getFailedTotal() {
        return this.failedTotal;
    }

    @Exported(name="skipped")
    public long getSkippedTotal() {
        return this.skippedTotal;
    }

    @Exported(name="fixed")
    public long getFixedTotal() {
        return this.fixedTotal;
    }

    @Exported(name="existingFailed")
    public long getExistingFailedTotal() {
        return this.existingFailedTotal;
    }

    @Exported(name="regressions")
    public long getRegressionsTotal() {
        return this.regressionsTotal;
    }

    @Exported(name="total")
    public long getTotal() {
        return this.total;
    }

    public BlueTestSummary tally(BlueTestSummary summary) {
        return new BlueTestSummary(this.passedTotal + summary.passedTotal, this.failedTotal + summary.failedTotal, this.fixedTotal + summary.fixedTotal, this.existingFailedTotal + summary.existingFailedTotal, this.regressionsTotal + summary.regressionsTotal, this.skippedTotal + summary.skippedTotal, this.total + summary.total, summary.parent);
    }

    @Override
    public Link getLink() {
        return this.selfLink == null ? this.parent.rel("/blueTestSummary") : this.selfLink;
    }

    public void setLink(Link link) {
        this.selfLink = link;
    }
}

