/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import hudson.Util;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.Resource;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.verb.GET;

public abstract class BlueTestResult
extends Resource {
    public static final String STATUS = "status";
    public static final String DURATION = "duration";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String AGE = "age";
    public static final String STDERR = "stdErr";
    public static final String STDOUT = "stdOut";
    public static final String HAS_STDLOG = "hasStdLog";
    public static final String STATE = "state";
    public static final String ERROR_STACK_TRACE = "errorStackTrace";
    public static final String ERROR_DETAILS = "errorDetails";
    protected final Link parent;

    public BlueTestResult(Link parent) {
        this.parent = parent;
    }

    @Exported(name="status")
    public abstract Status getStatus();

    @Exported(name="state")
    public abstract State getTestState();

    @Exported(name="duration")
    public abstract float getDuration();

    @Exported(name="id")
    public final String getId() {
        return Util.rawEncode((String)this.getClass().getName()) + ":" + Util.rawEncode((String)this.getUniqueId());
    }

    @Exported(name="age")
    public abstract int getAge();

    @Exported(name="name")
    public abstract String getName();

    @Exported(name="errorStackTrace")
    public abstract String getErrorStackTrace();

    @Exported(name="errorDetails")
    public abstract String getErrorDetails();

    @Navigable
    @GET
    @WebMethod(name={"stdErr"})
    public abstract String getStdErr();

    @Navigable
    @GET
    @WebMethod(name={"stdOut"})
    public abstract String getStdOut();

    @Exported(name="hasStdLog")
    public abstract boolean hasStdLog();

    protected abstract String getUniqueId();

    @Override
    public Link getLink() {
        return this.parent.rel("tests/" + Util.rawEncode((String)this.getId()));
    }

    public static enum State {
        UNKNOWN,
        FIXED,
        REGRESSION;

    }

    public static enum Status {
        UNKNOWN,
        PASSED,
        FAILED,
        SKIPPED;

    }
}

