/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import hudson.Util;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.Resource;
import org.kohsuke.stapler.export.Exported;

public abstract class BlueArtifact
extends Resource {
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String SIZE = "size";
    public static final String PATH = "path";
    public static final String DOWNLOADABLE = "downloadable";
    public static final String ID = "id";
    protected final Link parent;

    public BlueArtifact(Link parent) {
        this.parent = parent;
    }

    @Exported(name="id")
    public final String getId() {
        return this.getClass().getName() + ":" + Util.rawEncode((String)this.getPath());
    }

    @Exported(name="name")
    public abstract String getName();

    @Exported(name="path")
    public abstract String getPath();

    @Exported(name="url")
    public abstract String getUrl();

    @Exported(name="size")
    public abstract long getSize();

    @Exported(name="downloadable")
    public abstract boolean isDownloadable();

    @Override
    public final Link getLink() {
        return this.parent.rel(Util.rawEncode((String)Util.rawEncode((String)this.getId())));
    }
}

