/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.factory;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Run;
import io.jenkins.blueocean.commons.IterableUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import java.util.ArrayList;
import java.util.Collections;

public abstract class BlueTestResultFactory
implements ExtensionPoint {
    public Result getBlueTestResults(Run<?, ?> run, Reachable parent) {
        return Result.notFound();
    }

    public static Result resolve(Run<?, ?> run, Reachable parent) {
        Iterable<BlueTestResult> results = new ArrayList<BlueTestResult>(0);
        BlueTestSummary summary = new BlueTestSummary(0L, 0L, 0L, 0L, 0L, 0L, 0L, parent == null ? null : parent.getLink());
        for (BlueTestResultFactory factory : BlueTestResultFactory.allFactories()) {
            Result result = factory.getBlueTestResults(run, parent);
            if (result == null || result.results == null || result.summary == null) continue;
            results = IterableUtils.chainedIterable(result.results, results);
            summary = summary.tally(result.summary);
        }
        return BlueTestResultFactory.getResult(results, summary);
    }

    private static Result getResult(Iterable<BlueTestResult> results, BlueTestSummary summary) {
        if (summary.getTotal() == 0L) {
            summary = null;
            results = null;
        }
        return Result.of(results, summary);
    }

    private static Iterable<BlueTestResultFactory> allFactories() {
        return ExtensionList.lookup(BlueTestResultFactory.class);
    }

    public static final class Result {
        private static final Result NOT_FOUND = new Result(Collections.emptyList(), null);
        @Nullable
        public final Iterable<BlueTestResult> results;
        @Nullable
        public final BlueTestSummary summary;

        private Result(Iterable<BlueTestResult> results, BlueTestSummary summary) {
            this.results = results;
            this.summary = summary;
        }

        public static Result of(Iterable<BlueTestResult> results, BlueTestSummary summary) {
            return new Result(results, summary);
        }

        @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Its ok in this case")
        public static Result of(Iterable<BlueTestResult> results) {
            long skipped = 0L;
            long passed = 0L;
            long failed = 0L;
            long regressions = 0L;
            long existingFailedTotal = 0L;
            long fixedTotal = 0L;
            long total = 0L;
            Link parent = null;
            for (BlueTestResult result : results) {
                if (parent == null) {
                    parent = result.getLink();
                }
                switch (result.getStatus()) {
                    case SKIPPED: {
                        ++skipped;
                        break;
                    }
                    case PASSED: {
                        ++passed;
                        if (result.getTestState() != BlueTestResult.State.FIXED) break;
                        ++fixedTotal;
                        break;
                    }
                    case FAILED: {
                        ++failed;
                        if (result.getTestState() == BlueTestResult.State.REGRESSION) {
                            ++regressions;
                            break;
                        }
                        ++existingFailedTotal;
                    }
                }
                ++total;
            }
            if (total == 0L) {
                return Result.notFound();
            }
            BlueTestSummary summary = new BlueTestSummary(passed, failed, fixedTotal, existingFailedTotal, regressions, skipped, total, parent);
            return new Result(results, summary);
        }

        public static Result notFound() {
            return NOT_FOUND;
        }
    }
}

