/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.model.Item;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.Utils;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteContainer;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.util.ArrayList;
import java.util.Iterator;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.DELETE;

public class FavoriteContainerImpl
extends BlueFavoriteContainer {
    private final UserImpl user;
    private final Link self;

    public FavoriteContainerImpl(UserImpl user, Reachable parent) {
        this.user = user;
        this.self = parent.getLink().rel("favorites");
    }

    public BlueFavorite get(String name) {
        name = FavoriteUtil.decodeFullName(name);
        Item item = Jenkins.get().getItemByFullName(name);
        if (item != null && Favorites.isFavorite((User)this.user.user, (Item)item)) {
            return FavoriteUtil.getFavorite(item, (Reachable)this);
        }
        return null;
    }

    public Iterator<BlueFavorite> iterator() {
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        int start = 0;
        int limit = 100;
        if (request != null) {
            String limitParam;
            String startParam = request.getParameter("start");
            if (StringUtils.isNotBlank((CharSequence)startParam)) {
                start = Integer.parseInt(startParam);
            }
            if (StringUtils.isNotBlank((CharSequence)(limitParam = request.getParameter("limit")))) {
                limit = Integer.parseInt(limitParam);
            }
        }
        return this.iterator(start, limit);
    }

    public Iterator<BlueFavorite> iterator(int start, int limit) {
        ArrayList<BlueFavorite> favorites = new ArrayList<BlueFavorite>();
        Iterator favoritesIterator = Favorites.getFavorites((User)this.user.user).iterator();
        Utils.skip(favoritesIterator, (int)start);
        int count = 0;
        while (count < limit && favoritesIterator.hasNext()) {
            BlueFavorite blueFavorite;
            Item item = (Item)favoritesIterator.next();
            if (item instanceof AbstractFolder || (blueFavorite = FavoriteUtil.getFavorite(item)) == null) continue;
            favorites.add(blueFavorite);
            ++count;
        }
        return favorites.iterator();
    }

    public Link getLink() {
        return this.self;
    }

    @WebMethod(name={""})
    @DELETE
    public void doDelete(StaplerResponse2 resp) throws Favorites.FavoriteException {
        for (Item favorite : Favorites.getFavorites((User)this.user.user)) {
            Favorites.removeFavorite((User)this.user.user, (Item)favorite);
        }
        resp.setStatus(204);
    }
}

