/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Action;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.ExportedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionProxiesImpl
extends BlueActionProxy {
    private final Action action;
    private final Reachable parent;
    private static final Logger logger = LoggerFactory.getLogger(ActionProxiesImpl.class);

    public ActionProxiesImpl(Action action, Reachable parent) {
        this.action = action;
        this.parent = parent;
    }

    public Object getAction() {
        if (this.action.getClass().isAnnotationPresent(ExportedBean.class)) {
            return this.action;
        }
        return null;
    }

    public String getUrlName() {
        try {
            return this.action.getUrlName();
        }
        catch (Exception e) {
            logger.error(String.format("Error calling %s.getUrlName(): %s", this.action.getClass().getName(), e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String get_Class() {
        return this.action.getClass().getName();
    }

    public Link getLink() {
        if (this.getUrlName() != null) {
            return this.parent.getLink().rel(this.getUrlName());
        }
        if (this.action instanceof Reachable) {
            return ((Reachable)this.action).getLink();
        }
        return null;
    }

    public static Collection<BlueActionProxy> getActionProxies(List<? extends Action> actions, Reachable parent) {
        if (ActionProxiesImpl.isTreeRequest()) {
            return ActionProxiesImpl.getActionProxies(actions, action -> false, parent);
        }
        return Collections.emptyList();
    }

    public static Collection<BlueActionProxy> getActionProxies(Collection<? extends Action> actions, Predicate<Action> alwaysAllowAction, Reachable parent) {
        return actions.stream().filter(action -> action != null && (action.getClass().getAnnotation(ExportedBean.class) != null || alwaysAllowAction.test((Action)action))).map(action1 -> new ActionProxiesImpl((Action)action1, parent)).collect(Collectors.toList());
    }

    private static boolean isTreeRequest() {
        return StringUtils.isNotBlank((CharSequence)Stapler.getCurrentRequest2().getParameter("tree"));
    }
}

