/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest.junit;

import hudson.Extension;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResultAction;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class BlueJUnitTestResult
extends BlueTestResult {
    protected final CaseResult testResult;

    public BlueJUnitTestResult(CaseResult testResult, Link parent) {
        super(parent);
        this.testResult = testResult;
    }

    public String getName() {
        return this.testResult.getDisplayName() + " \u2013 " + this.testResult.getClassName();
    }

    public BlueTestResult.Status getStatus() {
        return switch (this.testResult.getStatus()) {
            case CaseResult.Status.SKIPPED -> BlueTestResult.Status.SKIPPED;
            case CaseResult.Status.FAILED, CaseResult.Status.REGRESSION -> BlueTestResult.Status.FAILED;
            case CaseResult.Status.PASSED, CaseResult.Status.FIXED -> BlueTestResult.Status.PASSED;
            default -> BlueTestResult.Status.UNKNOWN;
        };
    }

    public BlueTestResult.State getTestState() {
        return switch (this.testResult.getStatus()) {
            case CaseResult.Status.REGRESSION -> BlueTestResult.State.REGRESSION;
            case CaseResult.Status.FIXED -> BlueTestResult.State.FIXED;
            default -> BlueTestResult.State.UNKNOWN;
        };
    }

    public float getDuration() {
        return this.testResult.getDuration();
    }

    public String getErrorStackTrace() {
        return this.testResult.getErrorStackTrace();
    }

    public String getErrorDetails() {
        return this.testResult.getErrorDetails();
    }

    protected String getUniqueId() {
        return this.testResult.getClassName() + ":" + this.testResult.getId();
    }

    public int getAge() {
        int age = !this.testResult.isPassed() && this.testResult.getRun() != null ? this.testResult.getRun().getNumber() - this.testResult.getFailedSince() + 1 : 0;
        return age;
    }

    public String getStdErr() {
        return this.serveLog(this.testResult.getStderr());
    }

    public String getStdOut() {
        return this.serveLog(this.testResult.getStdout());
    }

    private String serveLog(String log) {
        if (StringUtils.isEmpty((CharSequence)log)) {
            throw new ServiceException.NotFoundException("No log");
        }
        return log;
    }

    public boolean hasStdLog() {
        return StringUtils.isNotBlank((CharSequence)this.testResult.getStderr()) || StringUtils.isNotBlank((CharSequence)this.testResult.getStdout());
    }

    @Extension
    public static class FactoryImpl
    extends BlueTestResultFactory {
        public BlueTestResultFactory.Result getBlueTestResults(Run<?, ?> run, Reachable parent) {
            TestResultAction action = (TestResultAction)run.getAction(TestResultAction.class);
            if (action == null) {
                return BlueTestResultFactory.Result.notFound();
            }
            ArrayList testsToTransform = new ArrayList();
            testsToTransform.addAll(action.getFailedTests());
            testsToTransform.addAll(action.getSkippedTests());
            testsToTransform.addAll(action.getPassedTests());
            return BlueTestResultFactory.Result.of((Iterable)testsToTransform.stream().map(caseResult -> new BlueJUnitTestResult((CaseResult)caseResult, parent.getLink())).collect(Collectors.toList()));
        }
    }
}

