/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.apache.commons.lang.StringUtils;

@Extension(ordinal=-100.0)
public class OrganizationFactoryImpl
extends OrganizationFactory {
    private static final String ORGANIZATION_NAME = StringUtils.defaultIfBlank((String)System.getProperty("BLUE_ORGANIZATION_NAME"), (String)"jenkins");
    private static final String ROOT_FOLDER_NAME = System.getProperty("BLUE_ORGANIZATION_ROOT_FOLDER");
    private static final Logger LOG = Logger.getLogger(OrganizationFactoryImpl.class.getName());
    private final OrganizationImpl instance;

    public OrganizationFactoryImpl() {
        this(ORGANIZATION_NAME);
    }

    public OrganizationFactoryImpl(String name) {
        if (ROOT_FOLDER_NAME != null) {
            Item root = Jenkins.get().getItemByFullName(ROOT_FOLDER_NAME);
            if (root instanceof ModifiableTopLevelItemGroup) {
                ModifiableTopLevelItemGroup group = (ModifiableTopLevelItemGroup)root;
                this.instance = new OrganizationImpl(name, group);
            } else {
                LOG.warning(() -> "Specified BLUE_ORGANIZATION_ROOT_FOLDER '" + ROOT_FOLDER_NAME + "' not found, or not a Folder. Falling back to Jenkins root folder.");
                this.instance = new OrganizationImpl(name, (ModifiableTopLevelItemGroup)Jenkins.get());
            }
        } else {
            this.instance = new OrganizationImpl(name, (ModifiableTopLevelItemGroup)Jenkins.get());
        }
    }

    public BlueOrganization get(String name) {
        if (this.instance.getName().equals(name)) {
            return this.instance;
        }
        return null;
    }

    public Collection<BlueOrganization> list() {
        return Collections.singletonList(this.instance);
    }

    public OrganizationImpl of(ItemGroup group) {
        return group == this.instance.getGroup() ? this.instance : null;
    }
}

