/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueArtifactFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;
import java.util.Collection;
import java.util.stream.Collectors;

public class ArtifactImpl
extends BlueArtifact {
    private final Run run;
    private final Run.Artifact artifact;

    public ArtifactImpl(Run run, Run.Artifact artifact, Link parent) {
        super(parent);
        this.run = run;
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getFileName();
    }

    public String getPath() {
        return this.artifact.relativePath;
    }

    public String getUrl() {
        return String.format("/%sartifact/%s", this.run.getUrl(), this.artifact.getHref());
    }

    public long getSize() {
        try {
            return this.artifact.getFileSize();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public boolean isDownloadable() {
        return true;
    }

    @Extension(ordinal=-1.0)
    public static class FactoryImpl
    extends BlueArtifactFactory {
        public Collection<BlueArtifact> getArtifacts(Run<?, ?> run, Reachable parent) {
            return run.getArtifacts().stream().map(artifact -> new ArtifactImpl((Run)run, (Run.Artifact)artifact, parent.getLink())).collect(Collectors.toList());
        }
    }
}

