/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import hudson.Extension;
import hudson.model.User;
import io.jenkins.blueocean.commons.IterableUtils;
import io.jenkins.blueocean.commons.PageStatePreloader;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;

@Extension
public class UserStatePreloader
extends PageStatePreloader {
    private static final Logger LOGGER = Logger.getLogger(UserStatePreloader.class.getName());
    private static final String ANONYMOUS;

    public String getStatePropertyPath() {
        return "user";
    }

    public String getStateJson() {
        BlueOrganization organization = (BlueOrganization)IterableUtils.getFirst((Iterable)OrganizationFactory.getInstance().list(), null);
        try {
            User currentUser = User.current();
            if (currentUser != null && organization != null) {
                return Export.toJson((Object)((Object)new UserImpl(organization, currentUser)), (boolean)true);
            }
            return ANONYMOUS;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unexpected error serializing active User object and adding to page preload state.");
            return ANONYMOUS;
        }
    }

    static {
        JSONObject anonUserJson = new JSONObject();
        anonUserJson.put("id", (Object)"anonymous");
        ANONYMOUS = anonUserJson.toString();
    }
}

