/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.scm.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineCreateRequest;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.springframework.security.core.Authentication;

public abstract class AbstractPipelineCreateRequest
extends BluePipelineCreateRequest {
    protected final BlueScmConfig scmConfig;

    public AbstractPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        this.setName(name);
        this.scmConfig = scmConfig;
    }

    @NonNull
    protected TopLevelItem createProject(String name, String descriptorName, Class<? extends TopLevelItemDescriptor> descriptorClass, BlueOrganization organization) throws IOException {
        Authentication a;
        ModifiableTopLevelItemGroup p = this.getParent(organization);
        ACL acl = p instanceof AccessControlled ? ((AccessControlled)p).getACL() : Jenkins.get().getACL();
        if (!acl.hasPermission2(a = Jenkins.getAuthentication2(), Item.CREATE)) {
            throw new ServiceException.ForbiddenException(String.format("Failed to create pipeline: %s. User %s doesn't have Job create permission", name, a.getName()));
        }
        TopLevelItemDescriptor descriptor = (TopLevelItemDescriptor)Items.all().findByName(descriptorName);
        if (descriptor == null || !descriptorClass.isAssignableFrom(descriptor.getClass())) {
            throw new ServiceException.BadRequestException(String.format("Failed to create pipeline: %s, descriptor %s is not found", name, descriptorName));
        }
        if (!descriptor.isApplicableIn((ItemGroup)p)) {
            throw new ServiceException.ForbiddenException(String.format("Failed to create pipeline: %s. Pipeline can't be created in Jenkins root folder", name));
        }
        if (!acl.hasCreatePermission2(a, (ItemGroup)p, descriptor)) {
            throw new ServiceException.ForbiddenException("Missing permission: " + String.valueOf(Item.CREATE.group.title) + "/" + Item.CREATE.name + " " + String.valueOf(Item.CREATE) + "/" + descriptor.getDisplayName());
        }
        return p.createProject(descriptor, name, true);
    }

    protected User checkUserIsAuthenticatedAndHasItemCreatePermission(BlueOrganization organization) {
        ACL acl;
        ModifiableTopLevelItemGroup p = this.getParent(organization);
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("Must be logged in to create a pipeline");
        }
        Authentication authentication = Jenkins.getAuthentication2();
        ACL aCL = acl = p instanceof AccessControlled ? ((AccessControlled)p).getACL() : Jenkins.get().getACL();
        if (!acl.hasPermission2(authentication, Item.CREATE)) {
            throw new ServiceException.ForbiddenException(String.format("User %s doesn't have Job create permission", authenticatedUser.getId()));
        }
        return authenticatedUser;
    }

    protected abstract String computeCredentialId(BlueScmConfig var1);

    protected ModifiableTopLevelItemGroup getParent(BlueOrganization organization) {
        ModifiableTopLevelItemGroup m = OrganizationFactory.getItemGroup((BlueOrganization)organization);
        return m != null ? m : Jenkins.get();
    }
}

