/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.jira;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.model.JiraIssue;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import io.jenkins.blueocean.service.embedded.jira.BlueJiraIssue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class JiraSCMListener
extends SCMListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraSCMListener.class);

    public void onChangeLogParsed(Run<?, ?> run, SCM scm, TaskListener listener, ChangeLogSet<?> changelog) throws Exception {
        try {
            Set issuesFromJqlSearch;
            JiraSite jiraSite = JiraSite.get((Job)run.getParent());
            if (jiraSite == null) {
                return;
            }
            Collection<String> issueKeys = JiraSCMListener.getIssueKeys(changelog, jiraSite.getIssuePattern());
            if (issueKeys.isEmpty()) {
                return;
            }
            String jql = JiraSCMListener.constructJQLQuery(issueKeys);
            JiraSession session = jiraSite.getSession();
            if (session == null) {
                return;
            }
            List issues = session.getIssuesFromJqlSearch(jql);
            Set set = issuesFromJqlSearch = issues == null ? Collections.emptySet() : issues.stream().map(JiraIssue::new).collect(Collectors.toSet());
            if (issuesFromJqlSearch.isEmpty()) {
                return;
            }
            JiraBuildAction action = (JiraBuildAction)run.getAction(JiraBuildAction.class);
            if (action == null) {
                run.addAction((Action)new JiraBuildAction(run, issuesFromJqlSearch));
            } else {
                action.addIssues(issuesFromJqlSearch);
            }
            run.save();
        }
        catch (Exception e) {
            LOGGER.warn("Failure executing Jira query to fetch issues. Skipping recording Jira issues.: {}", (Object)e.getMessage());
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    static String constructJQLQuery(Collection<String> issueKeys) {
        StringBuilder jql = new StringBuilder();
        jql.append("key in (");
        Iterator<String> iterator = issueKeys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            jql.append("'");
            jql.append(key);
            jql.append("'");
            if (!iterator.hasNext()) continue;
            jql.append(",");
        }
        jql.append(")");
        return jql.toString();
    }

    static Collection<String> getIssueKeys(ChangeLogSet<?> changelog, Pattern issuePattern) {
        HashSet<String> issueKeys = new HashSet<String>();
        for (ChangeLogSet.Entry entry : changelog) {
            issueKeys.addAll(BlueJiraIssue.findIssueKeys(entry.getMsg(), issuePattern));
        }
        return issueKeys;
    }
}

