/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.User;
import hudson.remoting.Base64;
import io.jenkins.blueocean.blueocean_git_pipeline.GitBareRepoReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitFile;
import io.jenkins.blueocean.blueocean_git_pipeline.GitReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitScm;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.impl.pipeline.ScmContentProvider;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.scm.GitContent;
import io.jenkins.blueocean.ssh.UserSSHKeyManager;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import jenkins.branch.MultiBranchProject;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.StaplerRequest2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitReadSaveService
extends ScmContentProvider {
    private static final Logger logger = LoggerFactory.getLogger(GitReadSaveService.class);
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="TYPE is mutated by setType https://github.com/spotbugs/spotbugs/issues/2044")
    @NonNull
    private static ReadSaveType TYPE = ReadSaveType.DEFAULT;

    @NonNull
    public String getScmId() {
        return "git";
    }

    public String getApiUrl(@NonNull Item item) {
        if (item instanceof WorkflowMultiBranchProject) {
            MultiBranchProject mbp = (MultiBranchProject)item;
            return mbp.getSCMSources().stream().filter(s -> s instanceof GitSCMSource).map(s -> ((GitSCMSource)s).getRemote()).findFirst().orElse(null);
        }
        return null;
    }

    public static void setType(@NonNull ReadSaveType type) {
        TYPE = type;
    }

    static GitReadSaveRequest makeSaveRequest(Item item, String branch, String commitMessage, String sourceBranch, String filePath, byte[] contents, User user) {
        String defaultBranch = "master";
        GitSCMSource gitSource = null;
        if (item instanceof MultiBranchProject) {
            MultiBranchProject mbp = (MultiBranchProject)item;
            for (SCMSource s : mbp.getSCMSources()) {
                if (!(s instanceof GitSCMSource)) continue;
                gitSource = (GitSCMSource)s;
            }
        }
        if (gitSource != null) {
            gitSource = new GitSCMSource(gitSource.getRemote()){

                protected StandardUsernameCredentials getCredentials() {
                    User current = User.current();
                    if (current == null) {
                        return super.getCredentials();
                    }
                    return UserSSHKeyManager.getOrCreate(current);
                }
            };
        }
        return new GitBareRepoReadSaveRequest((AbstractGitSCMSource)gitSource, StringUtils.defaultIfEmpty((String)branch, (String)defaultBranch), commitMessage, StringUtils.defaultIfEmpty((String)sourceBranch, (String)defaultBranch), filePath, contents);
    }

    private GitReadSaveRequest makeSaveRequest(Item item, StaplerRequest2 req) {
        String branch = req.getParameter("branch");
        return GitReadSaveService.makeSaveRequest(item, branch, req.getParameter("commitMessage"), (String)ObjectUtils.defaultIfNull((Object)req.getParameter("sourceBranch"), (Object)branch), req.getParameter("path"), Base64.decode((String)req.getParameter("contents")), User.current());
    }

    private GitReadSaveRequest makeSaveRequest(Item item, JSONObject json) {
        JSONObject content = json.getJSONObject("content");
        String branch = content.getString("branch");
        return GitReadSaveService.makeSaveRequest(item, branch, content.getString("message"), content.has("sourceBranch") ? content.getString("sourceBranch") : branch, content.getString("path"), Base64.decode((String)content.getString("base64Data")), User.current());
    }

    public Object getContent(@NonNull StaplerRequest2 req, @NonNull Item item) {
        item.checkPermission(Item.READ);
        User user = User.current();
        if (user == null) {
            throw new ServiceException.UnauthorizedException("Not authenticated");
        }
        GitReadSaveRequest r = this.makeSaveRequest(item, req);
        try {
            byte[] reqData = r.read();
            String encoded = Base64.encode((byte[])reqData);
            GitContent content = new GitContent(r.filePath, user.getId(), r.gitSource.getRemote(), r.filePath, (Number)0, "sha", encoded, "", r.branch, r.sourceBranch, Boolean.valueOf(true), "");
            GitFile gitFile = new GitFile(content);
            return gitFile;
        }
        catch (ServiceException.UnauthorizedException e) {
            throw new ServiceException.PreconditionRequired("Invalid credential", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Unable to get file content", (Throwable)e);
        }
    }

    public Object saveContent(@NonNull StaplerRequest2 req, @NonNull Item item) {
        item.checkPermission(Item.CONFIGURE);
        User user = User.current();
        if (user == null) {
            throw new ServiceException.UnauthorizedException("Not authenticated");
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)IOUtils.toString((Reader)req.getReader()));
            GitReadSaveRequest r = this.makeSaveRequest(item, json);
            r.save();
            return new GitFile(new GitContent(r.filePath, user.getId(), r.gitSource.getRemote(), r.filePath, (Number)0, "sha", null, "", r.branch, r.sourceBranch, Boolean.valueOf(true), ""));
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Unable to save file content", (Throwable)e);
        }
    }

    public boolean support(@NonNull Item item) {
        return this.getApiUrl(item) != null;
    }

    @NonNull
    protected StandardUsernamePasswordCredentials getCredentialForUser(@NonNull Item item, @NonNull String repositoryUrl) {
        User user = User.current();
        if (user == null) {
            throw new ServiceException.UnauthorizedException("No logged in user found");
        }
        String credentialId = GitScm.makeCredentialId(repositoryUrl);
        StandardUsernamePasswordCredentials credential = null;
        if (credentialId != null) {
            credential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        }
        if (credential == null) {
            throw new ServiceException.UnauthorizedException("No credential found for " + credentialId + " for user " + user.getDisplayName());
        }
        return credential;
    }

    public static enum ReadSaveType {
        CLONE,
        CACHE_CLONE,
        CACHE_BARE;

        static final ReadSaveType DEFAULT;

        static ReadSaveType get(String type) {
            ReadSaveType readSaveType;
            if (type != null && (readSaveType = ReadSaveType.valueOf(type.toUpperCase(Locale.ENGLISH))) != CACHE_BARE) {
                logger.warn("CLONE/CACHE_CLONE options are not supported anymore. Using default option CACHE_BARE instead.");
            }
            return DEFAULT == null ? CACHE_BARE : DEFAULT;
        }

        static {
            DEFAULT = ReadSaveType.get(System.getProperty("blueocean.features.GIT_READ_SAVE_TYPE"));
        }
    }
}

