/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.events;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Queue;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.JobChannelMessage;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageEnricher;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class BlueMessageEnricher
extends MessageEnricher {
    private static final Logger LOGGER = Logger.getLogger(BlueMessageEnricher.class.getName());

    public void enrich(@NonNull Message message) {
        try {
            this.maybeEnrichMessage(message);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to enrich message: " + e.getMessage(), e);
        }
    }

    private void maybeEnrichMessage(@NonNull Message message) {
        String channelName = message.getChannelName();
        if (channelName.equals("job") && message instanceof JobChannelMessage) {
            ItemGroup parent;
            JobChannelMessage jobChannelMessage = (JobChannelMessage)message;
            Item jobChannelItem = jobChannelMessage.getJobChannelItem();
            if (jobChannelItem == null) {
                return;
            }
            Link jobUrl = LinkResolver.resolveLink((Object)jobChannelItem);
            if (jobUrl == null) {
                return;
            }
            BlueOrganization org = OrganizationFactory.getInstance().getContainingOrg(jobChannelItem);
            if (org != null) {
                message.set((Enum)EventProps.Jenkins.jenkins_org, org.getName());
            }
            jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_rest_url, jobUrl.getHref());
            jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_pipeline_name, AbstractPipelineImpl.getFullName((BlueOrganization)org, (Item)jobChannelItem));
            if (jobChannelItem instanceof WorkflowJob && (parent = jobChannelItem.getParent()) instanceof WorkflowMultiBranchProject) {
                String multiBranchProjectName = AbstractPipelineImpl.getFullName((BlueOrganization)org, (Item)((WorkflowMultiBranchProject)parent));
                jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_pipeline_name, multiBranchProjectName);
                jobChannelMessage.set((Enum)BlueEventProps.blueocean_job_branch_name, jobChannelItem.getName());
            }
            if (message.containsKey((Object)"job_run_queueId") && jobChannelItem instanceof Job) {
                String buildNumberStr;
                String queueIdStr = message.get("job_run_queueId");
                if (queueIdStr == null) {
                    return;
                }
                long queueId = Long.parseLong(queueIdStr);
                Queue.Item queueItem = Jenkins.get().getQueue().getItem(queueId);
                if (queueItem == null) {
                    return;
                }
                Job job = (Job)jobChannelItem;
                BlueQueueItem blueQueueItem = QueueUtil.getQueuedItem(null, (Queue.Item)queueItem, (Job)job);
                if (blueQueueItem != null) {
                    jobChannelMessage.set((Enum)BlueEventProps.blueocean_queue_item_expected_build_number, Integer.toString(blueQueueItem.getExpectedBuildNumber()));
                } else if (message.get("job_run_status") != null && StringUtils.isNotBlank((CharSequence)(buildNumberStr = message.get("jenkins_object_id")))) {
                    jobChannelMessage.set((Enum)BlueEventProps.blueocean_queue_item_expected_build_number, message.get("jenkins_object_id"));
                }
            }
        }
    }

    static enum BlueEventProps {
        blueocean_job_rest_url,
        blueocean_job_pipeline_name,
        blueocean_job_branch_name,
        blueocean_queue_item_expected_build_number;

    }
}

