[{"id":"node_modules/@jenkins-cd/js-modules/js/ModuleSpec.js","source":"var Version = require('./Version');\n\nfunction ModuleSpec(qName) {\n    var qNameTokens = qName.split(\":\");\n    \n    if (qNameTokens.length === 2) {\n        var namespace = qNameTokens[0].trim();\n        var nsTokens = namespace.split(\"/\");\n        var namespaceProvider = undefined;\n        if (nsTokens.length === 2) {\n            namespaceProvider = nsTokens[0].trim();\n            namespace = nsTokens[1].trim();\n            if (namespaceProvider !== 'plugin' && namespaceProvider !== 'core-assets') {\n                console.error('Unsupported module namespace provider \"' + namespaceProvider + '\". Setting to undefined.');\n                namespaceProvider = undefined;\n            }\n        }\n        \n        var npmName = parseNPMName(qNameTokens[1].trim());\n        \n        this.nsProvider = namespaceProvider;\n        this.namespace = namespace;\n        this.moduleName = npmName.name;\n        this.moduleVersion = npmName.version;\n    } else {\n        // The module/bundle is not in a namespace and doesn't\n        // need to be loaded i.e. it will load itself and export.\n        var npmName = parseNPMName(qNameTokens[0].trim());\n\n        this.moduleName = npmName.name;\n        this.moduleVersion = npmName.version;\n    }\n\n    // Attach version compatibility info\n    var versions = [];\n    \n    if (this.moduleVersion) {\n        var moduleVersionTokens = this.moduleVersion.split(/[,|]+/);\n\n        for (var i = 0; i < moduleVersionTokens.length; i++) {\n            var moduleVersionToken = moduleVersionTokens[i].trim();\n            var parsedVersion = new Version(moduleVersionToken);\n            versions.push(parsedVersion);\n        }\n    }\n    \n    this.moduleCompatVersions = versions;\n}\n\nModuleSpec.prototype.getLoadBundleVersion = function() {\n    if (this.moduleCompatVersions.length === 0) {\n        // If no versions were specified on the name, then we\n        // just return undefined.\n        return undefined;\n    }\n    // If a version is specified, we use the first \"specific\" version\n    // e.g. \"1.1.2\" is specific while \"1.1.x\" and \"any\" are not.\n    for (var i = 0; i < this.moduleCompatVersions.length; i++) {\n        var version = this.moduleCompatVersions[i];\n        if (version.isSpecific()) {\n            return version;\n        }\n    }\n    \n    // If there's no specific version then we return the first\n    // version in the list.\n    return this.moduleCompatVersions[0];\n};\n\nModuleSpec.prototype.getLoadBundleName = function() {\n    var version = this.getLoadBundleVersion();\n    if (version) {\n        return this.moduleName + '@' + version.asBaseVersionString();\n    } else {\n        return this.moduleName;\n    }\n};\n\nModuleSpec.prototype.importAs = function() {\n    if (this.moduleName.charAt(0) === '.') {\n        return this.moduleName;\n    }\n    \n    var version = this.getLoadBundleVersion();\n    var importName = normalizePackageName(this.moduleName);\n    var importNS = this.namespace;\n    \n    if (!importNS) {\n        importNS = importName;\n    }\n    \n    var importAs = importNS + ':' + importName;\n    if (this.nsProvider) {\n        importAs = this.nsProvider + '/' + importAs;\n    }\n    if (version) {\n        importAs += '@' + version.asBaseVersionString();\n    }\n    \n    return importAs;\n};\n\nModuleSpec.prototype.getLoadBundleFileNamePrefix = function() {\n    var version = this.getLoadBundleVersion();\n    var normalizedName = normalizePackageName(this.moduleName);\n    if (version) {\n        // If a version was specified then we only do the script load if a\n        // specific version was provided i.e. loading does not get triggered\n        // by imports that specify non-specific version numbers e.g. \"any\"\n        // or \"1.2.x\". A specific version number would be e.g. \"1.2.3\" i.e.\n        // fully qualified. When loading is not triggered, the import is depending\n        // on another import (with a specific version) or on a bundle do an\n        // export of an internal dependency i.e. on another bundle \"providing\"\n        // the module be exporting it.\n        if (version.isSpecific()) {\n            return normalizedName + '-' + version.asLoadVersionString();\n        } else {\n            return undefined;\n        }\n    } else {\n        return normalizedName;\n    }\n};\n\n/**\n * Normalize an NPM package name by removing all non alpha numerics and replacing\n * with hyphens.\n * @param packageName The NPM package name.\n * @returns The normalized NPM package name.\n */\nfunction normalizePackageName(packageName) {\n    packageName = packageName.replace(/[^\\w.]/g, \"-\"); // replace non alphanumerics.\n    if (packageName.charAt(0) === '-') {\n        packageName = packageName.substring(1);\n    }\n    return packageName;\n};\n\nfunction parseNPMName(resourceName) {\n    if (resourceName.length > 1) {\n        var npmName = {};\n        var orgSlashIndex = resourceName.indexOf('/');\n        \n        if (resourceName.charAt(0) === '@' && orgSlashIndex > 0) {\n            // It's an NPM org package. Strip off the org and package\n            // and add it to the name. We'll get the rest then and parse\n            // that.\n            npmName.name = resourceName.substring(0, orgSlashIndex + 1);\n            \n            // Remove the org part from the name and continue parsing.\n            resourceName = resourceName.substring(orgSlashIndex + 1);\n        } else {\n            // Initialise it so we can append to it below.\n            npmName.name = '';\n        }\n        \n        var versionIndex = resourceName.indexOf('@');\n        if (versionIndex > 0) {\n            npmName.name += resourceName.substring(0, versionIndex);\n            npmName.version = resourceName.substring(versionIndex + 1);\n        } else {\n            npmName.name += resourceName;\n        }\n        \n        return npmName;\n    } else {\n        return {\n            name: resourceName\n        }\n    }\n}\n\nmodule.exports = ModuleSpec;","deps":{"./Version":"node_modules/@jenkins-cd/js-modules/js/Version.js"}},{"id":"node_modules/@jenkins-cd/js-modules/js/ResourceLocationResolver.js","source":"function ResourceLocationResolver(canResolveFunc, resolverFunc, ordinal) {\n    this.canResolveFunc = canResolveFunc;\n    this.resolverFunc = resolverFunc;\n    // Use an ordinal for crude ordering\n    if (typeof ordinal === 'number') {\n        this.ordinal = ordinal;\n    } else {\n        this.ordinal = Number.MAX_VALUE;\n    }\n}\n\nResourceLocationResolver.prototype.canResolve = function(moduleSpec) {\n    return this.canResolveFunc(moduleSpec);\n};\n\nResourceLocationResolver.sort = function (resolvers) {\n    resolvers.sort(function(r1, r2) {\n        return r2.ordinal - r1.ordinal;\n    });\n};\n\nmodule.exports = ResourceLocationResolver;","deps":{}},{"id":"node_modules/@jenkins-cd/js-modules/js/Version.js","source":"function Version(version) {\n    this.raw = version;\n\n    // Remove leading non alphanum chars e.g. to\n    // convert \"^1.2.3\" to \"1.2.3\". If the version is something\n    // like \"any\" then the string will be trimmed to nothing and\n    // the next check catches it.\n    version = version.replace(/^(\\D)/, \"\");\n    \n    if (!version || version.length === 0) {\n        return;\n    }\n    \n    function normalizeToken(string) {\n        // remove anything that's not a digit, a dot or an x.\n        var normalized = string.replace(/[^\\d]/g, '');\n        if (normalized === '') {\n            return undefined;\n        }\n        return normalized;\n    }\n    \n    var versionTokens = version.split('.');\n    \n    this.prerelease = undefined;\n    \n    var patchAndPrerelease = '';\n    for (var i = 2; i < versionTokens.length; i++) {\n        if (patchAndPrerelease.length > 0) {\n            patchAndPrerelease += '.';\n        }\n        patchAndPrerelease += versionTokens[i];\n        \n        var separatorIdx = patchAndPrerelease.indexOf('-');\n        if (separatorIdx !== -1) {\n            this.patch = normalizeToken(patchAndPrerelease.substring(0, separatorIdx));\n            this.prerelease = patchAndPrerelease.substring(separatorIdx + 1);\n        } else {\n            this.patch = normalizeToken(patchAndPrerelease);\n        }\n    }\n    \n    if (versionTokens.length >= 2) {\n        this.minor = normalizeToken(versionTokens[1]);\n    }\n    if (versionTokens.length >= 1) {\n        this.major = normalizeToken(versionTokens[0]);\n    }    \n}\n\nVersion.prototype.isSpecific = function() {\n    return (this.major !== undefined && this.minor !== undefined && this.patch !== undefined);\n};\n\n/**\n * Get the \"base\" version string for this version number.\n * <p/>\n * This string should only ever include the major, minor and patch tokens\n * of the version i.e. should never include a prerelease tag.\n * @returns {string}\n */\nVersion.prototype.asBaseVersionString = function(separator) {\n    separator = (separator ? separator : '.');\n    \n    if (!this.major || this.major === 'x') {\n        if (this.raw === 'any') {\n            return this.raw;\n        } else {\n            return undefined;\n        }\n    } else if (!this.minor || this.minor === 'x') {\n        return this.major + separator + 'x';\n    } else if (!this.patch || this.patch === 'x') {\n        return this.major + separator + this.minor + separator + 'x';\n    } else {\n        return this.major + separator + this.minor + separator + this.patch;\n    }\n};\n\n/**\n * Get the load version string for this version number.\n * <p/>\n * This string should only ever include the major, minor and patch tokens\n * of the version i.e. should never include a prerelease tag. This function\n * just calls <code>asBaseVersionString</code>, supplying a hyphen as the\n * separator.\n * @returns {string}\n */\nVersion.prototype.asLoadVersionString = function() {\n    return this.asBaseVersionString('-');\n};\n\nmodule.exports = Version;","deps":{}},{"id":"node_modules/@jenkins-cd/js-modules/js/index.js","source":"var internal = require(\"./internal\");\nvar promise = require(\"./promise\");\nvar ModuleSpec = require('./ModuleSpec');\nvar onRegisterTimeout;\nvar whoami;\n\n/**\n * What's the top level module/bundle name.\n * @param moduleQName The module QName.\n * @returns The module QName, or undefined if unknown.\n */\nexports.whoami = function(moduleQName) {\n    if (moduleQName) {\n        whoami = moduleQName;\n        internal.whoami(whoami);\n    }\n    return whoami;\n};\n\n/**\n * Asynchronously import/require a set of modules.\n *\n * <p>\n * Responsible for triggering the async loading of modules if a given module is not already loaded.\n *\n * @param moduleQNames... A list of module \"qualified\" names, each containing the module name prefixed with the namespace\n * and separated by a colon i.e. \"<namespace>:<moduleName>\" e.g. \"jquery:jquery2\".\n *\n * @return A Promise, allowing async load of all modules. The promise is only fulfilled when all modules are loaded.\n */\nexports.importModule = function() {\n    if (arguments.length === 1) {\n        return internal.importModule(arguments[0], onRegisterTimeout);\n    }\n\n    var moduleQNames = [];\n    for (var i = 0; i < arguments.length; i++) {\n        var argument = arguments[i];\n        if (typeof argument === 'string') {\n            moduleQNames.push(argument);\n        }\n    }\n\n    if (moduleQNames.length == 0) {\n        throw new Error(\"No module names specified.\");\n    }\n\n    return promise.make(function (resolve, reject) {\n        var fulfillments = [];\n\n        function onFulfillment() {\n            if (fulfillments.length === moduleQNames.length) {\n                var modules = [];\n                for (var i = 0; i < fulfillments.length; i++) {\n                    if (fulfillments[i].value) {\n                        modules.push(fulfillments[i].value);\n                    } else {\n                        // don't have everything yet so can't fulfill all.\n                        return;\n                    }\n                }\n                // If we make it here, then we have fulfilled all individual promises, which \n                // means we can now fulfill the top level import promise.\n                resolve(modules);\n            }\n        }\n\n        // doRequire for each module\n        for (var i = 0; i < moduleQNames.length; i++) {\n            function doRequire(moduleQName) {\n                var promise = internal.importModule(moduleQName, onRegisterTimeout);\n                var fulfillment = {\n                    promise: promise,\n                    value: undefined\n                };\n                fulfillments.push(fulfillment);\n                promise\n                    .onFulfilled(function(value) {\n                        fulfillment.value = value;\n                        onFulfillment();\n                    })\n                    .onRejected(function(error) {\n                        reject(error);\n                    });\n            }\n            doRequire(moduleQNames[i]);\n        }\n    }).applyArgsOnFulfill();\n};\n\n/**\n * Synchronously \"require\" a module that it already loaded/registered.\n *\n * <p>\n * This function will throw an error if the module is not already loaded via an outer call to 'import'\n * (or 'import').\n *\n * @param moduleQName The module \"qualified\" name containing the module name prefixed with the namespace\n * separated by a colon i.e. \"<namespace>:<moduleName>\" e.g. \"jquery:jquery2\".\n *\n * @return The module.\n */\nexports.requireModule = function(moduleQName) {\n    var parsedModuleName = new ModuleSpec(moduleQName);\n    var module = internal.getModule(parsedModuleName);\n    if (!module) {\n        throw new Error(\"Unable to perform synchronous 'require' for module '\" + moduleQName + \"'. This module is not pre-loaded. \" +\n            \"The module needs to have been asynchronously pre-loaded via an outer call to 'import'.\");\n    }\n    return module.exports;\n};\n\n/**\n * Export a module.\n *\n * @param namespace The namespace in which the module resides, or \"undefined\" if the modules is in\n * the \"global\" module namespace e.g. a Jenkins core bundle.\n * @param moduleName The name of the module.\n * @param module The CommonJS style module, or \"undefined\" if we just want to notify other modules waiting on\n * the loading of this module.\n * @param onError On error callback;\n */\nexports.exportModule = function(namespace, moduleName, module, onError) {\n    try {\n        var moduleQName = (namespace ? namespace + ':' : '') + moduleName;\n        var moduleSpec = new ModuleSpec(moduleQName);\n        var moduleNamespaceObj = internal.getModuleNamespaceObj(moduleSpec);\n        var moduleLoadName = moduleSpec.getLoadBundleName();\n\n        if (moduleNamespaceObj[moduleLoadName]) {\n            if (namespace) {\n                console.debug(\"Jenkins plugin module '\" + namespace + \":\" + moduleName + \"' already registered.\");\n            } else {\n                console.debug(\"Jenkins global module '\" + moduleName + \"' already registered.\");\n            }\n            return;\n        }\n\n        if (!module) {\n            module = {\n                exports: {}\n            };\n        } else if (module.exports === undefined) {\n            module = {\n                exports: module\n            };\n        }\n        moduleNamespaceObj[moduleLoadName] = module;\n\n        // Notify all that the module has been registered. See internal.loadModule also.\n        internal.notifyModuleExported(moduleSpec, module.exports);\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Add a resource resolver.\n * @param {ResourceLocationResolver} resourceLocationResolver The resource resolver.\n */\nexports.addResourceLocationResolver = function(resourceLocationResolver) {\n    internal.addResourceLocationResolver(resourceLocationResolver);\n};\n\n/**\n * Get the ResourceLocationResolver function for the supplied ModuleSpec.\n * @param {ModuleSpec} moduleSpec The ModuleSpec.\n * @returns {function} The ResourceLocationResolver function for the supplied\n * ModuleSpec, or null if none specified.\n */\nexports.getResourceLocationResolver = function (moduleSpec) {\n    if (typeof moduleSpec === 'string') {\n        moduleSpec = new ModuleSpec(moduleSpec);\n    }\n    var resolver = internal.getResourceLocationResolverFunc(moduleSpec);\n    if (resolver) {\n        return function(resourcePath) {\n            return resolver(moduleSpec, resourcePath);\n        }\n    }\n    return undefined;\n};\n\n/**\n * Add a module's CSS to the browser page.\n *\n * <p>\n * The assumption is that the CSS can be accessed at e.g.\n * {@code <rootURL>/plugin/<namespace>/jsmodules/<moduleName>/style.css} i.e.\n * the pluginId acts as the namespace.\n *\n * @param namespace The namespace in which the module resides.\n * @param moduleName The name of the module.\n * @param onError On error callback;\n */\nexports.addModuleCSSToPage = function(namespace, moduleName, onError) {\n    try {\n        internal.addModuleCSSToPage(namespace, moduleName);\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Add a plugin CSS file to the browser page.\n *\n * @param pluginName The Jenkins plugin in which the module resides.\n * @param cssPath The CSS path.\n * @param onError On error callback;\n */\nexports.addPluginCSSToPage = function(pluginName, cssPath, onError) {\n    try {\n        internal.addPluginCSSToPage(pluginName, cssPath);\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Create a js-modules CSS id that can be used to refer to a link element.\n * @param cssPath The CSS path/url.\n * @param namespace Optional namespace.\n */\nexports.toCSSId = function (cssPath, namespace) {\n    return internal.toCSSId(cssPath, namespace);\n};\n\n/**\n * Add CSS file to the browser page.\n *\n * @param cssPath The CSS path.\n * @param onError On error callback;\n */\nexports.addCSSToPage = function(cssPath, onError) {\n    try {\n        if (cssPath.indexOf(internal.getAdjunctURL()) === 0) {\n            internal.addCSSToPage(undefined, cssPath);\n        } else if (cssPath.indexOf('http://') === 0 || cssPath.indexOf('https://') === 0) {\n            // the css path is already fully qualified\n            internal.addCSSToPage(undefined, cssPath);\n        } else {\n            internal.addCSSToPage(undefined, internal.getRootURL() + '/' + cssPath);\n        }\n    } catch (e) {\n        console.error(e);\n        if (onError) {\n            onError(e);\n        }\n    }\n};\n\n/**\n * Add a javascript &lt;script&gt; element to the document &lt;head&gt;.\n * <p/>\n * Options:\n * <ul>\n *     <li><strong>scriptId</strong>: The script Id to use for the element. If not specified, one will be generated from the scriptSrc.</li>\n *     <li><strong>async</strong>: Asynchronous loading of the script. Default is 'true'.</li>\n *     <li><strong>success</strong>: An optional onload success function for the script element.</li>\n *     <li><strong>error</strong>: An optional onload error function for the script element. This is called if the .js file exists but there's an error evaluating the script. It is NOT called if the .js file doesn't exist (ala 404).</li>\n *     <li><strong>removeElementOnLoad</strong>: Remove the script element after loading the script. Default is 'false'.</li>\n * </ul>\n *\n * @param scriptSrc The script src.\n * @param options Optional script load options object. See above.\n */\nexports.addScript = function(scriptSrc, options) {\n    internal.addScript(scriptSrc, options);\n};\n\n/**\n * Set the module registration timeout i.e. the length of time to wait for a module to load before failing.\n *\n * @param timeout Millisecond duration before onRegister times out. Defaults to 10000 (10s) if not specified.\n */\nexports.setRegisterTimeout = function(timeout) {\n    onRegisterTimeout = timeout;\n}\n\n/**\n * Set the Jenkins root/base URL.\n *\n * @param rootUrl The root/base URL.\n */\nexports.setRootURL = function(rootUrl) {\n    internal.setRootURL(rootUrl);\n};\n\nexports.getRootURL = internal.getRootURL;\nexports.getAdjunctURL = internal.getAdjunctURL;\n\n/**\n * Manually initialise the Jenkins Global.\n * <p>\n * This should only ever be called from a test environment.\n */\nexports.initJenkinsGlobal = function() {\n    internal.initJenkinsGlobal();\n};\n\ninternal.onJenkinsGlobalInit(function(jenkinsCIGlobal) {\n    // For backward compatibility, we need to make some js-modules\n    // functions globally available e.g. to allow legacy code wait for\n    // certain modules to be loaded, as with legacy adjuncts.\n    if (!jenkinsCIGlobal._internal) {\n        // Put the functions on an object called '_internal' as a way\n        // of hinting to people to not use it.\n        jenkinsCIGlobal._internal = {\n            importModule: exports.importModule,\n            addScript: internal.addScript\n        };\n    }\n});","deps":{"./ModuleSpec":"node_modules/@jenkins-cd/js-modules/js/ModuleSpec.js","./internal":"node_modules/@jenkins-cd/js-modules/js/internal.js","./promise":"node_modules/@jenkins-cd/js-modules/js/promise.js"}},{"id":"node_modules/@jenkins-cd/js-modules/js/internal.js","source":"var promise = require(\"./promise\");\nvar ModuleSpec = require('./ModuleSpec');\nvar ResourceLocationResolver = require('./ResourceLocationResolver');\n\nvar jenkinsCIGlobal;\nvar globalInitListeners = [];\nvar whoami;\n\nexports.whoami = function(moduleQName) {\n    if (moduleQName) {\n        whoami = new ModuleSpec(moduleQName);\n        whoami.nsProvider = getBundleNSProviderFromScriptElement(whoami.namespace, whoami.moduleName);\n    }\n    return whoami;\n};\n\nexports.onJenkinsGlobalInit = function(callback) {\n    globalInitListeners.push(callback);\n};\n\nexports.initJenkinsGlobal = function() {\n    jenkinsCIGlobal = {\n    };\n    if (globalInitListeners) {\n        for (var i = 0; i < globalInitListeners.length; i++) {\n            globalInitListeners[i](jenkinsCIGlobal);\n        }\n    }\n};\n\nexports.clearJenkinsGlobal = function() {    \n    jenkinsCIGlobal = undefined;\n    whoami = undefined;\n};\n\nexports.addResourceLocationResolver = function(resourceLocationResolver) {\n    var resolvers = getResourceLocationResolvers();\n    resolvers.push(resourceLocationResolver);\n    ResourceLocationResolver.sort(resolvers);\n};\n\nexports.getJenkins = function() {\n    if (jenkinsCIGlobal) {\n        return jenkinsCIGlobal;\n    }\n    if (window.jenkinsCIGlobal) {\n        jenkinsCIGlobal = window.jenkinsCIGlobal;\n    } else {\n        exports.initJenkinsGlobal();\n        jenkinsCIGlobal.rootURL = getRootURL();\n        window.jenkinsCIGlobal = jenkinsCIGlobal;\n    }   \n    return jenkinsCIGlobal;\n};\n\nexports.getModuleNamespaceObj = function(moduleSpec) {\n    if (moduleSpec.namespace) {\n        return exports.getNamespace(moduleSpec.namespace);\n    } else {\n        return exports.getGlobalModules();\n    }\n};\n\nexports.getNamespace = function(namespaceName) {\n    var namespaces = exports.getNamespaces();\n    var namespace = namespaces[namespaceName];\n    if (!namespace) {\n        namespace = {\n            globalNS: false            \n        };\n        namespaces[namespaceName] = namespace;\n    }\n    return namespace;\n};\n\nexports.importModule = function(moduleQName, onRegisterTimeout) {\n    return promise.make(function (resolve, reject) {\n        var moduleSpec = new ModuleSpec(moduleQName);\n        var module = exports.getModule(moduleSpec);\n\n        if (module) {\n            // module already loaded\n            resolve(module.exports);\n        } else {\n            if (onRegisterTimeout === 0) {\n                if (moduleSpec.namespace) {\n                    throw new Error('Module ' + moduleSpec.namespace + ':' + moduleSpec.moduleName + ' require failure. Async load mode disabled.');\n                } else {\n                    throw new Error('Global module ' + moduleSpec.moduleName + ' require failure. Async load mode disabled.');\n                }\n            }\n\n            // module not loaded. Load async, fulfilling promise once registered\n            exports.loadModule(moduleSpec, onRegisterTimeout)\n                .onFulfilled(function (moduleExports) {\n                    resolve(moduleExports);\n                })\n                .onRejected(function (error) {\n                    reject(error);\n                });\n        }\n    });    \n};\n\nexports.loadModule = function(moduleSpec, onRegisterTimeout) {\n    var module = exports.getModule(moduleSpec);\n    \n    if (module) {\n        // Module already loaded. This prob shouldn't happen.\n        console.log(\"Unexpected call to 'loadModule' for a module (\" + moduleSpec.moduleName + \") that's already loaded.\");\n        return promise.make(function (resolve) {\n            resolve(module.exports);\n        });\n    }\n\n    function waitForRegistration(loadingModule, onRegisterTimeout) {\n        return promise.make(function (resolve, reject) {\n            if (typeof onRegisterTimeout !== \"number\") {\n                onRegisterTimeout = 10000;\n            }\n            \n            var timeoutObj = setTimeout(function () {\n                // Timed out waiting on the module to load and register itself.\n                if (!loadingModule.loaded) {\n                    var moduleSpec = loadingModule.moduleSpec;\n                    var errorDetail;\n                    \n                    if (moduleSpec.namespace) {\n                        errorDetail = \"Timed out waiting on module '\" + moduleSpec.namespace + \":\" + moduleSpec.moduleName + \"' to load.\";\n                    } else {\n                        errorDetail = \"Timed out waiting on module '\" + moduleSpec.moduleName + \"' to load.\";\n                    }                    \n                    console.error('Module load failure: ' + errorDetail);\n\n                    // Call the reject function and tell it we timed out\n                    reject({\n                        reason: 'timeout',\n                        detail: errorDetail\n                    });\n                }\n            }, onRegisterTimeout);\n            \n            loadingModule.waitList.push({\n                resolve: resolve,\n                timeoutObj: timeoutObj\n            });                    \n        });\n    }\n\n    var loadVersion = moduleSpec.getLoadBundleVersion();\n    var doScriptLoad = true;\n    \n    if (loadVersion) {\n        // If a version was specified then we only do the script load if a\n        // specific version was provided i.e. loading does not get triggered\n        // by imports that specify non-specific version numbers e.g. \"any\"\n        // or \"1.2.x\". A specific version number would be e.g. \"1.2.3\" i.e.\n        // fully qualified. When loading is not triggered, the import is depending\n        // on another import (with a specific version) or on another bundle to do an\n        // export of an internal dependency i.e. on another bundle \"providing\"\n        // the module by exporting it.\n        doScriptLoad = loadVersion.isSpecific();\n    }\n\n    var loadingModule = getLoadingModule(moduleSpec);\n    if (!loadingModule.waitList) {\n        loadingModule.waitList = [];\n    }\n    loadingModule.moduleSpec = moduleSpec; \n    loadingModule.loaded = false;\n\n    try {\n        return waitForRegistration(loadingModule, onRegisterTimeout);\n    } finally {\n        if (doScriptLoad && !loadingModule.loadedBy) {\n            // Capture the name of the bundle that triggered importing/loading\n            // of the bundle.\n            loadingModule.loadedBy = whoami;\n\n            var loadModuleName = moduleSpec.getLoadBundleName();\n            var scriptId = exports.toModuleId(moduleSpec.namespace, loadModuleName) + ':js';\n            var scriptSrc = exports.toModuleSrc(moduleSpec, 'js');\n            var scriptEl = exports.addScript(scriptSrc, {\n                scriptId: scriptId,\n                scriptSrcBase: ''\n            });\n\n            if (scriptEl) {\n                // Set the module spec info on the <script> element. This allows us to resolve the\n                // nsProvider for that bundle after 'whoami' is called for it (as it loads). whoami\n                // is not called with the nsProvider info on it because a given bundle can\n                // potentially be loaded from multiple different ns providers, so we only resole the provider\n                // at load-time i.e. just after a bundle is loaded it calls 'whoami' for itself\n                // and then this module magically works out where it was loaded from (it's nsProvider)\n                // by locating the <script> element and using this information. For a module/bundle, knowing\n                // where it was loaded from is important because it dictates where that module/bundle\n                // should load it dependencies from. For example, the Bootstrap module/bundle depends on the\n                // jQuery bundle. So, if the bootstrap bundle is loaded from the 'core-assets' namespace provider,\n                // then that means the jQuery bundle should also be loaded from the 'core-assets'\n                // namespace provider.\n                // See getBundleNSProviderFromScriptElement.\n                scriptEl.setAttribute('data-jenkins-module-nsProvider', moduleSpec.nsProvider);\n                scriptEl.setAttribute('data-jenkins-module-namespace', moduleSpec.namespace);\n                scriptEl.setAttribute('data-jenkins-module-moduleName', loadModuleName);\n            } else {\n                loadingModule.loadedBy = undefined;\n            }\n        }\n    }\n};\n\nexports.addScript = function(scriptSrc, options) {\n    if (!scriptSrc) {\n        console.warn('Call to addScript with undefined \"scriptSrc\" arg.');\n        return undefined;\n    }    \n    \n    var normalizedOptions;\n    \n    // If there's no options object, create it.\n    if (typeof options === 'object') {\n        normalizedOptions = options;\n    } else {\n        normalizedOptions = {};\n    }\n    \n    // May want to transform/map some urls.\n    if (normalizedOptions.scriptSrcMap) {\n        if (typeof normalizedOptions.scriptSrcMap === 'function') {\n            scriptSrc = normalizedOptions.scriptSrcMap(scriptSrc);\n        } else if (Array.isArray(normalizedOptions.scriptSrcMap)) {\n            // it's an array of suffix mappings\n            for (var i = 0; i < normalizedOptions.scriptSrcMap.length; i++) {\n                var mapping = normalizedOptions.scriptSrcMap[i];\n                if (mapping.from && mapping.to) {\n                    if (endsWith(scriptSrc, mapping.from)) {\n                        normalizedOptions.originalScriptSrc = scriptSrc;\n                        scriptSrc = scriptSrc.replace(mapping.from, mapping.to);\n                        break;\n                    }\n                }\n            }\n        }\n    }\n    \n    normalizedOptions.scriptId = getScriptId(scriptSrc, options);\n    \n    // set some default options\n    if (normalizedOptions.async === undefined) {\n        normalizedOptions.async = true;\n    }\n    if (normalizedOptions.scriptSrcBase === undefined) {\n        normalizedOptions.scriptSrcBase = '@root';\n    }\n    \n    if (normalizedOptions.scriptSrcBase === '@root') {\n        normalizedOptions.scriptSrcBase = getRootURL() + '/';\n    } else if (normalizedOptions.scriptSrcBase === '@adjunct') {\n        normalizedOptions.scriptSrcBase = getAdjunctURL() + '/';\n    }\n\n    var document = window.document;\n    var head = exports.getHeadElement();\n    var script = document.getElementById(normalizedOptions.scriptId);\n\n    if (script) {\n        var replaceable = script.getAttribute('data-replaceable');\n        if (replaceable && replaceable === 'true') {\n            // This <script> element is replaceable. In this case, \n            // we remove the existing script element and add a new one of the\n            // same id and with the specified src attribute.\n            // Adding happens below.\n            script.parentNode.removeChild(script);\n        } else {\n            return undefined;\n        }\n    }\n\n    script = createElement('script');\n\n    // Parts of the following onload code were inspired by how the ACE editor does it,\n    // as well as from the follow SO post: http://stackoverflow.com/a/4845802/1166986\n    var onload = function (_, isAborted) {\n        script.setAttribute('data-onload-complete', true);\n        try {\n            if (isAborted) {\n                console.warn('Script load aborted: ' + scriptSrc);\n            } else if (!script.readyState || script.readyState === \"loaded\" || script.readyState === \"complete\") {\n                // If the options contains an onload function, call it.\n                if (typeof normalizedOptions.success === 'function') {\n                    normalizedOptions.success(script);\n                }\n                return;\n            }\n            if (typeof normalizedOptions.error === 'function') {\n                normalizedOptions.error(script, isAborted);\n            }\n        } finally {\n            if (normalizedOptions.removeElementOnLoad) {\n                head.removeChild(script);\n            }\n            // Handle memory leak in IE\n            script = script.onload = script.onreadystatechange = null;\n        }\n    };\n    script.onload = onload; \n    script.onreadystatechange = onload;\n\n    script.setAttribute('id', normalizedOptions.scriptId);\n    script.setAttribute('type', 'text/javascript');\n    script.setAttribute('src', normalizedOptions.scriptSrcBase + scriptSrc);\n    if (normalizedOptions.originalScriptSrc) {\n        script.setAttribute('data-referrer', normalizedOptions.originalScriptSrc);        \n    }\n    if (normalizedOptions.async) {\n        script.setAttribute('async', normalizedOptions.async);\n    }\n    \n    head.appendChild(script);\n    \n    return script;\n};\n\nexports.notifyModuleExported = function(moduleSpec, moduleExports) {\n    var loadingModule = getLoadingModule(moduleSpec);\n    \n    loadingModule.loaded = true;\n    if (loadingModule.waitList) {\n        for (var i = 0; i < loadingModule.waitList.length; i++) {\n            var waiter = loadingModule.waitList[i];\n            clearTimeout(waiter.timeoutObj);\n            waiter.resolve(moduleExports);\n        }\n    }    \n};\n\nexports.addModuleCSSToPage = function(namespace, moduleName) {\n    var moduleSpec = exports.getModuleSpec(namespace + ':' + moduleName);\n    var cssElId = exports.toModuleId(namespace, moduleName) + ':css';\n    var cssPath = exports.toModuleSrc(moduleSpec, 'css');\n    return exports.addCSSToPage(namespace, cssPath, cssElId);\n};\n\nexports.addPluginCSSToPage = function(namespace, cssPath, cssElId) {\n    var cssPath = exports.getPluginPath(namespace) + '/' + cssPath;\n    return exports.addCSSToPage(namespace, cssPath, cssElId);\n};\n\nexports.toCSSId = function (cssPath, namespace) {\n    return 'jenkins-js-module:' + (namespace || 'global' ) + ':css:' + cssPath;\n};\n\nexports.addCSSToPage = function(namespace, cssPath, cssElId) {\n    var document = window.document;\n    \n    if (cssElId === undefined) {\n        cssElId = exports.toCSSId(cssPath, namespace);\n    }\n    \n    var cssEl = document.getElementById(cssElId);\n    \n    if (cssEl) {\n        // already added to page\n        return;\n    }\n\n    var docHead = exports.getHeadElement();\n    cssEl = createElement('link');\n    cssEl.setAttribute('id', cssElId);\n    cssEl.setAttribute('type', 'text/css');\n    cssEl.setAttribute('rel', 'stylesheet');\n    cssEl.setAttribute('href', cssPath);\n    docHead.appendChild(cssEl);\n\n    return cssEl;\n};\n\nexports.getGlobalModules = function() {\n    var jenkinsCIGlobal = exports.getJenkins();\n    if (!jenkinsCIGlobal.globals) {\n        jenkinsCIGlobal.globals = {\n            globalNS: true\n        };\n    }\n    return jenkinsCIGlobal.globals;\n};\n\nexports.getNamespaces = function() {\n    var jenkinsCIGlobal = exports.getJenkins();\n\n    // The namespaces are stored in an object named \"plugins\". This is a legacy from the\n    // time when all modules lived in plugins. By right we'd like to rename this, but\n    // that would cause compatibility issues.\n\n    if (!jenkinsCIGlobal.plugins) {\n        jenkinsCIGlobal.plugins = {\n            __README__: 'This object holds namespaced JS modules/bundles, with the property names representing the module namespace. It\\'s name (\"plugins\") is a legacy thing. Changing it to a better name (e.g. \"namespaces\") would cause compatibility issues.'\n        };\n    }\n    return jenkinsCIGlobal.plugins;\n};\n\nexports.toModuleId = function(namespace, moduleName) {\n    return 'jenkins-js-module:' + (namespace ? namespace + ':' : '') + moduleName;\n};\n\nexports.toModuleSrc = function(moduleSpec, srcType) {\n    var nsProvider = moduleSpec.nsProvider;\n\n    // If a moduleSpec on a module/bundle import doesn't specify a namespace provider\n    // (i.e. is of the form \"a:b\" and not \"core-assets/a:b\"),\n    // then check \"this\" bundles module spec and see if it was imported from a specific\n    // namespace. If it was (e.g. 'core-assets'), then import from that namespace.\n    if (nsProvider === undefined) {\n        nsProvider = thisBundleNamespaceProvider();\n        if (nsProvider === undefined) {\n            nsProvider = 'adjuncts';\n        }\n        // Store the nsProvider back onto the moduleSpec.\n        moduleSpec.nsProvider = nsProvider;\n    }\n\n    var srcPath = undefined;\n    if (srcType === 'js') {\n        srcPath = moduleSpec.getLoadBundleFileNamePrefix() + '.js';\n    } else if (srcType === 'css') {\n        srcPath = moduleSpec.getLoadBundleFileNamePrefix() + '/style.css';\n    } else {\n        throw new Error('Unsupported srcType \"'+ srcType + '\".');\n    }\n\n    // Maybe there's a custom resource resolver for this resource.\n    var resourceLocationResolverFunc = getResourceLocationResolverFunc(moduleSpec);\n    if (resourceLocationResolverFunc) {\n        var resourcePath = resourceLocationResolverFunc(moduleSpec, srcPath);\n        if (resourcePath) {\n            return resourcePath;\n        }\n    }\n\n    // Default resource resolution ...\n    if (nsProvider === 'adjuncts') {\n        return exports.getAdjunctJSModulesPath(moduleSpec.namespace) + '/' + srcPath;\n    } else if (nsProvider === 'plugin') {\n        return exports.getPluginJSModulesPath(moduleSpec.namespace) + '/' + srcPath;\n    } else if (nsProvider === 'core-assets') {\n        return exports.getCoreAssetsJSModulesPath(moduleSpec.namespace) + '/' + srcPath;\n    } else {\n        throw new Error('Unsupported namespace provider: ' + nsProvider);\n    }\n};\n\nexports.getAdjunctJSModulesPath = function(namespace) {\n    if (namespace) {\n        return getAdjunctURL() + '/org/jenkins/ui/jsmodules/' + namespace;\n    } else {\n        return getAdjunctURL() + '/org/jenkins/ui/jsmodules';\n    }\n};\n\nexports.getPluginJSModulesPath = function(pluginId) {\n    return exports.getPluginPath(pluginId) + '/jsmodules';\n};\n\nexports.getCoreAssetsJSModulesPath = function(namespace) {\n    return getRootURL() + '/assets/' + namespace + '/jsmodules';\n};\n\nexports.getPluginPath = function(pluginId) {\n    return getRootURL() + '/plugin/' + pluginId;\n};\n\nexports.getHeadElement = function() {\n    var docHead = window.document.getElementsByTagName(\"head\");\n    if (!docHead || docHead.length == 0) {\n        throw new Error('No head element found in document.');\n    }\n    return docHead[0];\n};\n\nexports.setRootURL = function(url) {    \n    if (!jenkinsCIGlobal) {\n        exports.initJenkinsGlobal();\n    }\n    jenkinsCIGlobal.rootURL = url;\n};\n\nexports.getModule = function(moduleSpec) {\n    var namespace = exports.getModuleNamespaceObj(moduleSpec);\n    \n    if (!moduleSpec.moduleVersion) {\n        return namespace[moduleSpec.moduleName];\n    } else {\n        for (var i = 0; i < moduleSpec.moduleCompatVersions.length; i++) {\n            var moduleCompatVersion = moduleSpec.moduleCompatVersions[i];\n            var module = namespace[moduleSpec.moduleName + '@' + moduleCompatVersion.raw];\n            if (module) {\n                return module;\n            }\n        }\n    }\n    \n    return undefined;\n};\n\nexports.getModuleSpec = function(moduleQName) {\n    var moduleSpec = new ModuleSpec(moduleQName);\n    var moduleNamespaceObj = exports.getModuleNamespaceObj(moduleSpec);\n    if (moduleNamespaceObj) {\n        var loading = getLoadingModule(moduleSpec);\n        if (loading && loading.moduleSpec) {\n            return loading.moduleSpec;\n        }\n    }\n    return moduleSpec;\n};\n\nfunction getResourceLocationResolvers() {\n    var jenkinsCIGlobal = exports.getJenkins();\n    if (!jenkinsCIGlobal.resourceLocationResolvers) {\n        jenkinsCIGlobal.resourceLocationResolvers = [];\n    }\n    return jenkinsCIGlobal.resourceLocationResolvers;\n}\n\nfunction getResourceLocationResolverFunc(moduleSpec) {\n    var resolvers = getResourceLocationResolvers();\n\n    for (var i = 0; i < resolvers.length; i++) {\n        var resolver = resolvers[i];\n        if (resolver && resolver.canResolve(moduleSpec)) {\n            return resolver.resolverFunc;\n        }\n    }\n\n    // Failed to find a specific resolver for the supplied moduleSpec.\n    // In this case, lets try the resolver used to load the bundle\n    // that's currently loading this resource. Iow, resources should\n    // be loaded from the same location as the bundle that's triggering\n    // the loading of that resource. Obviously this is recursive up\n    // through the \"parents\".\n    var loadingModule = getLoadingModule(moduleSpec);\n    if (loadingModule.loadedBy) {\n        return getResourceLocationResolverFunc(loadingModule.loadedBy);\n    }\n\n    return undefined;\n}\nexports.getResourceLocationResolverFunc = getResourceLocationResolverFunc;\n\nfunction getScriptId(scriptSrc, config) {\n    if (typeof config === 'string') {\n        return config;\n    } else if (typeof config === 'object' && config.scriptId) {\n        return config.scriptId;\n    } else {\n        return 'jenkins-script:' + scriptSrc;\n    }    \n}\n\nexports.getRootURL = getRootURL;\nfunction getRootURL() {\n    if (jenkinsCIGlobal && jenkinsCIGlobal.rootURL) {\n        return jenkinsCIGlobal.rootURL;\n    }\n    \n    var docHead = exports.getHeadElement();\n    var rootURL = getAttribute(docHead, \"data-rooturl\");\n\n    if (rootURL === undefined || rootURL === null) {\n        // Backward compatibility - used to use a 'resurl' attribute.\n        rootURL = getAttribute(docHead, \"resurl\");\n        if (rootURL === undefined || rootURL === null) {\n            throw new Error(\"Attribute 'data-rooturl' not defined on the document <head> element.\");\n        }\n    }\n\n    if (jenkinsCIGlobal) {\n        jenkinsCIGlobal.rootURL = rootURL;\n    }\n    \n    return rootURL;\n}\n\nexports.getAdjunctURL = getAdjunctURL;\nfunction getAdjunctURL() {\n    if (jenkinsCIGlobal && jenkinsCIGlobal.adjunctURL) {\n        return jenkinsCIGlobal.adjunctURL;\n    }\n    \n    var docHead = exports.getHeadElement();\n    var adjunctURL = getAttribute(docHead, \"data-adjuncturl\");\n\n    if (adjunctURL === undefined || adjunctURL === null) {\n        // Backward compatibility - older Jenkins do not have the adjunct url on the\n        // <head> element. Lets try getting the resurl (older jenkins) and patching it \n        // to be an adjunct url.\n        adjunctURL = getAttribute(docHead, \"resurl\");\n        if (adjunctURL === undefined || adjunctURL === null) {\n            throw new Error(\"Attribute 'data-adjuncturl' not defined on the document <head> element.\");\n        }\n        // Replace the first occurrence of 'static/' with 'adjuncts/' \n        adjunctURL = adjunctURL.replace('static\\/', 'adjuncts\\/');\n    }\n\n    if (jenkinsCIGlobal) {\n        jenkinsCIGlobal.adjunctURL = adjunctURL;\n    }\n    \n    return adjunctURL;\n}\n\nfunction createElement(name) {\n    var document = window.document;\n    return document.createElement(name);\n}\n\nfunction getAttribute(element, attributeName) {\n    var value = element.getAttribute(attributeName.toLowerCase());\n    \n    if (value) {\n        return value;\n    } else {\n        // try without lowercasing\n        return element.getAttribute(attributeName);\n    }    \n}\n\nfunction getLoadingModule(moduleSpec) {\n    var moduleNamespaceObj = exports.getModuleNamespaceObj(moduleSpec);\n    var moduleName = moduleSpec.getLoadBundleName();\n\n    if (!moduleNamespaceObj.loadingModules) {\n        moduleNamespaceObj.loadingModules = {};\n    }\n    if (!moduleNamespaceObj.loadingModules[moduleName]) {\n        moduleNamespaceObj.loadingModules[moduleName] = {};\n    }\n    return moduleNamespaceObj.loadingModules[moduleName];\n}\n\nfunction endsWith(string, suffix) {\n    return (string.indexOf(suffix, string.length - suffix.length) !== -1);\n}\n\nfunction thisBundleNamespaceProvider() {\n    if (whoami !== undefined) {\n        return whoami.nsProvider;\n    }\n    return undefined;\n}\n\nfunction getBundleNSProviderFromScriptElement(namespace, moduleName) {\n    var docHead = exports.getHeadElement();\n    var scripts = docHead.getElementsByTagName(\"script\");\n\n    for (var i = 0; i < scripts.length; i++) {\n        var script = scripts[i];\n        var elNamespace = script.getAttribute('data-jenkins-module-namespace');\n        var elModuleName = script.getAttribute('data-jenkins-module-moduleName');\n\n        if (elNamespace === namespace && elModuleName === moduleName) {\n            return script.getAttribute('data-jenkins-module-nsProvider');\n        }\n    }\n\n    return undefined;\n}","deps":{"./ModuleSpec":"node_modules/@jenkins-cd/js-modules/js/ModuleSpec.js","./ResourceLocationResolver":"node_modules/@jenkins-cd/js-modules/js/ResourceLocationResolver.js","./promise":"node_modules/@jenkins-cd/js-modules/js/promise.js"}},{"id":"node_modules/@jenkins-cd/js-modules/js/promise.js","source":"exports.make = function(executor) {\n    var thePromise = new APromise();\n    executor.call(thePromise, function(result) {\n        thePromise.resolve(result);\n    }, function(reason) {\n        thePromise.reject(reason);\n    });\n    return thePromise;\n};\n\nfunction APromise() {\n    this.state = 'PENDING';\n    this.whenFulfilled = undefined;\n    this.whenRejected = undefined;\n    this.applyFulfillArgs = false;\n}\n\nAPromise.prototype.applyArgsOnFulfill = function() {\n    this.applyFulfillArgs = true;\n    return this;\n}\n\nAPromise.prototype.resolve = function (result) {\n    this.state = 'FULFILLED';\n    \n    var thePromise = this;\n    function doFulfill(whenFulfilled, result) {\n        if (thePromise.applyFulfillArgs) {\n            whenFulfilled.apply(whenFulfilled, result);\n        } else {\n            whenFulfilled(result);\n        }\n    }\n    \n    if (this.whenFulfilled) {\n        doFulfill(this.whenFulfilled, result);\n    }\n    // redefine \"onFulfilled\" to call immediately\n    this.onFulfilled = function (whenFulfilled) {\n        if (whenFulfilled) {\n            doFulfill(whenFulfilled, result);\n        }\n        return this;\n    }\n};\n\nAPromise.prototype.reject = function (reason) {\n    this.state = 'REJECTED';\n    if (this.whenRejected) {\n        this.whenRejected(reason);\n    }\n    // redefine \"onRejected\" to call immediately\n    this.onRejected = function(whenRejected) {\n        if (whenRejected) {\n            whenRejected(reason);\n        }\n        return this;\n    }\n};\n\nAPromise.prototype.onFulfilled = function(whenFulfilled) {\n    if (!whenFulfilled) {\n        throw new Error('Must provide an \"whenFulfilled\" callback.');\n    }\n    this.whenFulfilled = whenFulfilled;\n    return this;\n};\n\nAPromise.prototype.onRejected = function(whenRejected) {        \n    if (whenRejected) {\n        this.whenRejected = whenRejected;\n    }\n    return this;\n};","deps":{}},{"id":"node_modules/rollbar-browser/dist/rollbar.umd.nojson.min.js","source":"!function(e,r){if(\"object\"==typeof exports&&\"object\"==typeof module)module.exports=r();else if(\"function\"==typeof define&&define.amd)define([],r);else{var t=r();for(var n in t)(\"object\"==typeof exports?exports:e)[n]=t[n]}}(this,function(){return function(e){function r(n){if(t[n])return t[n].exports;var o=t[n]={exports:{},id:n,loaded:!1};return e[n].call(o.exports,o,o.exports,r),o.loaded=!0,o.exports}var t={};return r.m=e,r.c=t,r.p=\"\",r(0)}([function(e,r,t){e.exports=t(1)},function(e,r,t){\"use strict\";function n(){var e=\"undefined\"==typeof JSON?{}:JSON;o.setupJSON(e)}var o=t(2),i=t(3);n();var a=window._rollbarConfig,s=a&&a.globalAlias||\"Rollbar\",u=window[s]&&\"undefined\"!=typeof window[s].shimId;!u&&a?o.wrapper.init(a):(window.Rollbar=o.wrapper,window.RollbarNotifier=i.Notifier),e.exports=o.wrapper},function(e,r,t){\"use strict\";function n(e,r,t){!t[4]&&window._rollbarWrappedError&&(t[4]=window._rollbarWrappedError,window._rollbarWrappedError=null),e.uncaughtError.apply(e,t),r&&r.apply(window,t)}function o(e,r){if(r.hasOwnProperty&&r.hasOwnProperty(\"addEventListener\")){var t=r.addEventListener;r.addEventListener=function(r,n,o){t.call(this,r,e.wrap(n),o)};var n=r.removeEventListener;r.removeEventListener=function(e,r,t){n.call(this,e,r&&r._wrapped||r,t)}}}var i=t(3),a=t(8),s=i.Notifier;window._rollbarWrappedError=null;var u={};u.init=function(e,r){var t=new s(r);if(t.configure(e),e.captureUncaught){var i;r&&a.isType(r._rollbarOldOnError,\"function\")?i=r._rollbarOldOnError:window.onerror&&!window.onerror.belongsToShim&&(i=window.onerror),window.onerror=function(){var e=Array.prototype.slice.call(arguments,0);n(t,i,e)};var u,c,l=[\"EventTarget\",\"Window\",\"Node\",\"ApplicationCache\",\"AudioTrackList\",\"ChannelMergerNode\",\"CryptoOperation\",\"EventSource\",\"FileReader\",\"HTMLUnknownElement\",\"IDBDatabase\",\"IDBRequest\",\"IDBTransaction\",\"KeyOperation\",\"MediaController\",\"MessagePort\",\"ModalWindow\",\"Notification\",\"SVGElementInstance\",\"Screen\",\"TextTrack\",\"TextTrackCue\",\"TextTrackList\",\"WebSocket\",\"WebSocketWorker\",\"Worker\",\"XMLHttpRequest\",\"XMLHttpRequestEventTarget\",\"XMLHttpRequestUpload\"];for(u=0;u<l.length;++u)c=l[u],window[c]&&window[c].prototype&&o(t,window[c].prototype)}return e.captureUnhandledRejections&&(r&&a.isType(r._unhandledRejectionHandler,\"function\")&&window.removeEventListener(\"unhandledrejection\",r._unhandledRejectionHandler),t._unhandledRejectionHandler=function(e){var r=e.reason,n=e.promise,o=e.detail;!r&&o&&(r=o.reason,n=o.promise),t.unhandledRejection(r,n)},window.addEventListener(\"unhandledrejection\",t._unhandledRejectionHandler)),window.Rollbar=t,s.processPayloads(),t},e.exports={wrapper:u,setupJSON:i.setupJSON}},function(e,r,t){\"use strict\";function n(e){E=e,w.setupJSON(e)}function o(e,r){return function(){var t=r||this;try{return e.apply(t,arguments)}catch(n){console.error(\"[Rollbar]:\",n)}}}function i(){h||(h=setTimeout(f,1e3))}function a(){return _}function s(e){_=_||this;var r=\"https://\"+s.DEFAULT_ENDPOINT;this.options={enabled:!0,endpoint:r,environment:\"production\",scrubFields:g([],s.DEFAULT_SCRUB_FIELDS),checkIgnore:null,logLevel:s.DEFAULT_LOG_LEVEL,reportLevel:s.DEFAULT_REPORT_LEVEL,uncaughtErrorLevel:s.DEFAULT_UNCAUGHT_ERROR_LEVEL,payload:{}},this.lastError=null,this.plugins={},this.parentNotifier=e,e&&(e.hasOwnProperty(\"shimId\")?e.notifier=this:this.configure(e.options))}function u(e){window._rollbarPayloadQueue.push(e),i()}function c(e){return o(function(){var r=this._getLogArgs(arguments);return this._log(e||r.level||this.options.logLevel||s.DEFAULT_LOG_LEVEL,r.message,r.err,r.custom,r.callback)})}function l(e,r){e||(e=r?E.stringify(r):\"\");var t={body:e};return r&&(t.extra=g(!0,{},r)),{message:t}}function p(e,r,t){var n=m.guessErrorClass(r.message),o=r.name||n[0],i=n[1],a={exception:{\"class\":o,message:i}};if(e&&(a.exception.description=e||\"uncaught exception\"),r.stack){var s,u,c,p,f,d,h,w;for(a.frames=[],h=0;h<r.stack.length;++h)s=r.stack[h],u={filename:s.url?v.sanitizeUrl(s.url):\"(unknown)\",lineno:s.line||null,method:s.func&&\"?\"!==s.func?s.func:\"[anonymous]\",colno:s.column},c=p=f=null,d=s.context?s.context.length:0,d&&(w=Math.floor(d/2),p=s.context.slice(0,w),c=s.context[w],f=s.context.slice(w)),c&&(u.code=c),(p||f)&&(u.context={},p&&p.length&&(u.context.pre=p),f&&f.length&&(u.context.post=f)),s.args&&(u.args=s.args),a.frames.push(u);return a.frames.reverse(),t&&(a.extra=g(!0,{},t)),{trace:a}}return l(o+\": \"+i,t)}function f(){var e;try{for(;e=window._rollbarPayloadQueue.shift();)d(e)}finally{h=void 0}}function d(e){var r=e.endpointUrl,t=e.accessToken,n=e.payload,o=e.callback||function(){},i=(new Date).getTime();i-L>=6e4&&(L=i,R=0);var a=window._globalRollbarOptions.maxItems,c=window._globalRollbarOptions.itemsPerMinute,l=function(){return!n.ignoreRateLimit&&a>=1&&T>=a},p=function(){return!n.ignoreRateLimit&&c>=1&&R>=c};return l()?void o(new Error(a+\" max items reached\")):p()?void o(new Error(c+\" items per minute reached\")):(T++,R++,l()&&_._log(_.options.uncaughtErrorLevel,\"maxItems has been hit. Ignoring errors for the remainder of the current page load.\",null,{maxItems:a},null,!1,!0),n.ignoreRateLimit&&delete n.ignoreRateLimit,void y.post(r,t,n,function(r,t){return r?(r instanceof b&&(e.callback=function(){},setTimeout(function(){u(e)},s.RETRY_DELAY)),o(r)):o(null,t)}))}var h,g=t(4),m=t(5),v=t(8),w=t(10),y=w.XHR,b=w.ConnectionError,E=null;s.NOTIFIER_VERSION=\"1.9.2\",s.DEFAULT_ENDPOINT=\"api.rollbar.com/api/1/\",s.DEFAULT_SCRUB_FIELDS=[\"pw\",\"pass\",\"passwd\",\"password\",\"secret\",\"confirm_password\",\"confirmPassword\",\"password_confirmation\",\"passwordConfirmation\",\"access_token\",\"accessToken\",\"secret_key\",\"secretKey\",\"secretToken\"],s.DEFAULT_LOG_LEVEL=\"debug\",s.DEFAULT_REPORT_LEVEL=\"debug\",s.DEFAULT_UNCAUGHT_ERROR_LEVEL=\"error\",s.DEFAULT_ITEMS_PER_MIN=60,s.DEFAULT_MAX_ITEMS=0,s.LEVELS={debug:0,info:1,warning:2,error:3,critical:4},s.RETRY_DELAY=1e4,window._rollbarPayloadQueue=window._rollbarPayloadQueue||[],window._globalRollbarOptions={startTime:(new Date).getTime(),maxItems:s.DEFAULT_MAX_ITEMS,itemsPerMinute:s.DEFAULT_ITEMS_PER_MIN};var _,x=s.prototype;x._getLogArgs=function(e){for(var r,t,n,i,a,u,c=this.options.logLevel||s.DEFAULT_LOG_LEVEL,l=[],p=0;p<e.length;++p)u=e[p],a=v.typeName(u),\"string\"===a?r?l.push(u):r=u:\"function\"===a?i=o(u,this):\"date\"===a?l.push(u):\"error\"===a||u instanceof Error||\"undefined\"!=typeof DOMException&&u instanceof DOMException?t?l.push(u):t=u:\"object\"!==a&&\"array\"!==a||(n?l.push(u):n=u);return l.length&&(n=n||{},n.extraArgs=l),{level:c,message:r,err:t,custom:n,callback:i}},x._route=function(e){var r=this.options.endpoint,t=/\\/$/.test(r),n=/^\\//.test(e);return t&&n?e=e.substring(1):t||n||(e=\"/\"+e),r+e},x._processShimQueue=function(e){for(var r,t,n,o,i,a,u,c={};t=e.shift();)r=t.shim,n=t.method,o=t.args,i=r.parentShim,u=c[r.shimId],u||(i?(a=c[i.shimId],u=new s(a)):u=this,c[r.shimId]=u),u[n]&&v.isType(u[n],\"function\")&&u[n].apply(u,o)},x._buildPayload=function(e,r,t,n,o){var i=this.options.accessToken,a=this.options.environment,u=g(!0,{},this.options.payload),c=v.uuid4();if(void 0===s.LEVELS[r])throw new Error(\"Invalid level\");if(!t&&!n&&!o)throw new Error(\"No message, stack info or custom data\");var l={environment:a,endpoint:this.options.endpoint,uuid:c,level:r,platform:\"browser\",framework:\"browser-js\",language:\"javascript\",body:this._buildBody(t,n,o),request:{url:window.location.href,query_string:window.location.search,user_ip:\"$remote_ip\"},client:{runtime_ms:e.getTime()-window._globalRollbarOptions.startTime,timestamp:Math.round(e.getTime()/1e3),javascript:{browser:window.navigator.userAgent,language:window.navigator.language,cookie_enabled:window.navigator.cookieEnabled,screen:{width:window.screen.width,height:window.screen.height},plugins:this._getBrowserPlugins()}},server:{},notifier:{name:\"rollbar-browser-js\",version:s.NOTIFIER_VERSION}};u.body&&delete u.body;var p={access_token:i,data:g(!0,l,u)};return this._scrub(p.data),p},x._buildBody=function(e,r,t){var n;return n=r?p(e,r,t):l(e,t)},x._getBrowserPlugins=function(){if(!this._browserPlugins){var e,r,t=window.navigator.plugins||[],n=t.length,o=[];for(r=0;r<n;++r)e=t[r],o.push({name:e.name,description:e.description});this._browserPlugins=o}return this._browserPlugins},x._scrub=function(e){function r(e,r,t,n,o,i){return r+v.redact(i)}function t(e){var t;if(v.isType(e,\"string\"))for(t=0;t<s.length;++t)e=e.replace(s[t],r);return e}function n(e,r){var t;for(t=0;t<a.length;++t)if(a[t].test(e)){r=v.redact(r);break}return r}function o(e,r){var o=n(e,r);return o===r?t(o):o}var i=this.options.scrubFields,a=this._getScrubFieldRegexs(i),s=this._getScrubQueryParamRegexs(i);return v.traverse(e,o),e},x._getScrubFieldRegexs=function(e){for(var r,t=[],n=0;n<e.length;++n)r=\"\\\\[?(%5[bB])?\"+e[n]+\"\\\\[?(%5[bB])?\\\\]?(%5[dD])?\",t.push(new RegExp(r,\"i\"));return t},x._getScrubQueryParamRegexs=function(e){for(var r,t=[],n=0;n<e.length;++n)r=\"\\\\[?(%5[bB])?\"+e[n]+\"\\\\[?(%5[bB])?\\\\]?(%5[dD])?\",t.push(new RegExp(\"(\"+r+\"=)([^&\\\\n]+)\",\"igm\"));return t},x._urlIsWhitelisted=function(e){var r,t,n,o,i,a,s,u,c,l;try{if(r=this.options.hostWhiteList,t=e&&e.data&&e.data.body&&e.data.body.trace,!r||0===r.length)return!0;if(!t)return!0;for(s=r.length,i=t.frames.length,c=0;c<i;c++){if(n=t.frames[c],o=n.filename,!v.isType(o,\"string\"))return!0;for(l=0;l<s;l++)if(a=r[l],u=new RegExp(a),u.test(o))return!0}}catch(p){return this.configure({hostWhiteList:null}),console.error(\"[Rollbar]: Error while reading your configuration's hostWhiteList option. Removing custom hostWhiteList.\",p),!0}return!1},x._messageIsIgnored=function(e){var r,t,n,o,i,a,s,u,c;try{if(i=!1,n=this.options.ignoredMessages,!n||0===n.length)return!1;if(s=e&&e.data&&e.data.body,u=s&&s.trace&&s.trace.exception&&s.trace.exception.message,c=s&&s.message&&s.message.body,r=u||c,!r)return!1;for(o=n.length,t=0;t<o&&(a=new RegExp(n[t],\"gi\"),!(i=a.test(r)));t++);}catch(l){this.configure({ignoredMessages:null}),console.error(\"[Rollbar]: Error while reading your configuration's ignoredMessages option. Removing custom ignoredMessages.\")}return i},x._enqueuePayload=function(e,r,t,n){var o={callback:n,accessToken:this.options.accessToken,endpointUrl:this._route(\"item/\"),payload:e},i=function(){if(n){var e=\"This item was not sent to Rollbar because it was ignored. This can happen if a custom checkIgnore() function was used or if the item's level was less than the notifier' reportLevel. See https://rollbar.com/docs/notifier/rollbar.js/configuration for more details.\";n(null,{err:0,result:{id:null,uuid:null,message:e}})}};if(this._internalCheckIgnore(r,t,e))return void i();try{if(v.isType(this.options.checkIgnore,\"function\")&&this.options.checkIgnore(r,t,e))return void i()}catch(a){this.configure({checkIgnore:null}),console.error(\"[Rollbar]: Error while calling custom checkIgnore() function. Removing custom checkIgnore().\",a)}if(this._urlIsWhitelisted(e)&&!this._messageIsIgnored(e)){if(this.options.verbose){if(e.data&&e.data.body&&e.data.body.trace){var s=e.data.body.trace,c=s.exception.message;console.error(\"[Rollbar]: \",c)}console.info(\"[Rollbar]: \",o)}v.isType(this.options.logFunction,\"function\")&&this.options.logFunction(o);try{v.isType(this.options.transform,\"function\")&&this.options.transform(e)}catch(a){this.configure({transform:null}),console.error(\"[Rollbar]: Error while calling custom transform() function. Removing custom transform().\",a)}this.options.enabled&&u(o)}},x._internalCheckIgnore=function(e,r,t){var n=r[0],o=s.LEVELS[n]||0,i=s.LEVELS[this.options.reportLevel]||0;if(o<i)return!0;var a=this.options?this.options.plugins:{};if(a&&a.jquery&&a.jquery.ignoreAjaxErrors)try{return!!t.data.body.message.extra.isAjax}catch(u){return!1}return!1},x._log=function(e,r,t,n,o,i,a){var s=null;if(t)try{if(s=t._savedStackTrace?t._savedStackTrace:m.parse(t),t===this.lastError)return;this.lastError=t}catch(u){console.error(\"[Rollbar]: Error while parsing the error object.\",u),r=t.message||t.description||r||String(t),t=null}var c=this._buildPayload(new Date,e,r,s,n);a&&(c.ignoreRateLimit=!0),this._enqueuePayload(c,!!i,[e,r,t,n],o)},x.log=c(),x.debug=c(\"debug\"),x.info=c(\"info\"),x.warn=c(\"warning\"),x.warning=c(\"warning\"),x.error=c(\"error\"),x.critical=c(\"critical\"),x.uncaughtError=o(function(e,r,t,n,o,i){if(i=i||null,o&&v.isType(o,\"error\"))return void this._log(this.options.uncaughtErrorLevel,e,o,i,null,!0);if(r&&v.isType(r,\"error\"))return void this._log(this.options.uncaughtErrorLevel,e,r,i,null,!0);var a={url:r||\"\",line:t};a.func=m.guessFunctionName(a.url,a.line),a.context=m.gatherContext(a.url,a.line);var s={mode:\"onerror\",message:o?String(o):e||\"uncaught exception\",url:document.location.href,stack:[a],useragent:navigator.userAgent},u=this._buildPayload(new Date,this.options.uncaughtErrorLevel,e,s,i);this._enqueuePayload(u,!0,[this.options.uncaughtErrorLevel,e,r,t,n,o])}),x.unhandledRejection=o(function(e,r){if(null==e)return void _._log(_.options.uncaughtErrorLevel,\"unhandled rejection was null or undefined!\",null,{},null,!1,!1);var t=e.message||(e?String(e):\"unhandled rejection\"),n=e._rollbarContext||r._rollbarContext||null;if(e&&v.isType(e,\"error\"))return void this._log(this.options.uncaughtErrorLevel,t,e,n,null,!0);var o={url:\"\",line:0};o.func=m.guessFunctionName(o.url,o.line),o.context=m.gatherContext(o.url,o.line);var i={mode:\"unhandledrejection\",message:t,url:document.location.href,stack:[o],useragent:navigator.userAgent},a=this._buildPayload(new Date,this.options.uncaughtErrorLevel,t,i,n);this._enqueuePayload(a,!0,[this.options.uncaughtErrorLevel,t,o.url,o.line,0,e,r])}),x.global=o(function(e){e=e||{};var r={startTime:e.startTime,maxItems:e.maxItems,itemsPerMinute:e.itemsPerMinute};g(!0,window._globalRollbarOptions,r),void 0!==e.maxItems&&(T=0),void 0!==e.itemsPerMinute&&(R=0)}),x.configure=o(function(e,r){var t=g(!0,{},e);g(!r,this.options,t),this.global(t)}),x.scope=o(function(e){var r=new s(this);return g(!0,r.options.payload,e),r}),x.wrap=function(e,r){try{var t;if(t=v.isType(r,\"function\")?r:function(){return r||{}},!v.isType(e,\"function\"))return e;if(e._isWrap)return e;if(!e._wrapped){e._wrapped=function(){try{return e.apply(this,arguments)}catch(r){throw\"string\"==typeof r&&(r=new String(r)),r.stack||(r._savedStackTrace=m.parse(r)),r._rollbarContext=t()||{},r._rollbarContext._wrappedSource=e.toString(),window._rollbarWrappedError=r,r}},e._wrapped._isWrap=!0;for(var n in e)e.hasOwnProperty(n)&&(e._wrapped[n]=e[n])}return e._wrapped}catch(o){return e}},x.loadFull=function(){console.error(\"[Rollbar]: Unexpected Rollbar.loadFull() called on a Notifier instance\")},s.processPayloads=function(e){return e?void f():void i()};var L=(new Date).getTime(),T=0,R=0;e.exports={Notifier:s,setupJSON:n,topLevelNotifier:a}},function(e,r){\"use strict\";var t=Object.prototype.hasOwnProperty,n=Object.prototype.toString,o=function(e){return\"function\"==typeof Array.isArray?Array.isArray(e):\"[object Array]\"===n.call(e)},i=function(e){if(!e||\"[object Object]\"!==n.call(e))return!1;var r=t.call(e,\"constructor\"),o=e.constructor&&e.constructor.prototype&&t.call(e.constructor.prototype,\"isPrototypeOf\");if(e.constructor&&!r&&!o)return!1;var i;for(i in e);return\"undefined\"==typeof i||t.call(e,i)};e.exports=function a(){var e,r,t,n,s,u,c=arguments[0],l=1,p=arguments.length,f=!1;for(\"boolean\"==typeof c?(f=c,c=arguments[1]||{},l=2):(\"object\"!=typeof c&&\"function\"!=typeof c||null==c)&&(c={});l<p;++l)if(e=arguments[l],null!=e)for(r in e)t=c[r],n=e[r],c!==n&&(f&&n&&(i(n)||(s=o(n)))?(s?(s=!1,u=t&&o(t)?t:[]):u=t&&i(t)?t:{},c[r]=a(f,u,n)):\"undefined\"!=typeof n&&(c[r]=n));return c}},function(e,r,t){\"use strict\";function n(){return l}function o(){return null}function i(e){var r={};return r._stackFrame=e,r.url=e.fileName,r.line=e.lineNumber,r.func=e.functionName,r.column=e.columnNumber,r.args=e.args,r.context=o(r.url,r.line),r}function a(e){function r(){var r=[];try{r=c.parse(e)}catch(t){r=[]}for(var n=[],o=0;o<r.length;o++)n.push(new i(r[o]));return n}return{stack:r(),message:e.message,name:e.name}}function s(e){return new a(e)}function u(e){if(!e)return[\"Unknown error. There was no error message to display.\",\"\"];var r=e.match(p),t=\"(unknown)\";return r&&(t=r[r.length-1],e=e.replace((r[r.length-2]||\"\")+t+\":\",\"\"),e=e.replace(/(^[\\s]+|[\\s]+$)/g,\"\")),[t,e]}var c=t(6),l=\"?\",p=new RegExp(\"^(([a-zA-Z0-9-_$ ]*): *)?(Uncaught )?([a-zA-Z0-9-_$ ]*): \");e.exports={guessFunctionName:n,guessErrorClass:u,gatherContext:o,parse:s,Stack:a,Frame:i}},function(e,r,t){var n,o,i;!function(a,s){\"use strict\";o=[t(7)],n=s,i=\"function\"==typeof n?n.apply(r,o):n,!(void 0!==i&&(e.exports=i))}(this,function(e){\"use strict\";function r(e,r,t){if(\"function\"==typeof Array.prototype.map)return e.map(r,t);for(var n=new Array(e.length),o=0;o<e.length;o++)n[o]=r.call(t,e[o]);return n}function t(e,r,t){if(\"function\"==typeof Array.prototype.filter)return e.filter(r,t);for(var n=[],o=0;o<e.length;o++)r.call(t,e[o])&&n.push(e[o]);return n}var n=/(^|@)\\S+\\:\\d+/,o=/^\\s*at .*(\\S+\\:\\d+|\\(native\\))/m,i=/^(eval@)?(\\[native code\\])?$/;return{parse:function(e){if(\"undefined\"!=typeof e.stacktrace||\"undefined\"!=typeof e[\"opera#sourceloc\"])return this.parseOpera(e);if(e.stack&&e.stack.match(o))return this.parseV8OrIE(e);if(e.stack)return this.parseFFOrSafari(e);throw new Error(\"Cannot parse given Error object\")},extractLocation:function(e){if(e.indexOf(\":\")===-1)return[e];var r=e.replace(/[\\(\\)\\s]/g,\"\").split(\":\"),t=r.pop(),n=r[r.length-1];if(!isNaN(parseFloat(n))&&isFinite(n)){var o=r.pop();return[r.join(\":\"),o,t]}return[r.join(\":\"),t,void 0]},parseV8OrIE:function(n){var i=t(n.stack.split(\"\\n\"),function(e){return!!e.match(o)},this);return r(i,function(r){r.indexOf(\"(eval \")>-1&&(r=r.replace(/eval code/g,\"eval\").replace(/(\\(eval at [^\\()]*)|(\\)\\,.*$)/g,\"\"));var t=r.replace(/^\\s+/,\"\").replace(/\\(eval code/g,\"(\").split(/\\s+/).slice(1),n=this.extractLocation(t.pop()),o=t.join(\" \")||void 0,i=\"eval\"===n[0]?void 0:n[0];return new e(o,(void 0),i,n[1],n[2],r)},this)},parseFFOrSafari:function(n){var o=t(n.stack.split(\"\\n\"),function(e){return!e.match(i)},this);return r(o,function(r){if(r.indexOf(\" > eval\")>-1&&(r=r.replace(/ line (\\d+)(?: > eval line \\d+)* > eval\\:\\d+\\:\\d+/g,\":$1\")),r.indexOf(\"@\")===-1&&r.indexOf(\":\")===-1)return new e(r);var t=r.split(\"@\"),n=this.extractLocation(t.pop()),o=t.shift()||void 0;return new e(o,(void 0),n[0],n[1],n[2],r)},this)},parseOpera:function(e){return!e.stacktrace||e.message.indexOf(\"\\n\")>-1&&e.message.split(\"\\n\").length>e.stacktrace.split(\"\\n\").length?this.parseOpera9(e):e.stack?this.parseOpera11(e):this.parseOpera10(e)},parseOpera9:function(r){for(var t=/Line (\\d+).*script (?:in )?(\\S+)/i,n=r.message.split(\"\\n\"),o=[],i=2,a=n.length;i<a;i+=2){var s=t.exec(n[i]);s&&o.push(new e((void 0),(void 0),s[2],s[1],(void 0),n[i]))}return o},parseOpera10:function(r){for(var t=/Line (\\d+).*script (?:in )?(\\S+)(?:: In function (\\S+))?$/i,n=r.stacktrace.split(\"\\n\"),o=[],i=0,a=n.length;i<a;i+=2){var s=t.exec(n[i]);s&&o.push(new e(s[3]||void 0,(void 0),s[2],s[1],(void 0),n[i]))}return o},parseOpera11:function(o){var i=t(o.stack.split(\"\\n\"),function(e){return!!e.match(n)&&!e.match(/^Error created at/)},this);return r(i,function(r){var t,n=r.split(\"@\"),o=this.extractLocation(n.pop()),i=n.shift()||\"\",a=i.replace(/<anonymous function(: (\\w+))?>/,\"$2\").replace(/\\([^\\)]*\\)/g,\"\")||void 0;i.match(/\\(([^\\)]*)\\)/)&&(t=i.replace(/^[^\\(]+\\(([^\\)]*)\\)$/,\"$1\"));var s=void 0===t||\"[arguments not available]\"===t?void 0:t.split(\",\");return new e(a,s,o[0],o[1],o[2],r)},this)}}})},function(e,r,t){var n,o,i;!function(t,a){\"use strict\";o=[],n=a,i=\"function\"==typeof n?n.apply(r,o):n,!(void 0!==i&&(e.exports=i))}(this,function(){\"use strict\";function e(e){return!isNaN(parseFloat(e))&&isFinite(e)}function r(e,r,t,n,o,i){void 0!==e&&this.setFunctionName(e),void 0!==r&&this.setArgs(r),void 0!==t&&this.setFileName(t),void 0!==n&&this.setLineNumber(n),void 0!==o&&this.setColumnNumber(o),void 0!==i&&this.setSource(i)}return r.prototype={getFunctionName:function(){return this.functionName},setFunctionName:function(e){this.functionName=String(e)},getArgs:function(){return this.args},setArgs:function(e){if(\"[object Array]\"!==Object.prototype.toString.call(e))throw new TypeError(\"Args must be an Array\");this.args=e},getFileName:function(){return this.fileName},setFileName:function(e){this.fileName=String(e)},getLineNumber:function(){return this.lineNumber},setLineNumber:function(r){if(!e(r))throw new TypeError(\"Line Number must be a Number\");this.lineNumber=Number(r)},getColumnNumber:function(){return this.columnNumber},setColumnNumber:function(r){if(!e(r))throw new TypeError(\"Column Number must be a Number\");this.columnNumber=Number(r)},getSource:function(){return this.source},setSource:function(e){this.source=String(e)},toString:function(){var r=this.getFunctionName()||\"{anonymous}\",t=\"(\"+(this.getArgs()||[]).join(\",\")+\")\",n=this.getFileName()?\"@\"+this.getFileName():\"\",o=e(this.getLineNumber())?\":\"+this.getLineNumber():\"\",i=e(this.getColumnNumber())?\":\"+this.getColumnNumber():\"\";return r+t+n+o+i}},r})},function(e,r,t){\"use strict\";function n(e){return{}.toString.call(e).match(/\\s([a-zA-Z]+)/)[1].toLowerCase()}function o(e,r){return n(e)===r}function i(e){if(!o(e,\"string\"))throw new Error(\"received invalid input\");for(var r=l,t=r.parser[r.strictMode?\"strict\":\"loose\"].exec(e),n={},i=14;i--;)n[r.key[i]]=t[i]||\"\";return n[r.q.name]={},n[r.key[12]].replace(r.q.parser,function(e,t,o){t&&(n[r.q.name][t]=o)}),n}function a(e){var r=i(e);return\"\"===r.anchor&&(r.source=r.source.replace(\"#\",\"\")),e=r.source.replace(\"?\"+r.query,\"\")}function s(e,r){var t,n,i,a=o(e,\"object\"),u=o(e,\"array\"),c=[];if(a)for(t in e)e.hasOwnProperty(t)&&c.push(t);else if(u)for(i=0;i<e.length;++i)c.push(i);for(i=0;i<c.length;++i)t=c[i],n=e[t],a=o(n,\"object\"),u=o(n,\"array\"),a||u?e[t]=s(n,r):e[t]=r(t,n);return e}function u(e){return e=String(e),new Array(e.length+1).join(\"*\")}function c(){var e=(new Date).getTime(),r=\"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx\".replace(/[xy]/g,function(r){var t=(e+16*Math.random())%16|0;return e=Math.floor(e/16),(\"x\"===r?t:7&t|8).toString(16)});return r}t(9);var l={strictMode:!1,key:[\"source\",\"protocol\",\"authority\",\"userInfo\",\"user\",\"password\",\"host\",\"port\",\"relative\",\"path\",\"directory\",\"file\",\"query\",\"anchor\"],q:{name:\"queryKey\",parser:/(?:^|&)([^&=]*)=?([^&]*)/g},parser:{strict:/^(?:([^:\\/?#]+):)?(?:\\/\\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\\/?#]*)(?::(\\d*))?))?((((?:[^?#\\/]*\\/)*)([^?#]*))(?:\\?([^#]*))?(?:#(.*))?)/,loose:/^(?:(?![^:@]+:[^:@\\/]*@)([^:\\/?#.]+):)?(?:\\/\\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\\/?#]*)(?::(\\d*))?)(((\\/(?:[^?#](?![^?#\\/]*\\.[^?#\\/.]+(?:[?#]|$)))*\\/?)?([^?#\\/]*))(?:\\?([^#]*))?(?:#(.*))?)/}},p={isType:o,parseUri:i,parseUriOptions:l,redact:u,sanitizeUrl:a,traverse:s,typeName:n,uuid4:c};e.exports=p},function(e,r){!function(e){\"use strict\";e.console=e.console||{};for(var r,t,n=e.console,o={},i=function(){},a=\"memory\".split(\",\"),s=\"assert,clear,count,debug,dir,dirxml,error,exception,group,groupCollapsed,groupEnd,info,log,markTimeline,profile,profiles,profileEnd,show,table,time,timeEnd,timeline,timelineEnd,timeStamp,trace,warn\".split(\",\");r=a.pop();)n[r]||(n[r]=o);for(;t=s.pop();)n[t]||(n[t]=i)}(\"undefined\"==typeof window?this:window)},function(e,r,t){\"use strict\";function n(e){a=e}function o(e){this.name=\"Connection Error\",this.message=e,this.stack=(new Error).stack}var i=t(8),a=null;o.prototype=Object.create(Error.prototype),o.prototype.constructor=o;var s={XMLHttpFactories:[function(){return new XMLHttpRequest},function(){return new ActiveXObject(\"Msxml2.XMLHTTP\")},function(){return new ActiveXObject(\"Msxml3.XMLHTTP\")},function(){return new ActiveXObject(\"Microsoft.XMLHTTP\")}],createXMLHTTPObject:function(){var e,r=!1,t=s.XMLHttpFactories,n=t.length;for(e=0;e<n;e++)try{r=t[e]();break}catch(o){}return r},post:function(e,r,t,n){if(!i.isType(t,\"object\"))throw new Error(\"Expected an object to POST\");t=a.stringify(t),n=n||function(){};var u=s.createXMLHTTPObject();if(u)try{try{var c=function(){try{if(c&&4===u.readyState){c=void 0;var e=a.parse(u.responseText);200===u.status?n(null,e):i.isType(u.status,\"number\")&&u.status>=400&&u.status<600?(403==u.status&&console.error(\"[Rollbar]:\"+e.message),n(new Error(String(u.status)))):n(new o(\"XHR response had no status code (likely connection failure)\"))}}catch(r){var t;t=r&&r.stack?r:new Error(r),n(t)}};u.open(\"POST\",e,!0),u.setRequestHeader&&(u.setRequestHeader(\"Content-Type\",\"application/json\"),u.setRequestHeader(\"X-Rollbar-Access-Token\",r)),u.onreadystatechange=c,u.send(t)}catch(l){if(\"undefined\"!=typeof XDomainRequest){\"http:\"===window.location.href.substring(0,5)&&\"https\"===e.substring(0,5)&&(e=\"http\"+e.substring(5));var p=function(){n(new o(\"Request timed out\"))},f=function(){n(new Error(\"Error during request\"))},d=function(){n(null,a.parse(u.responseText))};u=new XDomainRequest,u.onprogress=function(){},u.ontimeout=p,u.onerror=f,u.onload=d,u.open(\"POST\",e,!0),u.send(t)}}}catch(h){n(h)}}};e.exports={XHR:s,setupJSON:n,ConnectionError:o}}])});","deps":{}},{"id":"src/main/js/rollbar.js","source":"var ___$$$___requiredModuleMappings = [];\n\nvar ___$$$___jsModules = require('@jenkins-cd/js-modules');\n\nif (!window.jenkinsCIGlobal) {\n    window.jenkinsCIGlobal = {};\n}\nif (!window.jenkinsCIGlobal._internal) {\n    window.jenkinsCIGlobal._internal = {};\n}\n\nvar whoami = 'rollbar';\nvar loadTimestamp = Date.now();\n\n___$$$___jsModules.whoami(whoami);\n\n// Clear out the session storage if this is the first\n// bundle to export on the page.\nvar trackKeyPrefix = 'jenkins-cd/js-modules/tracking/';\nif (window.sessionStorage && !jenkinsCIGlobal._internal.bundleLoadIdx) {\n    jenkinsCIGlobal._internal.bundleLoadIdx = 0;\n    var toRemove = [];\n    for (var i = 0; i < sessionStorage.length; i++) {\n        var key = sessionStorage.key(i);\n        if (key.indexOf(trackKeyPrefix) === 0) {\n            toRemove.push(key);\n        }\n    }\n    for (var i = 0; i < toRemove.length; i++) {\n        sessionStorage.removeItem(toRemove[i]);\n    }\n}\njenkinsCIGlobal._internal.bundleLoadIdx++;\n\nif (window.sessionStorage) {\n    sessionStorage.setItem(trackKeyPrefix + 'load:' + whoami, JSON.stringify({\n        event: 'load',\n        bundleId: whoami,\n        bundlePath: 'target/classes/org/jenkins/ui/jsmodules/blueocean-config/rollbar.js',\n        at: loadTimestamp,\n        loadIdx: jenkinsCIGlobal._internal.bundleLoadIdx\n    }));\n}\n\nfunction ___$$$___doExport(namespace, moduleName, module) {\n    var exportedModuleId = (namespace !== undefined ? (namespace + ':' + moduleName) : moduleName);\n    try {\n        ___$$$___jsModules.requireModule(exportedModuleId);\n        // No exception => already exported. Shouldn't happen, but okay !!\n        return;\n    } catch (e) {\n        // Not exported yet, hence exception on require. Okay to export !!\n        ___$$$___jsModules.exportModule(namespace, moduleName, module);\n        if (window.sessionStorage) {\n            sessionStorage.setItem(trackKeyPrefix + 'export:' + exportedModuleId, JSON.stringify({\n                event: 'export',\n                moduleId: exportedModuleId,\n                at: loadTimestamp,\n                bundleId: whoami\n            }));\n        }\n    }\n}\n\n/*** Start Module Exec Function ***************************************/\nfunction ___$$$___exec(onExec) {\n    function getConfigAttribute(name) {\n    var headElements = document.getElementsByTagName('head');\n    if (headElements.length === 1) {\n        return headElements[0].getAttribute(name);\n    }\n    return undefined;\n}\n\nfunction normalizeURL(location) {\n    var normalizedUrl = 'http://anon.blueocean.io' + location;\n    var rootUrl = getConfigAttribute('data-rooturl');\n    if (rootUrl && location.startsWith(rootUrl)) {\n        normalizedUrl = 'http://anon.blueocean.io' + location.substring(rootUrl.length - 1, location.length);\n    }\n    return normalizedUrl;\n}\n\nvar transformer = function(payload) {\n    payload.data.request.user_ip = '0.0.0.0';\n    payload.data.request.url = normalizeURL(window.location.pathname);\n};\n\n//\n// Configure rollbar ...\n// See https://github.com/rollbar/rollbar.js/tree/master/examples/browserify\n//\n\nvar _rollbarConfig = {\n    accessToken: '81f3134dedf44871b9cc0a347b1313df',\n    captureUncaught: true,\n    code_version: window.$blueocean.config.version, // see header.jelly\n    source_map_enabled: true,\n    guess_uncaught_frames: true,\n    transform: transformer,\n};\n\nvar rollbarBrowser = require('rollbar-browser');\nvar Rollbar = rollbarBrowser.init(_rollbarConfig);\n\n// Looking at docs (https://github.com/rollbar/rollbar.js/tree/master/examples/browserify)\n// it seems like they stuff it into a global. We are trying hard not to do that\n// under any circumstances, but maybe this is an exception if it's only going to be\n// used in a closed/controlled env.\n//\n// Soooo .... lets export it to global for now, but as $blueocean_Rollbar ...\n//\n\nwindow.$blueocean_Rollbar = Rollbar;\n\n//\n// Usage ...\n//\n//try {\n//    foo();\n//    $blueocean_Rollbar.debug('foo() called');\n//} catch (e) {\n//    $blueocean_Rollbar.error('Problem calling foo()', e);\n//}\n\n    onExec(exports);\n}\n/*** End Module Exec Function   ***************************************/\n\nfunction ___$$$___doExports(module) {\n    // Do exports, if any ....\n    function doDependencyExport(module, normalizedPackageName, jsModuleNames) {\n        ___$$$___doExport(normalizedPackageName, jsModuleNames.patch, module);\n        ___$$$___doExport(normalizedPackageName, jsModuleNames.minor, module);\n        ___$$$___doExport(normalizedPackageName, jsModuleNames.major, module);\n        ___$$$___doExport(normalizedPackageName, jsModuleNames.any, module);\n    }\n\n    ___$$$___doExport(undefined, 'rollbar', {});\n\n    doDependencyExport(module, 'blueocean-config', {\n        patch: 'blueocean-config@0.0.1',\n        minor: 'blueocean-config@0.0.x',\n        major: 'blueocean-config@0.x',\n        any: 'blueocean-config@any'\n    });\n\n}\n\nfunction ___$$$___doCSS() {\n}\n\nfunction ___$$$___doBundleInit() {\n    try {\n        ___$$$___exec(function(module) {\n            ___$$$___doExports(module);\n            ___$$$___doCSS();\n        });\n    } catch (e) {\n        console.error('Error initializing Jenkins JavaScript bundle \"rollbar\"', e);\n    }\n}\n\nif (___$$$___requiredModuleMappings.length > 0) {\n    ___$$$___jsModules.importModule.apply(___$$$___jsModules.importModule, ___$$$___requiredModuleMappings)\n        .onFulfilled(function() {\n        ___$$$___doBundleInit();\n    });\n} else {\n    ___$$$___doBundleInit();\n}","deps":{"@jenkins-cd/js-modules":"node_modules/@jenkins-cd/js-modules/js/index.js","rollbar-browser":"node_modules/rollbar-browser/dist/rollbar.umd.nojson.min.js"},"entry":true}]