/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.config;

import hudson.Extension;
import io.jenkins.blueocean.rest.factory.BlueOceanConfigFactory;
import io.jenkins.blueocean.rest.model.BlueOceanConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BlueOceanConfigImpl
extends BlueOceanConfig {
    private static final Map<String, Object> config = new HashMap<String, Object>();
    private static final BlueOceanConfigImpl blueoceanConfig = new BlueOceanConfigImpl();

    private BlueOceanConfigImpl() {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String vs;
            String ks = entry.getKey() == null ? "" : entry.getKey().toString();
            if (!ks.startsWith("blueocean.features.")) continue;
            Object value = entry.getValue();
            String string = vs = value == null ? "" : value.toString();
            if ("true".equalsIgnoreCase(vs) || "false".equalsIgnoreCase(vs)) {
                value = Boolean.valueOf(vs);
            }
            config.put(ks.substring("blueocean.features.".length()), value);
        }
        for (Field f : BlueOceanConfig.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || f.getType() != String.class) continue;
            try {
                String featureName = (String)f.get(null);
                if ("blueocean.features.".equals(featureName) || config.containsKey(featureName)) continue;
                config.put(featureName, Boolean.FALSE);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException("Unable to read field: " + f.toString(), ex);
            }
        }
    }

    public Iterable<String> keys() {
        return config.keySet();
    }

    public <T> T get(String key, Class<T> type) {
        return (T)config.get(key);
    }

    @Extension(ordinal=-9999.0)
    public static class BlueOceanConfigFactoryImpl
    extends BlueOceanConfigFactory {
        public BlueOceanConfig getConfig() {
            return blueoceanConfig;
        }
    }
}

