/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import io.jenkins.blueocean.commons.stapler.export.Property;
import io.jenkins.blueocean.commons.stapler.export.TreePruner;
import java.util.function.Predicate;

class FilteringTreePruner
extends TreePruner {
    private final Predicate<String> predicate;
    private final TreePruner base;

    FilteringTreePruner(Predicate<String> predicate, TreePruner base) {
        this.predicate = predicate;
        this.base = base;
    }

    @Override
    public TreePruner accept(Object node, Property prop) {
        if (this.predicate.test(prop.name)) {
            return null;
        }
        TreePruner child = this.base.accept(node, prop);
        if (prop.merge && child != null) {
            child = new FilteringTreePruner(this.predicate, child);
        }
        return child;
    }
}

