/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.ExportConfig;
import io.jenkins.blueocean.commons.stapler.export.JSONDataWriter;
import java.io.IOException;
import java.io.Writer;
import org.kohsuke.stapler.StaplerResponse2;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Flavor {
    JSON("application/json;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, Writer w, ExportConfig config) throws IOException {
            return new JSONDataWriter(w, config);
        }
    }
    ,
    JSONP("application/javascript;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, Writer w, ExportConfig config) throws IOException {
            return new JSONDataWriter(w, config);
        }
    };

    public final String contentType;

    private Flavor(String contentType) {
        this.contentType = contentType;
    }

    public DataWriter createDataWriter(Object bean, StaplerResponse2 rsp) throws IOException {
        return this.createDataWriter(bean, rsp.getWriter());
    }

    public DataWriter createDataWriter(Object bean, Writer w) throws IOException {
        return this.createDataWriter(bean, w, new ExportConfig());
    }

    public abstract DataWriter createDataWriter(Object var1, Writer var2, ExportConfig var3) throws IOException;
}

