/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Type;
import org.jvnet.tiger_types.Types;

public abstract class ClassAttributeBehaviour {
    private final String name;
    public static final ClassAttributeBehaviour NONE = new ClassAttributeBehaviour("NONE"){

        @Override
        Class<?> map(Type expected, Class<?> actual) {
            return null;
        }
    };
    public static final ClassAttributeBehaviour ALWAYS = new ClassAttributeBehaviour("ALWAYS"){

        @Override
        Class<?> map(Type expected, Class<?> actual) {
            return actual;
        }
    };
    public static final ClassAttributeBehaviour IF_NEEDED = new ClassAttributeBehaviour("IF_NEEDED"){

        @Override
        Class<?> map(Type expected, Class<?> actual) {
            if (actual == null) {
                return null;
            }
            if (expected == actual) {
                return null;
            }
            if (expected == null) {
                return actual;
            }
            if (Types.erasure((Type)expected) == actual) {
                return null;
            }
            return actual;
        }
    };

    private ClassAttributeBehaviour(String name) {
        this.name = name;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    @Nullable
    abstract Class<?> map(@Nullable Type var1, @Nullable Class<?> var2);

    String print(Type expected, Class<?> actual) {
        return this.print(this.map(expected, actual));
    }

    protected String print(Class<?> t) {
        return t == null ? null : t.getName();
    }

    public ClassAttributeBehaviour simple() {
        final ClassAttributeBehaviour outer = this;
        return new ClassAttributeBehaviour(this, this.name + "+simple"){
            final /* synthetic */ ClassAttributeBehaviour this$0;
            {
                this.this$0 = this$0;
                super(name);
            }

            @Override
            Class<?> map(Type expected, Class<?> actual) {
                return outer.map(expected, actual);
            }

            @Override
            protected String print(Class<?> t) {
                return t == null ? null : t.getSimpleName();
            }
        };
    }
}

