/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public class HttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private final org.apache.http.HttpResponse response;

    public HttpResponse(org.apache.http.HttpResponse response) {
        this.response = response;
    }

    @CheckForNull
    public InputStream getContent() {
        try {
            HttpEntity entity = this.response.getEntity();
            if (this.getStatus() >= 300) {
                ErrorMessage errorMessage = new ErrorMessage(Integer.valueOf(this.getStatus()), this.getStatusLine());
                if (StringUtils.isEmpty((CharSequence)errorMessage.message) || "Bad Request".equals(errorMessage.message)) {
                    String message;
                    ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
                    try {
                        JSONObject jsonResponse = JSONObject.fromObject((Object)IOUtils.toString((InputStream)entity.getContent()));
                        JSONArray arr = jsonResponse.getJSONArray("errors");
                        StringBuilder messageBuilder = new StringBuilder();
                        for (int i = 0; i < arr.size(); ++i) {
                            JSONObject err = arr.getJSONObject(i);
                            if (i > 0) {
                                messageBuilder.append(", ");
                            }
                            messageBuilder.append(err.getString("message"));
                            StringBuilder details = new StringBuilder();
                            if (err.has("details")) {
                                JSONArray errorDetails = err.getJSONArray("details");
                                for (int detailIdx = 0; detailIdx < errorDetails.size(); ++detailIdx) {
                                    details.append(errorDetails.getString(detailIdx)).append("\n");
                                }
                            } else {
                                details.append("no error details");
                            }
                            errors.add(new ErrorMessage.Error("", err.getString("exceptionName"), details.toString()));
                        }
                        message = messageBuilder.toString();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred getting BitBucket API error content", (Throwable)e);
                        message = "An unknown error was reported from the BitBucket server";
                    }
                    errorMessage = new ErrorMessage(Integer.valueOf(this.getStatus()), message).addAll(errors);
                } else {
                    EntityUtils.consume((HttpEntity)entity);
                }
                throw new ServiceException(this.getStatus(), errorMessage, null);
            }
            return entity == null ? null : entity.getContent();
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    @NonNull
    public String getStatusLine() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @CheckForNull
    public String getHeader(String name) {
        return this.response.getFirstHeader(name).getValue();
    }
}

