/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BbCloudTeam
extends BbOrg {
    private final String uuid;
    private final String displayName;
    private final String avatar;

    @JsonCreator
    public BbCloudTeam(@JsonProperty(value="uuid") @NonNull String uuid, @JsonProperty(value="display_name") @NonNull String displayName, @JsonProperty(value="links") @NonNull Map<String, Map<String, String>> links) {
        this.uuid = uuid;
        this.displayName = displayName;
        Map<String, String> a = links.get("avatar");
        this.avatar = a != null ? BbCloudTeam.avatar50(a.get("href")) : null;
    }

    public BbCloudTeam(String uuid, String displayName, String avatar) {
        this.uuid = uuid;
        this.displayName = displayName;
        this.avatar = avatar;
    }

    @Override
    public String getKey() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getAvatar() {
        return this.avatar;
    }

    public String getUUID() {
        return this.uuid;
    }

    @Override
    public boolean isPublicProject() {
        return false;
    }

    static String avatar50(String href) {
        if (StringUtils.isBlank((CharSequence)href)) {
            return null;
        }
        int i = href.lastIndexOf("/avatar/");
        if (i != -1) {
            return href.substring(0, i) + "/avatar/50/";
        }
        return href;
    }
}

