/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.Messages;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.BitbucketServerApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.BitbucketServerEndpoint;
import io.jenkins.blueocean.commons.DigestUtils;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpoint;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;
import java.util.Iterator;
import java.util.LinkedList;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class BitbucketServerEndpointContainer
extends ScmServerEndpointContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitbucketServerEndpointContainer.class);
    private final Link self;

    public BitbucketServerEndpointContainer(Reachable parent) {
        this.self = parent.getLink().rel("servers");
    }

    public Link getLink() {
        return this.self;
    }

    public ScmServerEndpoint create(JSONObject request) {
        BitbucketEndpoint endpoint;
        String url;
        try {
            Jenkins.get().checkPermission(Item.CREATE);
        }
        catch (Exception e) {
            throw new ServiceException.ForbiddenException("User does not have permission to create repository", (Throwable)e);
        }
        LinkedList<ErrorMessage.Error> errors = new LinkedList<ErrorMessage.Error>();
        String name = (String)request.get("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            errors.add(new ErrorMessage.Error("name", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "name is required"));
        }
        if (StringUtils.isBlank((CharSequence)(url = (String)request.get("apiUrl")))) {
            errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "apiUrl is required"));
        } else {
            try {
                String version = BitbucketServerApi.getVersion(url);
                if (!BitbucketServerApi.isSupportedVersion(version)) {
                    errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), Messages.bbserver_version_validation_error(version, BitbucketServerApi.MINIMUM_SUPPORTED_VERSION)));
                } else if (BitbucketEndpointProvider.lookupEndpoint((String)url).isPresent()) {
                    errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), "apiUrl already exists"));
                }
            }
            catch (ServiceException e) {
                errors.add(new ErrorMessage.Error("apiUrl", ErrorMessage.Error.ErrorCodes.INVALID.toString(), StringUtils.isBlank((CharSequence)e.getMessage()) ? "Invalid URL" : e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to create Bitbucket server endpoint").addAll(errors));
        }
        try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
            endpoint = BitbucketEndpointProvider.registerEndpoint((String)name, (String)url, null);
        }
        return new BitbucketServerEndpoint(endpoint, (Reachable)this);
    }

    public ScmServerEndpoint get(String id) {
        for (BitbucketEndpoint endpoint : BitbucketEndpointProvider.all()) {
            if (!id.equals(DigestUtils.sha256Hex((String)endpoint.getServerURL()))) continue;
            return new BitbucketServerEndpoint(endpoint, (Reachable)this);
        }
        return null;
    }

    public Iterator<ScmServerEndpoint> iterator() {
        return BitbucketEndpointProvider.lookupEndpoint((EndpointType)EndpointType.SERVER).stream().map(bitbucketServerEndpoint -> new BitbucketServerEndpoint((BitbucketEndpoint)bitbucketServerEndpoint, (Reachable)this)).iterator();
    }
}

