/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.User;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.AbstractBitbucketScm;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketScmSaveFileRequest;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.BitbucketCloudScm;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.BitbucketServerScm;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.AbstractScmContentProvider;
import io.jenkins.blueocean.rest.impl.pipeline.scm.GitContent;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmContentProviderParams;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFile;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class AbstractBitbucketScmContentProvider
extends AbstractScmContentProvider {
    protected Object getContent(AbstractScmContentProvider.ScmGetRequest request) {
        BitbucketApi api = BitbucketServerScm.getApi(request.getApiUrl(), this.getScmId(), request.getCredentials());
        BbBranch branch = null;
        String branchName = request.getBranch();
        BbBranch defaultBranch = api.getDefaultBranch(request.getOwner(), request.getRepo());
        if (defaultBranch == null) {
            throw new ServiceException.NotFoundException(request.getPath() + " not found. This is empty and un-initialized repository");
        }
        if (branchName == null) {
            branch = defaultBranch;
        }
        if (branchName != null && (branch = api.getBranch(request.getOwner(), request.getRepo(), branchName)) == null) {
            throw new ServiceException.BadRequestException("branch: " + branchName + " not found");
        }
        String content = api.getContent(request.getOwner(), request.getRepo(), request.getPath(), branch.getLatestCommit());
        final GitContent gitContent = new GitContent.Builder().base64Data(Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8))).branch(request.getBranch()).size((Number)content.length()).path(request.getPath()).owner(request.getOwner()).repo(request.getRepo()).name(request.getPath()).sha(branch.getLatestCommit()).commitId(branch.getLatestCommit()).build();
        return new ScmFile<GitContent>(this){
            final /* synthetic */ AbstractBitbucketScmContentProvider this$0;
            {
                this.this$0 = this$0;
            }

            public GitContent getContent() {
                return gitContent;
            }
        };
    }

    protected ScmContentProviderParams getScmParamsFromItem(Item item) {
        return new BitbucketScmParams(item);
    }

    public Object saveContent(@NonNull StaplerRequest2 staplerRequest, @NonNull Item item) {
        JSONObject body;
        try {
            body = JSONObject.fromObject((Object)IOUtils.toString((Reader)staplerRequest.getReader()));
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to read request body");
        }
        BitbucketScmSaveFileRequest scmSaveFileRequest = (BitbucketScmSaveFileRequest)staplerRequest.bindJSON(BitbucketScmSaveFileRequest.class, body);
        if (scmSaveFileRequest == null) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to bind request"));
        }
        GitContent gitContent = scmSaveFileRequest.getContent();
        BitbucketScmParams scmParamsFromItem = new BitbucketScmParams(item);
        String owner = scmParamsFromItem.getOwner();
        String repo = scmParamsFromItem.getRepo();
        String commitId = StringUtils.isNotBlank((String)gitContent.getCommitId()) ? gitContent.getCommitId() : gitContent.getSha();
        BitbucketApi api = BitbucketServerScm.getApi(scmParamsFromItem.getApiUrl(), this.getScmId(), scmParamsFromItem.getCredentials());
        String content = new String(Base64.getDecoder().decode(gitContent.getBase64Data()), StandardCharsets.UTF_8);
        Object message = gitContent.getMessage();
        if (message == null) {
            message = gitContent.getPath() + " created with BlueOcean";
        }
        BbSaveContentResponse response = api.saveContent(owner, repo, gitContent.getPath(), content, (String)message, gitContent.getBranch(), gitContent.getSourceBranch(), commitId);
        final GitContent respContent = new GitContent.Builder().branch(gitContent.getBranch()).path(gitContent.getPath()).owner(gitContent.getOwner()).repo(gitContent.getRepo()).sha(response.getCommitId()).name(gitContent.getPath()).commitId(response.getCommitId()).build();
        return new ScmFile<GitContent>(this){
            final /* synthetic */ AbstractBitbucketScmContentProvider this$0;
            {
                this.this$0 = this$0;
            }

            public GitContent getContent() {
                return respContent;
            }
        };
    }

    @CheckForNull
    protected BitbucketSCMSource getSourceFromItem(@NonNull Item item) {
        List sources;
        if (item instanceof MultiBranchProject && !(sources = ((MultiBranchProject)item).getSCMSources()).isEmpty() && sources.get(0) instanceof BitbucketSCMSource) {
            return (BitbucketSCMSource)sources.get(0);
        }
        return null;
    }

    static class BitbucketScmParams
    extends ScmContentProviderParams {
        public BitbucketScmParams(Item item) {
            super(item);
        }

        protected String owner(@NonNull SCMSource scmSource) {
            if (scmSource instanceof BitbucketSCMSource) {
                BitbucketSCMSource bitbucketSCMSource = (BitbucketSCMSource)scmSource;
                return bitbucketSCMSource.getRepoOwner();
            }
            return null;
        }

        protected String owner(@NonNull SCMNavigator scmNavigator) {
            return null;
        }

        protected String repo(@NonNull SCMSource scmSource) {
            if (scmSource instanceof BitbucketSCMSource) {
                BitbucketSCMSource bitbucketSCMSource = (BitbucketSCMSource)scmSource;
                return bitbucketSCMSource.getRepository();
            }
            return null;
        }

        protected String apiUrl(@NonNull SCMSource scmSource) {
            if (scmSource instanceof BitbucketSCMSource) {
                return ((BitbucketSCMSource)scmSource).getServerUrl();
            }
            return null;
        }

        protected String apiUrl(@NonNull SCMNavigator scmNavigator) {
            return null;
        }

        @NonNull
        protected StandardUsernamePasswordCredentials getCredentialForUser(@NonNull Item item, @NonNull String apiUrl) {
            User user = User.current();
            if (user == null) {
                throw new ServiceException.UnauthorizedException("No logged in user found");
            }
            StaplerRequest2 request = Stapler.getCurrentRequest2();
            String scmId = request.getParameter("scmId");
            BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg(item);
            AbstractBitbucketScm scm = AbstractBitbucketScm.normalizeApiUrl(apiUrl).startsWith(AbstractBitbucketScm.normalizeApiUrl("https://bitbucket.org")) || StringUtils.isNotBlank((String)scmId) && scmId.equals("bitbucket-cloud") ? new BitbucketCloudScm(() -> {
                Objects.requireNonNull(organization);
                return organization.getLink().rel("scm");
            }) : new BitbucketServerScm(() -> {
                Objects.requireNonNull(organization);
                return organization.getLink().rel("scm");
            });
            StandardUsernamePasswordCredentials credential = scm.getCredential(AbstractBitbucketScm.normalizeApiUrl(apiUrl));
            if (credential == null) {
                throw new ServiceException.PreconditionRequired("Can't access content from Bitbucket: no credential found");
            }
            return credential;
        }
    }
}

