/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepository;
import java.util.Collections;
import java.util.Map;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class BbRepo {
    @JsonProperty(value="slug")
    public abstract String getSlug();

    @JsonProperty(value="name")
    public abstract String getName();

    @JsonProperty(value="organization")
    public abstract BbOrg getOrg();

    @Deprecated
    @JsonIgnore
    public abstract boolean isGit();

    @JsonProperty(value="private")
    public abstract boolean isPrivate();

    public ScmRepository toScmRepository(@NonNull BitbucketApi api, final @NonNull Reachable parent) {
        final BbBranch defaultBranch = api.getDefaultBranch(this.getOrg().getKey(), this.getSlug());
        return new ScmRepository(this){
            final /* synthetic */ BbRepo this$0;
            {
                this.this$0 = this$0;
            }

            public String getName() {
                return this.this$0.getSlug();
            }

            public boolean isPrivate() {
                return this.this$0.isPrivate();
            }

            public String getDescription() {
                return this.getName();
            }

            public String getDefaultBranch() {
                if (defaultBranch != null) {
                    return defaultBranch.getDisplayId();
                }
                return null;
            }

            public Map<String, Boolean> getPermissions() {
                return Collections.emptyMap();
            }

            public Link getLink() {
                return parent.getLink().rel(this.this$0.getSlug());
            }
        };
    }
}

