/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.HttpRequest;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbSaveContentResponse;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbUser;
import io.jenkins.blueocean.commons.ServiceException;
import java.util.Map;
import org.apache.http.client.HttpResponseException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class BitbucketApi {
    protected final String apiUrl;
    protected final String userName;
    protected final HttpRequest request;

    protected BitbucketApi(@NonNull String apiUrl, @NonNull StandardUsernamePasswordCredentials credentials) {
        this.apiUrl = BitbucketApi.ensureTrailingSlash(apiUrl);
        this.request = new HttpRequest.HttpRequestBuilder(apiUrl).credentials(credentials).build();
        this.userName = credentials.getUsername();
    }

    @NonNull
    public BbUser getUser() {
        return this.getUser(this.userName);
    }

    @NonNull
    public abstract BbUser getUser(@NonNull String var1);

    @NonNull
    public abstract BbPage<BbOrg> getOrgs(int var1, int var2);

    @NonNull
    public abstract BbOrg getOrg(@NonNull String var1);

    @NonNull
    public abstract BbRepo getRepo(@NonNull String var1, String var2);

    @NonNull
    public abstract BbPage<BbRepo> getRepos(@NonNull String var1, int var2, int var3);

    @NonNull
    public abstract String getContent(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull String var4);

    @NonNull
    public abstract BbSaveContentResponse saveContent(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull String var4, @NonNull String var5, @Nullable String var6, @Nullable String var7, @Nullable String var8);

    public abstract boolean fileExists(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull String var4);

    @CheckForNull
    public abstract BbBranch getBranch(@NonNull String var1, @NonNull String var2, @NonNull String var3);

    @NonNull
    public abstract BbBranch createBranch(@NonNull String var1, @NonNull String var2, Map<String, String> var3);

    @CheckForNull
    public abstract BbBranch getDefaultBranch(@NonNull String var1, @NonNull String var2);

    public abstract boolean isEmptyRepo(@NonNull String var1, @NonNull String var2);

    protected ServiceException handleException(Exception e) {
        if (e instanceof HttpResponseException) {
            return new ServiceException(((HttpResponseException)e).getStatusCode(), e.getMessage(), (Throwable)e);
        }
        return new ServiceException.UnexpectedErrorException(e.getMessage(), (Throwable)e);
    }

    protected static String ensureTrailingSlash(String url) {
        if (url.charAt(url.length() - 1) != '/') {
            return url + "/";
        }
        return url;
    }
}

