// CHECKSTYLE:OFF

package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code bbserver.version.validation.error}: {@code This Bitbucket
     * Server is too old ({0}) to work with Jenkins. Please upgrade Bitbucket
     * to {1} or later.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This Bitbucket Server is too old ({0}) to work with Jenkins.
     *     Please upgrade Bitbucket to {1} or later.}
     */
    public static String bbserver_version_validation_error(Object arg0, Object arg1) {
        return holder.format("bbserver.version.validation.error", arg0, arg1);
    }

    /**
     * Key {@code bbserver.version.validation.error}: {@code This Bitbucket
     * Server is too old ({0}) to work with Jenkins. Please upgrade Bitbucket
     * to {1} or later.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This Bitbucket Server is too old ({0}) to work with Jenkins.
     *     Please upgrade Bitbucket to {1} or later.}
     */
    public static Localizable _bbserver_version_validation_error(Object arg0, Object arg1) {
        return new Localizable(holder, "bbserver.version.validation.error", arg0, arg1);
    }

}
