/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.Secret;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftToken;
import io.fabric8.jenkins.openshiftsync.OpenShiftTokenCredentials;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.impl.FileCredentialsImpl;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;

public class CredentialsUtils {
    private static final String SECRET_TEXT_SECRET_TYPE = "secretText";
    private static final String FILE_SECRET_TYPE = "filename";
    private static final String TOKEN_SECRET_TYPE = "token";
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final Logger logger = Logger.getLogger(CredentialsUtils.class.getName());
    private static final Map<String, String> SOURCE_SECRET_TO_CREDS_MAP = new ConcurrentHashMap<String, String>();
    public static final String KUBERNETES_SERVICE_ACCOUNT = "Kubernetes Service Account";
    public static final ConcurrentHashMap<String, String> UID_TO_SECRET_MAP = new ConcurrentHashMap();

    public static io.fabric8.kubernetes.api.model.Secret getSourceSecretForBuildConfig(BuildConfig buildConfig) {
        String sourceSecretName;
        LocalObjectReference sourceSecret;
        BuildSource source;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec != null && (source = spec.getSource()) != null && (sourceSecret = source.getSourceSecret()) != null && (sourceSecretName = sourceSecret.getName()) != null && !sourceSecretName.isEmpty()) {
            ObjectMeta buildConfigMetadata = buildConfig.getMetadata();
            String namespace = buildConfigMetadata.getNamespace();
            String name = buildConfigMetadata.getName();
            logger.info("Retrieving SourceSecret for BuildConfig " + name + " in Namespace " + namespace);
            OpenShiftClient client = OpenShiftUtils.getAuthenticatedOpenShiftClient();
            io.fabric8.kubernetes.api.model.Secret secret = (io.fabric8.kubernetes.api.model.Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(sourceSecretName)).get();
            if (secret != null) {
                return secret;
            }
            String message = "Secret Name provided in BuildConfig " + name + " as " + sourceSecretName;
            message = message + " does not exist. Please review the BuildConfig and make the necessary changes.";
            logger.warning(message);
        }
        return null;
    }

    public static String updateSourceCredentials(BuildConfig buildConfig) throws IOException {
        ObjectMeta sourceSecretMetadata;
        String credentialsName = null;
        io.fabric8.kubernetes.api.model.Secret sourceSecret = CredentialsUtils.getSourceSecretForBuildConfig(buildConfig);
        if (sourceSecret != null && (sourceSecretMetadata = sourceSecret.getMetadata()) != null) {
            String namespace = sourceSecretMetadata.getNamespace();
            String secretName = sourceSecretMetadata.getName();
            ObjectMeta buildConfigMetadata = buildConfig.getMetadata();
            String buildConfigName = buildConfigMetadata.getName();
            credentialsName = CredentialsUtils.insertOrUpdateCredentialsFromSecret(sourceSecret);
            String buildConfigAsString = NamespaceName.create((HasMetadata)buildConfig).toString();
            if (credentialsName != null) {
                logger.info("Linking sourceSecret " + secretName + " to Jenkins Credentials " + credentialsName);
                CredentialsUtils.linkSourceSecretToCredentials(buildConfigAsString, credentialsName);
                return credentialsName;
            }
            logger.info("Unlinking BuildConfig sourceSecret matching BuildConfig " + buildConfigName);
            credentialsName = CredentialsUtils.unlinkBCSecretToCrendential(buildConfigAsString);
            if (credentialsName != null) {
                logger.info("Deleting sourceSecret " + secretName + " in namespace " + namespace);
                String resourceVersion = buildConfigMetadata.getResourceVersion();
                CredentialsUtils.deleteCredential(credentialsName, NamespaceName.create((HasMetadata)buildConfig), resourceVersion);
            }
        }
        return credentialsName;
    }

    public static void deleteSourceCredentials(BuildConfig buildConfig) throws IOException {
        Map labels;
        ObjectMeta metadata;
        io.fabric8.kubernetes.api.model.Secret sourceSecret = CredentialsUtils.getSourceSecretForBuildConfig(buildConfig);
        if (sourceSecret != null && (metadata = sourceSecret.getMetadata()) != null && (labels = metadata.getLabels()) != null) {
            boolean watching;
            String labelValue = (String)labels.get("credential.sync.jenkins.openshift.io");
            boolean bl = watching = labelValue != null && labelValue.equalsIgnoreCase("true");
            if (watching) {
                return;
            }
            CredentialsUtils.deleteCredential(sourceSecret);
        }
    }

    private static String getSecretCustomName(io.fabric8.kubernetes.api.model.Secret secret) {
        String secretName;
        Map annotations;
        ObjectMeta metadata = secret.getMetadata();
        if (metadata != null && (annotations = metadata.getAnnotations()) != null && (secretName = (String)annotations.get("jenkins.openshift.io/secret.name")) != null) {
            return secretName;
        }
        return null;
    }

    public static String upsertCredential(io.fabric8.kubernetes.api.model.Secret secret) throws IOException {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            return CredentialsUtils.insertOrUpdateCredentialsFromSecret(secret);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String insertOrUpdateCredentialsFromSecret(io.fabric8.kubernetes.api.model.Secret secret) throws IOException {
        if (secret != null) {
            String customSecretName = CredentialsUtils.getSecretCustomName(secret);
            ObjectMeta metadata = secret.getMetadata();
            String namespace = metadata.getNamespace();
            String secretName = metadata.getName();
            Credentials creds = CredentialsUtils.secretToCredentials(secret);
            if (creds != null) {
                String id = CredentialsUtils.generateCredentialsName(namespace, secretName, customSecretName);
                Credentials existingCreds = CredentialsUtils.lookupCredentials(id);
                SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
                try {
                    CredentialsStore creentialsStore = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getActiveInstance()).iterator().next();
                    String originalId = CredentialsUtils.generateCredentialsName(namespace, secretName, null);
                    Credentials existingOriginalCreds = CredentialsUtils.lookupCredentials(originalId);
                    NamespaceName secretNamespaceName = null;
                    String secretUid = metadata.getUid();
                    if (!originalId.equals(id)) {
                        boolean hasAddedCredential = creentialsStore.addCredentials(Domain.global(), creds);
                        if (!hasAddedCredential) {
                            logger.warning("Setting secret  failed for secret with new Id " + id + " from Secret " + String.valueOf(secretNamespaceName) + " with revision: " + metadata.getResourceVersion());
                            logger.warning("Check if Id " + id + " is not already used.");
                        } else {
                            String oldId = UID_TO_SECRET_MAP.get(secretUid);
                            if (oldId != null) {
                                Credentials oldCredentials = CredentialsUtils.lookupCredentials(oldId);
                                creentialsStore.removeCredentials(Domain.global(), oldCredentials);
                            } else if (existingOriginalCreds != null) {
                                creentialsStore.removeCredentials(Domain.global(), existingOriginalCreds);
                            }
                            UID_TO_SECRET_MAP.put(secretUid, id);
                            secretNamespaceName = NamespaceName.create((HasMetadata)secret);
                            logger.info("Updated credential " + oldId + " with new Id " + id + " from Secret " + String.valueOf(secretNamespaceName) + " with revision: " + metadata.getResourceVersion());
                        }
                    } else if (existingCreds != null) {
                        creentialsStore.updateCredentials(Domain.global(), existingCreds, creds);
                        UID_TO_SECRET_MAP.put(secretUid, id);
                        secretNamespaceName = NamespaceName.create((HasMetadata)secret);
                        logger.info("Updated credential " + id + " from Secret " + String.valueOf(secretNamespaceName) + " with revision: " + metadata.getResourceVersion());
                    } else {
                        boolean hasAddedCredential = creentialsStore.addCredentials(Domain.global(), creds);
                        if (!hasAddedCredential) {
                            logger.warning("Update failed for secret with new Id " + id + " from Secret " + String.valueOf(secretNamespaceName) + " with revision: " + metadata.getResourceVersion());
                        } else {
                            UID_TO_SECRET_MAP.put(secretUid, id);
                            secretNamespaceName = NamespaceName.create((HasMetadata)secret);
                            logger.info("Created credential " + id + " from Secret " + String.valueOf(secretNamespaceName) + " with revision: " + metadata.getResourceVersion());
                        }
                    }
                    creentialsStore.save();
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)previousContext);
                }
                if (id != null && !id.isEmpty()) {
                    return id;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCredential(String id, NamespaceName name, String resourceRevision) throws IOException {
        Credentials existingCred = CredentialsUtils.lookupCredentials(id);
        if (existingCred != null) {
            SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                Fingerprint fp = CredentialsProvider.getFingerprintOf((Credentials)existingCred);
                if (fp != null && fp.getJobs().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (String job : fp.getJobs()) {
                        sb.append(job).append(" ");
                    }
                    logger.info("About to delete credential " + id + "which is referenced by jobs: " + sb.toString());
                }
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getActiveInstance()).iterator().next();
                if (!existingCred.getDescriptor().getDisplayName().contains(KUBERNETES_SERVICE_ACCOUNT)) {
                    s.removeCredentials(Domain.global(), existingCred);
                    logger.info("Deleted credential " + id + " from Secret " + String.valueOf(name) + " with revision: " + resourceRevision);
                    s.save();
                } else {
                    logger.warning("Stopped attempt to delete Kubernetes Service Account credentials with Id " + id);
                }
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousContext);
            }
        }
    }

    public static void deleteCredential(io.fabric8.kubernetes.api.model.Secret secret) {
        if (secret != null) {
            String id = CredentialsUtils.generateCredentialsName(secret.getMetadata().getNamespace(), secret.getMetadata().getName(), CredentialsUtils.getSecretCustomName(secret));
            try {
                CredentialsUtils.deleteCredential(id, NamespaceName.create((HasMetadata)secret), secret.getMetadata().getResourceVersion());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Credentials has not been deleted: " + String.valueOf(e), e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String getCurrentToken() {
        String credentialsId = GlobalPluginConfiguration.get().getCredentialsId();
        if (credentialsId.equals("")) {
            return "";
        }
        OpenShiftToken token = (OpenShiftToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(OpenShiftToken.class, (ItemGroup)Jenkins.getActiveInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (token != null) {
            return token.getToken();
        }
        return "";
    }

    private static Credentials lookupCredentials(String id) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (ItemGroup)Jenkins.getActiveInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    private static String generateCredentialsName(String namespace, String name, String customName) {
        return customName == null ? namespace + "-" + name : customName;
    }

    private static Credentials arbitraryKeyValueTextCredential(Map<String, String> data, String generatedCredentialsName) {
        String text = "";
        if (data != null && data.size() > 0) {
            try {
                text = new ObjectMapper().writeValueAsString(data);
            }
            catch (JsonProcessingException e) {
                logger.log(Level.WARNING, "Arbitrary opaque secret " + generatedCredentialsName + " had issue converting json", e);
            }
        }
        if (StringUtils.isBlank((String)text)) {
            logger.log(Level.WARNING, "Opaque secret {0} did not provide any data that could be processed into a Jenkins credential", new Object[]{generatedCredentialsName});
            return null;
        }
        return CredentialsUtils.newSecretTextCredential(generatedCredentialsName, new String(Base64.getEncoder().encode(text.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
    }

    private static Credentials secretToCredentials(io.fabric8.kubernetes.api.model.Secret secret) {
        String namespace = secret.getMetadata().getNamespace();
        String name = secret.getMetadata().getName();
        Map data = secret.getData();
        if (data == null) {
            logger.log(Level.WARNING, "Secret " + name + " does not contain any data. No credential will be created.");
            return null;
        }
        String generatedCredentialsName = CredentialsUtils.generateCredentialsName(namespace, name, CredentialsUtils.getSecretCustomName(secret));
        String passwordData = (String)data.get("password");
        String sshKeyData = (String)data.get("ssh-privatekey");
        String usernameData = (String)data.get("username");
        String passphraseData = (String)data.get("passphrase");
        String sshPassphrase = StringUtils.isNotBlank((String)passphraseData) ? passphraseData : passwordData;
        switch (secret.getType()) {
            case "Opaque": {
                if (StringUtils.isNotBlank((String)usernameData) && StringUtils.isNotBlank((String)passwordData)) {
                    return CredentialsUtils.newUsernamePasswordCredentials(generatedCredentialsName, usernameData, passwordData);
                }
                if (StringUtils.isNotBlank((String)sshKeyData)) {
                    return CredentialsUtils.newSSHUserCredential(generatedCredentialsName, usernameData, sshKeyData, sshPassphrase);
                }
                String fileData = (String)data.get(FILE_SECRET_TYPE);
                if (StringUtils.isNotBlank((String)fileData)) {
                    return CredentialsUtils.newSecretFileCredential(generatedCredentialsName, fileData);
                }
                String certificateData = (String)data.get("certificate");
                if (StringUtils.isNotBlank((String)certificateData)) {
                    return CredentialsUtils.newCertificateCredential(generatedCredentialsName, passwordData, certificateData);
                }
                String secretTextData = (String)data.get("secrettext");
                if (StringUtils.isNotBlank((String)secretTextData)) {
                    return CredentialsUtils.newSecretTextCredential(generatedCredentialsName, secretTextData);
                }
                String openshiftTokenData = (String)data.get("openshift-client-token");
                if (StringUtils.isNotBlank((String)openshiftTokenData)) {
                    return CredentialsUtils.newOpenshiftTokenCredentials(generatedCredentialsName, openshiftTokenData);
                }
                return CredentialsUtils.arbitraryKeyValueTextCredential(data, generatedCredentialsName);
            }
            case "kubernetes.io/basic-auth": {
                return CredentialsUtils.newUsernamePasswordCredentials(generatedCredentialsName, usernameData, passwordData);
            }
            case "kubernetes.io/ssh-auth": {
                return CredentialsUtils.newSSHUserCredential(generatedCredentialsName, usernameData, sshKeyData, sshPassphrase);
            }
        }
        return CredentialsUtils.arbitraryKeyValueTextCredential(data, generatedCredentialsName);
    }

    private static Credentials newOpenshiftTokenCredentials(String secretName, String secretText) {
        if (secretName == null || secretName.length() == 0 || secretText == null || secretText.length() == 0) {
            CredentialsUtils.logInvalidSecretData(secretName, secretText, TOKEN_SECRET_TYPE);
            return null;
        }
        return new OpenShiftTokenCredentials(CredentialsScope.GLOBAL, secretName, secretName, Secret.fromString((String)new String(DECODER.decode(secretText), StandardCharsets.UTF_8)));
    }

    private static Credentials newSecretFileCredential(String secretName, String fileData) {
        if (secretName == null || secretName.length() == 0 || fileData == null || fileData.length() == 0) {
            CredentialsUtils.logInvalidSecretData(secretName, fileData, FILE_SECRET_TYPE);
            return null;
        }
        return new FileCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, secretName, SecretBytes.fromString((String)fileData));
    }

    private static Credentials newSecretTextCredential(String secretName, String secretText) {
        if (secretName == null || secretName.length() == 0 || secretText == null || secretText.length() == 0) {
            CredentialsUtils.logInvalidSecretData(secretName, secretText, SECRET_TEXT_SECRET_TYPE);
            return null;
        }
        String data = new String(DECODER.decode(secretText), StandardCharsets.UTF_8);
        return new StringCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, Secret.fromString((String)data));
    }

    private static Credentials newCertificateCredential(String secretName, String passwordData, String certificateData) {
        if (secretName == null || secretName.length() == 0 || certificateData == null || certificateData.length() == 0) {
            CredentialsUtils.logInvalidSecretData(secretName, certificateData, "certificate");
            return null;
        }
        String certificatePassword = passwordData != null ? new String(DECODER.decode(passwordData), StandardCharsets.UTF_8) : null;
        return new CertificateCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, certificatePassword, (CertificateCredentialsImpl.KeyStoreSource)new CertificateCredentialsImpl.UploadedKeyStoreSource(SecretBytes.fromString((String)certificateData)));
    }

    private static void logInvalidSecretData(String secretName, String secretText, String secretType) {
        logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " " + secretType + " is null: " + (secretText == null) + " " + secretType + " is empty: " + (secretText != null ? secretText.length() == 0 : false));
    }

    private static Credentials newSSHUserCredential(String secretName, String username, String sshKeyData, String passwordData) {
        boolean secretNameIsBlank = StringUtils.isBlank((String)secretName);
        boolean sshKeyDataIsBlank = StringUtils.isBlank((String)sshKeyData);
        if (secretNameIsBlank || sshKeyDataIsBlank) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " sshKeyData is blank null: " + sshKeyDataIsBlank);
            return null;
        }
        String sshKeyPassword = passwordData != null ? new String(DECODER.decode(passwordData), StandardCharsets.UTF_8) : null;
        String sshKey = new String(DECODER.decode(sshKeyData), StandardCharsets.UTF_8);
        String sshUser = Util.fixNull((String)username).isEmpty() ? "" : new String(DECODER.decode(username), StandardCharsets.UTF_8);
        BasicSSHUserPrivateKey.DirectEntryPrivateKeySource key = new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(sshKey);
        return new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, secretName, sshUser, (BasicSSHUserPrivateKey.PrivateKeySource)key, sshKeyPassword, secretName);
    }

    private static Credentials newUsernamePasswordCredentials(String secretName, String usernameData, String passwordData) {
        if (secretName == null || secretName.length() == 0 || usernameData == null || usernameData.length() == 0 || passwordData == null || passwordData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " usernameData is null: " + (usernameData == null) + " usernameData is empty: " + (usernameData != null ? usernameData.length() == 0 : false) + " passwordData is null: " + (passwordData == null) + " passwordData is empty: " + (passwordData != null ? passwordData.length() == 0 : false));
            return null;
        }
        try {
            return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, new String(DECODER.decode(usernameData), StandardCharsets.UTF_8), new String(DECODER.decode(passwordData), StandardCharsets.UTF_8));
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasCredentials() {
        return !StringUtils.isEmpty((String)OpenShiftUtils.getAuthenticatedOpenShiftClient().getConfiguration().getOauthToken());
    }

    static void linkSourceSecretToCredentials(String bc, String credential) {
        SOURCE_SECRET_TO_CREDS_MAP.put(bc, credential);
    }

    static String unlinkBCSecretToCrendential(String bc) {
        return SOURCE_SECRET_TO_CREDS_MAP.remove(bc);
    }
}

