/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildSyncRunListener;
import io.fabric8.jenkins.openshiftsync.BuildToActionMapper;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class BuildDecisionHandler
extends Queue.QueueDecisionHandler {
    private static final Logger LOGGER = Logger.getLogger(BuildDecisionHandler.class.getName());

    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        WorkflowJob wj;
        BuildConfigProjectProperty buildConfigProjectProperty;
        if (p instanceof WorkflowJob && !BuildDecisionHandler.isOpenShiftBuildCause(actions) && (buildConfigProjectProperty = (BuildConfigProjectProperty)(wj = (WorkflowJob)p).getProperty(BuildConfigProjectProperty.class)) != null && StringUtils.isNotBlank((String)buildConfigProjectProperty.getNamespace()) && StringUtils.isNotBlank((String)buildConfigProjectProperty.getName())) {
            String namespace = buildConfigProjectProperty.getNamespace();
            String jobURL = BuildSyncRunListener.joinPaths(OpenShiftUtils.getJenkinsURL(OpenShiftUtils.getAuthenticatedOpenShiftClient(), namespace), wj.getUrl());
            Build ret = (Build)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(namespace)).withName(buildConfigProjectProperty.getName())).instantiate(((BuildRequestBuilder)((BuildRequestFluent.TriggeredByNested)((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName(buildConfigProjectProperty.getName())).and()).addNewTriggeredBy().withMessage("Triggered by Jenkins job at " + jobURL)).and()).build());
            ParametersAction params = BuildDecisionHandler.dumpParams(actions);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ParametersAction: " + String.valueOf(params));
            }
            if (params != null && ret != null) {
                BuildToActionMapper.addParameterAction(ret.getMetadata().getName(), params);
            }
            CauseAction cause = BuildDecisionHandler.dumpCause(actions);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("get CauseAction: " + cause.getDisplayName());
                for (Cause c : cause.getCauses()) {
                    LOGGER.fine("Cause: " + c.getShortDescription());
                }
            }
            if (cause != null && ret != null) {
                BuildToActionMapper.addCauseAction(ret.getMetadata().getName(), cause);
            }
            return false;
        }
        return true;
    }

    private static boolean isOpenShiftBuildCause(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            for (Cause cause : causeAction.getCauses()) {
                if (!(cause instanceof BuildCause)) continue;
                return true;
            }
        }
        return false;
    }

    private static CauseAction dumpCause(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            if (LOGGER.isLoggable(Level.FINE)) {
                for (Cause cause : causeAction.getCauses()) {
                    LOGGER.fine("cause: " + cause.getShortDescription());
                }
            }
            return causeAction;
        }
        return null;
    }

    private static ParametersAction dumpParams(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof ParametersAction)) continue;
            ParametersAction paramAction = (ParametersAction)action;
            if (LOGGER.isLoggable(Level.FINE)) {
                for (ParameterValue param : paramAction.getAllParameters()) {
                    LOGGER.fine("param name " + param.getName() + " param value " + String.valueOf(param.getValue()));
                }
            }
            return paramAction;
        }
        return null;
    }
}

