/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.model.Descriptor;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.Branch;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;

public class BuildConfigToJobMapper {
    public static final String JENKINS_PIPELINE_BUILD_STRATEGY = "JenkinsPipeline";
    public static final String DEFAULT_JENKINS_FILEPATH = "Jenkinsfile";
    private static final Logger LOGGER = Logger.getLogger(BuildConfigToJobMapper.class.getName());
    private static final String GIT_SCM_TYPE = "Git";

    public static FlowDefinition mapBuildConfigToFlow(BuildConfig bc) throws IOException {
        if (!OpenShiftUtils.isPipelineStrategyBuildConfig(bc)) {
            return null;
        }
        BuildSource source = null;
        String jenkinsfile = null;
        String jenkinsfilePath = null;
        BuildConfigSpec spec = bc.getSpec();
        if (spec != null) {
            JenkinsPipelineBuildStrategy jenkinsPipelineStrategy;
            source = spec.getSource();
            BuildStrategy strategy = spec.getStrategy();
            if (strategy != null && (jenkinsPipelineStrategy = strategy.getJenkinsPipelineStrategy()) != null) {
                jenkinsfile = jenkinsPipelineStrategy.getJenkinsfile();
                jenkinsfilePath = jenkinsPipelineStrategy.getJenkinsfilePath();
            }
        }
        if (jenkinsfile == null) {
            if (source != null && source.getGit() != null && source.getGit().getUri() != null) {
                if (jenkinsfilePath == null) {
                    jenkinsfilePath = DEFAULT_JENKINS_FILEPATH;
                }
                if (!StringUtils.isEmpty((String)source.getContextDir())) {
                    jenkinsfilePath = new File(source.getContextDir(), jenkinsfilePath).getPath();
                }
                GitBuildSource gitSource = source.getGit();
                String branchRef = gitSource.getRef();
                List<Object> branchSpecs = Collections.emptyList();
                if (StringUtils.isNotBlank((String)branchRef)) {
                    branchSpecs = Collections.singletonList(new BranchSpec(branchRef));
                }
                String credentialsId = CredentialsUtils.updateSourceCredentials(bc);
                String refspec = OpenShiftUtils.getAnnotation((HasMetadata)bc, "jenkins.openshift.io/refspec");
                UserRemoteConfig remoteConfig = new UserRemoteConfig(gitSource.getUri(), null, refspec, credentialsId);
                List<UserRemoteConfig> userRemoteConfigs = Collections.singletonList(remoteConfig);
                List submoduleCfg = Collections.emptyList();
                List extensions = Collections.emptyList();
                GitSCM scm = new GitSCM(userRemoteConfigs, branchSpecs, Boolean.valueOf(false), submoduleCfg, null, null, extensions);
                return new CpsScmFlowDefinition((SCM)scm, jenkinsfilePath);
            }
            LOGGER.warning("BuildConfig does not contain source repository: cannot map BuildConfig to Jenkins job");
            return null;
        }
        try {
            return new CpsFlowDefinition(jenkinsfile, true);
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean updateBuildConfigFromJob(WorkflowJob job, BuildConfig buildConfig) {
        BuildStrategy strategy;
        NamespaceName namespaceName = NamespaceName.create((HasMetadata)buildConfig);
        JenkinsPipelineBuildStrategy jenkinsPipelineStrategy = null;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec != null && (strategy = spec.getStrategy()) != null) {
            jenkinsPipelineStrategy = strategy.getJenkinsPipelineStrategy();
        }
        if (jenkinsPipelineStrategy == null) {
            LOGGER.warning("No jenkinsPipelineStrategy available in the BuildConfig " + String.valueOf(namespaceName));
            return false;
        }
        FlowDefinition definition = job.getDefinition();
        if (definition instanceof CpsScmFlowDefinition) {
            return BuildConfigToJobMapper.updateScmFlowDefinition(buildConfig, namespaceName, jenkinsPipelineStrategy, definition);
        }
        if (definition instanceof CpsFlowDefinition) {
            return BuildConfigToJobMapper.updateCpsFlowDefinition(namespaceName, jenkinsPipelineStrategy, definition);
        }
        return BuildConfigToJobMapper.updateBranchName(job, buildConfig, namespaceName, jenkinsPipelineStrategy, definition);
    }

    private static boolean updateBranchName(WorkflowJob job, BuildConfig buildConfig, NamespaceName namespaceName, JenkinsPipelineBuildStrategy jenkinsPipelineStrategy, FlowDefinition definition) {
        Branch branch;
        BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
        if (property != null && (branch = property.getBranch()) != null) {
            String ref = branch.getName();
            SCM scm = branch.getScm();
            BuildConfigSpec spec = buildConfig.getSpec();
            BuildSource source = BuildConfigToJobMapper.getOrCreateBuildSource(spec);
            buildConfig.getSpec().getSource().getGit().setRef(ref);
            if (scm instanceof GitSCM && BuildConfigToJobMapper.populateFromGitSCM(buildConfig, source, (GitSCM)scm, ref)) {
                if (StringUtils.isEmpty((String)jenkinsPipelineStrategy.getJenkinsfilePath())) {
                    jenkinsPipelineStrategy.setJenkinsfilePath(DEFAULT_JENKINS_FILEPATH);
                }
                return true;
            }
        }
        String clazz = definition == null ? "null" : definition.getClass().getName();
        LOGGER.warning("Cannot update BuildConfig " + String.valueOf(namespaceName) + " as the definition is of class " + clazz);
        return false;
    }

    private static boolean updateCpsFlowDefinition(NamespaceName namespaceName, JenkinsPipelineBuildStrategy jenkinsPipelineStrategy, FlowDefinition definition) {
        CpsFlowDefinition cpsFlowDefinition = (CpsFlowDefinition)definition;
        String jenkinsfile = cpsFlowDefinition.getScript();
        if (jenkinsfile != null && jenkinsfile.trim().length() > 0 && !jenkinsfile.equals(jenkinsPipelineStrategy.getJenkinsfile())) {
            LOGGER.log(Level.INFO, "updating bc " + String.valueOf(namespaceName) + " jenkinsfile to " + jenkinsfile + " where old jenkinsfile was " + jenkinsPipelineStrategy.getJenkinsfile());
            jenkinsPipelineStrategy.setJenkinsfile(jenkinsfile);
            return true;
        }
        return false;
    }

    private static boolean updateScmFlowDefinition(BuildConfig buildConfig, NamespaceName namespaceName, JenkinsPipelineBuildStrategy jenkinsPipelineStrategy, FlowDefinition definition) {
        CpsScmFlowDefinition cpsScmFlowDefinition = (CpsScmFlowDefinition)definition;
        String scriptPath = cpsScmFlowDefinition.getScriptPath();
        if (scriptPath != null && scriptPath.trim().length() > 0) {
            SCM scm;
            boolean rc = false;
            BuildConfigSpec spec = buildConfig.getSpec();
            BuildSource source = BuildConfigToJobMapper.getOrCreateBuildSource(spec);
            String bcContextDir = source.getContextDir();
            if (StringUtils.isNotBlank((String)bcContextDir) && scriptPath.startsWith(bcContextDir)) {
                scriptPath = scriptPath.replaceFirst("^" + bcContextDir + "/?", "");
            }
            if (!scriptPath.equals(jenkinsPipelineStrategy.getJenkinsfilePath())) {
                LOGGER.log(Level.INFO, "updating bc " + String.valueOf(namespaceName) + " jenkinsfile path to " + scriptPath + " from ");
                rc = true;
                jenkinsPipelineStrategy.setJenkinsfilePath(scriptPath);
            }
            if ((scm = cpsScmFlowDefinition.getScm()) instanceof GitSCM) {
                BuildConfigToJobMapper.populateFromGitSCM(buildConfig, source, (GitSCM)scm, null);
                LOGGER.log(Level.INFO, "updating bc " + String.valueOf(namespaceName));
                rc = true;
            }
            return rc;
        }
        return false;
    }

    private static boolean populateFromGitSCM(BuildConfig buildConfig, BuildSource source, GitSCM gitSCM, String ref) {
        LOGGER.info("Populating SCM from BuildConfig " + String.valueOf(buildConfig) + " for branch: " + ref);
        source.setType(GIT_SCM_TYPE);
        List repositories = gitSCM.getRepositories();
        if (repositories != null && repositories.size() > 0) {
            URIish urIish;
            String gitUrl;
            RemoteConfig remote;
            List urIs;
            if (repositories.size() > 1) {
                LOGGER.warning("Configuration contains more than 1 repos: OpenShift Sync only support single repo.");
            }
            if ((urIs = (remote = (RemoteConfig)repositories.get(0)).getURIs()) != null && urIs.size() > 0 && (gitUrl = (urIish = (URIish)urIs.get(0)).toString()) != null && gitUrl.length() > 0) {
                List branches;
                if (StringUtils.isEmpty((String)ref) && (branches = gitSCM.getBranches()) != null && branches.size() > 0) {
                    BranchSpec branchSpec = (BranchSpec)branches.get(0);
                    String branch = branchSpec.getName();
                    while (branch.startsWith("*") || branch.startsWith("/")) {
                        branch = branch.substring(1);
                    }
                    if (!branch.isEmpty()) {
                        ref = branch;
                    }
                }
                OpenShiftUtils.updateGitSourceUrl(buildConfig, gitUrl, ref);
                return true;
            }
        }
        return false;
    }

    private static BuildSource getOrCreateBuildSource(BuildConfigSpec spec) {
        BuildSource source = spec.getSource();
        if (source == null) {
            source = new BuildSource();
            spec.setSource(source);
        }
        return source;
    }
}

