/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildConfigProjectProperty
extends JobProperty<Job<?, ?>> {
    private String uid;
    private String namespace;
    private String name;
    private String resourceVersion;
    private String buildRunPolicy;

    @DataBoundConstructor
    public BuildConfigProjectProperty(String namespace, String name, String uid, String resourceVersion, String buildRunPolicy) {
        this.namespace = namespace;
        this.name = name;
        this.uid = uid;
        this.resourceVersion = resourceVersion;
        this.buildRunPolicy = buildRunPolicy;
    }

    public BuildConfigProjectProperty(BuildConfig bc) {
        this(bc.getMetadata().getNamespace(), bc.getMetadata().getName(), bc.getMetadata().getUid(), bc.getMetadata().getResourceVersion(), bc.getSpec().getRunPolicy());
    }

    public BuildConfig getBuildConfig() {
        BuildConfig bc = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().buildConfigs().inNamespace(this.namespace)).withName(this.name)).get();
        if (bc != null && bc.getMetadata().getUid().equals(this.uid)) {
            return bc;
        }
        return null;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public String getBuildRunPolicy() {
        return this.buildRunPolicy;
    }

    public void setBuildRunPolicy(String buildRunPolicy) {
        this.buildRunPolicy = buildRunPolicy;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return WorkflowJob.class.isAssignableFrom(jobType);
        }
    }
}

