/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Job;
import hudson.remoting.Callable;
import hudson.security.ACL;
import io.fabric8.jenkins.openshiftsync.BuildConfigProjectProperty;
import io.fabric8.jenkins.openshiftsync.BuildConfigToJobMap;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.JobProcessor;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class BuildConfigManager {
    private static final Logger logger = Logger.getLogger(BuildConfigManager.class.getName());
    private static final Set<String> deletesInProgress;

    public static boolean isDeleteInProgress(String ns, String bcName) {
        return deletesInProgress.contains(ns + "/" + bcName);
    }

    public static void deleteCompleted(String ns, String bcName) {
        deletesInProgress.remove(ns + "/" + bcName);
    }

    public static void deleteInProgress(String ns, String bcName) {
        deletesInProgress.add(ns + "/" + bcName);
    }

    @Deprecated
    public static boolean isDeleteInProgress(String bcID) {
        return deletesInProgress.contains(bcID);
    }

    @Deprecated
    public static void deleteCompleted(String bcID) {
        deletesInProgress.remove(bcID);
    }

    @Deprecated
    public static void deleteInProgress(String bcName) {
        deletesInProgress.add(bcName);
    }

    static void modifyEventToJenkinsJob(BuildConfig buildConfig) throws Exception {
        if (OpenShiftUtils.isPipelineStrategyBuildConfig(buildConfig)) {
            BuildConfigManager.upsertJob(buildConfig);
            return;
        }
        BuildConfigManager.deleteEventToJenkinsJob(buildConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void upsertJob(BuildConfig buildConfig) throws Exception {
        if (OpenShiftUtils.isPipelineStrategyBuildConfig(buildConfig)) {
            String string = buildConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new JobProcessor(buildConfig));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteEventToJenkinsJob(BuildConfig buildConfig) throws Exception {
        if (buildConfig != null) {
            String bcUid = buildConfig.getMetadata().getUid();
            if (bcUid != null && bcUid.length() > 0) {
                String string = bcUid = bcUid.intern();
                synchronized (string) {
                    BuildConfigManager.innerDeleteEventToJenkinsJob(buildConfig);
                    return;
                }
            }
            BuildConfigManager.innerDeleteEventToJenkinsJob(buildConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerDeleteEventToJenkinsJob(final BuildConfig buildConfig) throws Exception {
        WorkflowJob job = BuildConfigToJobMap.getJobFromBuildConfig(buildConfig);
        if (job != null) {
            String string = buildConfig.getMetadata().getUid().intern();
            synchronized (string) {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>((Job)job){
                    final /* synthetic */ Job val$job;
                    {
                        this.val$job = job;
                    }

                    public Void call() throws Exception {
                        ObjectMeta metadata = buildConfig.getMetadata();
                        try {
                            BuildConfigManager.deleteInProgress(metadata.getNamespace(), metadata.getName());
                            this.val$job.delete();
                        }
                        finally {
                            BuildConfigToJobMap.removeJobWithBuildConfig(buildConfig);
                            Jenkins.getActiveInstance().rebuildDependencyGraphAsync();
                            BuildConfigManager.deleteCompleted(metadata.getNamespace(), metadata.getName());
                        }
                        return null;
                    }
                });
                CredentialsUtils.deleteSourceCredentials(buildConfig);
            }
        }
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    static void reconcileJobsAndBuildConfigs() {
        logger.info("Reconciling jobs and build configs");
        List jobs = Jenkins.getActiveInstance().getAllItems(WorkflowJob.class);
        for (final WorkflowJob job : jobs) {
            BuildConfigProjectProperty property = (BuildConfigProjectProperty)job.getProperty(BuildConfigProjectProperty.class);
            if (property == null) continue;
            final String ns = property.getNamespace();
            final String name = property.getName();
            if (!StringUtils.isNotBlank((String)ns) || !StringUtils.isNotBlank((String)name)) continue;
            logger.info("Checking job " + String.valueOf(job) + " runs for BuildConfig " + ns + "/" + name);
            OpenShiftClient client = OpenShiftUtils.getAuthenticatedOpenShiftClient();
            BuildConfig bc = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(ns)).withName(name)).get();
            if (bc != null) continue;
            try {
                ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

                    public Void call() throws Exception {
                        try {
                            BuildConfigManager.deleteInProgress(ns, name);
                            job.delete();
                        }
                        finally {
                            BuildConfigToJobMap.removeJobWithBuildConfigNameNamespace(name, ns);
                            Jenkins.getActiveInstance().rebuildDependencyGraphAsync();
                            BuildConfigManager.deleteCompleted(ns, name);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.log(Level.INFO, "reconcileJobsAndBuildConfigs", e);
            }
        }
    }

    static {
        BuildConfigManager.reconcileJobsAndBuildConfigs();
        deletesInProgress = ConcurrentHashMap.newKeySet();
    }
}

