/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.BuildConfigManager;
import io.fabric8.jenkins.openshiftsync.BuildManager;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.openshift.api.model.BuildConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigClusterInformer
implements ResourceEventHandler<BuildConfig>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private SharedIndexInformer<BuildConfig> informer;
    private Set<String> namespaces;

    public BuildConfigClusterInformer(String[] namespaces) {
        this.namespaces = new HashSet<String>(Arrays.asList(namespaces));
    }

    public int getListIntervalInSeconds() {
        return 1000 * GlobalPluginConfiguration.get().getBuildConfigListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting BuildConfig informer for " + String.valueOf(this.namespaces) + "!!");
        LOGGER.debug("listing BuildConfig resources");
        SharedInformerFactory factory = OpenShiftUtils.getInformerFactory();
        this.informer = factory.sharedIndexInformerFor(BuildConfig.class, (long)this.getListIntervalInSeconds());
        this.informer.addEventHandler((ResourceEventHandler)this);
        factory.startAllRegisteredInformers();
        BuildConfigManager.reconcileJobsAndBuildConfigs();
        BuildManager.flushBuildsWithNoBCList();
        LOGGER.info("BuildConfig informer started for namespace: " + String.valueOf(this.namespaces));
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer " + String.valueOf(this.namespaces) + "!!");
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(BuildConfig obj) {
        ObjectMeta metadata;
        String namespace;
        LOGGER.debug("BuildConfig informer  received add event for: " + String.valueOf(obj));
        if (obj != null && this.namespaces.contains(namespace = (metadata = obj.getMetadata()).getNamespace())) {
            String name = metadata.getName();
            LOGGER.info("BuildConfig informer received add event for: " + name);
            try {
                BuildConfigManager.upsertJob(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onUpdate(BuildConfig oldObj, BuildConfig newObj) {
        ObjectMeta metadata;
        String namespace;
        LOGGER.debug("BuildConfig informer received update event for: " + String.valueOf(oldObj) + " to: " + String.valueOf(newObj));
        if (newObj != null && this.namespaces.contains(namespace = (metadata = oldObj.getMetadata()).getNamespace())) {
            String oldRv = oldObj.getMetadata().getResourceVersion();
            String newRv = newObj.getMetadata().getResourceVersion();
            LOGGER.info("BuildConfig informer received update event for: " + oldRv + " to: " + newRv);
            try {
                BuildConfigManager.modifyEventToJenkinsJob(newObj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onDelete(BuildConfig obj, boolean deletedFinalStateUnknown) {
        ObjectMeta metadata;
        String namespace;
        LOGGER.info("BuildConfig informer received delete event for: " + String.valueOf(obj));
        if (obj != null && this.namespaces.contains(namespace = (metadata = obj.getMetadata()).getNamespace())) {
            try {
                BuildConfigManager.deleteEventToJenkinsJob(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

