/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecretManager {
    private static final Logger logger = Logger.getLogger(SecretManager.class.getName());
    private static final ConcurrentHashMap<String, String> trackedSecrets = new ConcurrentHashMap();

    public static void insertOrUpdateCredentialFromSecret(Secret secret) {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            logger.info("Upserting Secret with Uid " + metadata.getUid() + " with Name " + metadata.getName());
            if (SecretManager.validSecret(secret)) {
                try {
                    CredentialsUtils.upsertCredential(secret);
                    trackedSecrets.put(metadata.getUid(), metadata.getResourceVersion());
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Credential has not been saved: " + String.valueOf(e), e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static void onInitialSecrets(SecretList secrets) {
        if (secrets == null) {
            return;
        }
        List items = secrets.getItems();
        if (items != null) {
            for (Secret secret : items) {
                try {
                    if (!SecretManager.validSecret(secret) || !SecretManager.shouldProcessSecret(secret)) continue;
                    SecretManager.insertOrUpdateCredentialFromSecret(secret);
                    trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to update job", e);
                }
            }
        }
    }

    protected static void updateCredential(Secret secret) {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            logger.info("Modifying Secret with Uid " + metadata.getUid() + " with Name " + metadata.getName());
            if (SecretManager.validSecret(secret) && SecretManager.shouldProcessSecret(secret)) {
                try {
                    CredentialsUtils.upsertCredential(secret);
                    trackedSecrets.put(metadata.getUid(), metadata.getResourceVersion());
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Secret has not been saved: " + String.valueOf(e), e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected static boolean validSecret(Secret secret) {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            logger.info("Validating Secret with Uid " + metadata.getUid() + " with Name " + name);
            return name != null && !name.isEmpty() && namespace != null && !namespace.isEmpty();
        }
        return false;
    }

    protected static boolean shouldProcessSecret(Secret secret) {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            String uid = metadata.getUid();
            String rv = metadata.getResourceVersion();
            String oldResourceVersion = trackedSecrets.get(uid);
            if (oldResourceVersion == null || !oldResourceVersion.equals(rv)) {
                return true;
            }
        }
        return false;
    }

    static void deleteCredential(Secret secret) throws Exception {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            trackedSecrets.remove(metadata.getUid());
            CredentialsUtils.deleteCredential(secret);
        }
    }
}

