/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.Resyncable;
import io.fabric8.jenkins.openshiftsync.SecretManager;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretInformer
implements ResourceEventHandler<Secret>,
Lifecyclable,
Resyncable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private static final ConcurrentHashMap<String, String> trackedSecrets = new ConcurrentHashMap();
    private String namespace;
    private SharedIndexInformer<Secret> informer;

    public SecretInformer(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public long getResyncPeriodMilliseconds() {
        return 1000 * GlobalPluginConfiguration.get().getSecretListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting Secret informer " + this.namespace + "!!");
        OpenShiftClient client = OpenShiftUtils.getOpenShiftClient();
        Map<String, String> labels = Collections.singletonMap("credential.sync.jenkins.openshift.io", "true");
        this.informer = ((FilterWatchListDeletable)((NonNamespaceOperation)client.secrets().inNamespace(this.namespace)).withLabels(labels)).inform();
        this.informer.addEventHandler((ResourceEventHandler)this);
        client.informers().startAllRegisteredInformers();
        LOGGER.info("Secret informer started for namespace: " + this.namespace);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer " + this.namespace + "!!");
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(Secret obj) {
        LOGGER.debug("Secret informer received add event for: " + String.valueOf(obj));
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String name = metadata.getName();
            LOGGER.info("Secret informer received add event for: " + name);
            SecretManager.insertOrUpdateCredentialFromSecret(obj);
        }
    }

    public void onUpdate(Secret oldObj, Secret newObj) {
        LOGGER.debug("Secret informer received update event for: " + String.valueOf(oldObj) + " to: " + String.valueOf(newObj));
        if (oldObj != null) {
            String name = oldObj.getMetadata().getName();
            LOGGER.info("Secret informer received update event for: {}", (Object)name);
            SecretManager.updateCredential(newObj);
        }
    }

    public void onDelete(Secret obj, boolean deletedFinalStateUnknown) {
        LOGGER.debug("Secret informer received delete event for: {}", (Object)obj);
        if (obj != null) {
            String name = obj.getMetadata().getName();
            LOGGER.info("Secret informer received delete event for: {}", (Object)name);
            CredentialsUtils.deleteCredential(obj);
        }
    }

    private void onInit(List<Secret> list) {
        for (Secret secret : list) {
            try {
                if (!SecretManager.validSecret(secret) || !SecretManager.shouldProcessSecret(secret)) continue;
                SecretManager.insertOrUpdateCredentialFromSecret(secret);
                trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
            }
            catch (Exception e) {
                LOGGER.error("Failed to update secred", (Throwable)e);
            }
        }
    }
}

