/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.Constants;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.PodTemplateUtils;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageStreamInformer
implements ResourceEventHandler<ImageStream>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private SharedIndexInformer<ImageStream> informer;
    private String namespace;

    public ImageStreamInformer(String namespace) {
        this.namespace = namespace;
    }

    public int getResyncPeriodMilliseconds() {
        return 1000 * GlobalPluginConfiguration.get().getImageStreamListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting ImageStream informer " + this.namespace + "!!");
        OpenShiftClient client = OpenShiftUtils.getOpenShiftClient();
        this.informer = ((FilterWatchListDeletable)((NonNamespaceOperation)client.imageStreams().inNamespace(this.namespace)).withLabelIn("role", Constants.imageStreamAgentLabelValues())).inform();
        this.informer.addEventHandler((ResourceEventHandler)this);
        client.informers().startAllRegisteredInformers();
        LOGGER.info("ImageStream informer started for namespace: " + this.namespace);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping ImageStream informer for namespace: " + this.namespace + "!!");
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(ImageStream obj) {
        LOGGER.debug("ImageStream informer received add event for: " + String.valueOf(obj));
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String name = metadata.getName();
            String uid = metadata.getUid();
            LOGGER.info("ImageStream informer received add event for: " + name);
            List<PodTemplate> slaves = PodTemplateUtils.getPodTemplatesListFromImageStreams(obj);
            PodTemplateUtils.addAgents(slaves, "ImageStream", uid, name, this.namespace);
        }
    }

    public void onUpdate(ImageStream oldObj, ImageStream newObj) {
        LOGGER.info("ImageStream informer received update event for: " + String.valueOf(oldObj) + " to: " + String.valueOf(newObj));
        if (newObj != null) {
            List<PodTemplate> slaves = PodTemplateUtils.getPodTemplatesListFromImageStreams(newObj);
            ObjectMeta metadata = newObj.getMetadata();
            String uid = metadata.getUid();
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            PodTemplateUtils.updateAgents(slaves, "ImageStream", uid, name, namespace);
        }
    }

    public void onDelete(ImageStream obj, boolean deletedFinalStateUnknown) {
        LOGGER.info("ImageStream informer received delete event for: " + String.valueOf(obj));
        if (obj != null) {
            List<PodTemplate> slaves = PodTemplateUtils.getPodTemplatesListFromImageStreams(obj);
            ObjectMeta metadata = obj.getMetadata();
            String uid = metadata.getUid();
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            PodTemplateUtils.deleteAgents(slaves, "ImageStream", uid, name, namespace);
        }
    }

    private void onInit(List<ImageStream> list) {
        for (ImageStream imageStream : list) {
            try {
                List<PodTemplate> agents = PodTemplateUtils.getPodTemplatesListFromImageStreams(imageStream);
                for (PodTemplate podTemplate : agents) {
                    if (PodTemplateUtils.hasPodTemplate(podTemplate)) continue;
                    PodTemplateUtils.addPodTemplate(podTemplate);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to update job", (Throwable)e);
            }
        }
    }
}

