/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import hudson.init.InitMilestone;
import hudson.triggers.SafeTimerTask;
import io.fabric8.jenkins.openshiftsync.BuildClusterInformer;
import io.fabric8.jenkins.openshiftsync.BuildConfigClusterInformer;
import io.fabric8.jenkins.openshiftsync.BuildConfigInformer;
import io.fabric8.jenkins.openshiftsync.BuildInformer;
import io.fabric8.jenkins.openshiftsync.ConfigMapClusterInformer;
import io.fabric8.jenkins.openshiftsync.ConfigMapInformer;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.ImageStreamClusterInformer;
import io.fabric8.jenkins.openshiftsync.ImageStreamInformer;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.SecretClusterInformer;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class GlobalPluginConfigurationTimerTask
extends SafeTimerTask {
    private static final Logger logger = Logger.getLogger(GlobalPluginConfigurationTimerTask.class.getName());
    private String[] namespaces;
    private static final List<Lifecyclable> informers = new ArrayList<Lifecyclable>();

    public GlobalPluginConfigurationTimerTask(String[] namespaces) {
        this.namespaces = namespaces;
    }

    protected void doRun() throws Exception {
        logger.info("Confirming Jenkins is started");
        this.waitForJenkinsStartup();
        this.stop();
        this.start();
    }

    private void start() {
        if (GlobalPluginConfiguration.get().isUseClusterMode()) {
            this.startClusterInformers();
            logger.info("All the cluster informers have been registered!! ... starting all registered informers");
        } else {
            this.startNamespaceInformers();
            logger.info("All the namespaced informers have been registered!! ... starting all registered informers");
        }
        OpenShiftUtils.getInformerFactory().startAllRegisteredInformers();
        logger.info("All registered informers have been started");
    }

    private void waitForJenkinsStartup() {
        while (true) {
            Jenkins instance = Jenkins.getActiveInstance();
            InitMilestone initLevel = instance.getInitLevel();
            logger.fine("Jenkins init level: " + String.valueOf(initLevel));
            if (initLevel == InitMilestone.COMPLETED) break;
            logger.info("Jenkins not ready...");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while sleeping");
            }
        }
    }

    private void startNamespaceInformers() {
        for (String namespace : this.namespaces) {
            GlobalPluginConfiguration configuration = GlobalPluginConfiguration.get();
            if (configuration.isSyncBuildConfigsAndBuilds()) {
                BuildConfigInformer buildConfigInformer = new BuildConfigInformer(namespace);
                informers.add(buildConfigInformer);
                buildConfigInformer.start();
                BuildInformer buildInformer = new BuildInformer(namespace);
                buildInformer.start();
                informers.add(buildInformer);
            }
            if (configuration.isSyncConfigMaps()) {
                ConfigMapInformer configMapInformer = new ConfigMapInformer(namespace);
                configMapInformer.start();
                informers.add(configMapInformer);
            }
            if (configuration.isSyncImageStreams()) {
                ImageStreamInformer imageStreamInformer = new ImageStreamInformer(namespace);
                imageStreamInformer.start();
                informers.add(imageStreamInformer);
            }
            if (!configuration.isSyncSecrets()) continue;
            SecretInformer secretInformer = new SecretInformer(namespace);
            secretInformer.start();
            informers.add(secretInformer);
        }
    }

    private void startClusterInformers() {
        logger.info("Initializing cluster informers ...");
        GlobalPluginConfiguration configuration = GlobalPluginConfiguration.get();
        if (configuration.isSyncBuildConfigsAndBuilds()) {
            BuildConfigClusterInformer buildConfigInformer = new BuildConfigClusterInformer(this.namespaces);
            informers.add(buildConfigInformer);
            buildConfigInformer.start();
            BuildClusterInformer buildInformer = new BuildClusterInformer(this.namespaces);
            informers.add(buildInformer);
            buildInformer.start();
        }
        if (configuration.isSyncConfigMaps()) {
            ConfigMapClusterInformer configMapInformer = new ConfigMapClusterInformer(this.namespaces);
            informers.add(configMapInformer);
            configMapInformer.start();
        }
        if (configuration.isSyncImageStreams()) {
            ImageStreamClusterInformer imageStreamInformer = new ImageStreamClusterInformer(this.namespaces);
            informers.add(imageStreamInformer);
            imageStreamInformer.start();
        }
        if (configuration.isSyncSecrets()) {
            SecretClusterInformer secretInformer = new SecretClusterInformer(this.namespaces);
            informers.add(secretInformer);
            secretInformer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.info("Stopping all informers ...");
        GlobalPluginConfigurationTimerTask globalPluginConfigurationTimerTask = this;
        synchronized (globalPluginConfigurationTimerTask) {
            for (Lifecyclable informer : informers) {
                logger.info("Stopping informer: " + String.valueOf(informer));
                informer.stop();
                logger.info("Stopped informer: " + String.valueOf(informer));
            }
            informers.clear();
            logger.info("Stopped all informers");
        }
    }
}

