/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfigurationTimerTask;
import io.fabric8.jenkins.openshiftsync.OpenShiftToken;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
public class GlobalPluginConfiguration
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(GlobalPluginConfiguration.class.getName());
    private boolean enabled = true;
    private boolean foldersEnabled = true;
    private boolean useClusterMode = false;
    private boolean syncConfigMaps = true;
    private boolean syncSecrets = true;
    private boolean syncImageStreams = true;
    private boolean syncBuildConfigsAndBuilds = true;
    private String server;
    private String credentialsId = "";
    private int maxConnections = 100;
    private String[] namespaces;
    private String jobNamePattern;
    private String skipOrganizationPrefix;
    private String skipBranchSuffix;
    private int buildListInterval = 300;
    private int buildConfigListInterval = 300;
    private int secretListInterval = 300;
    private int configMapListInterval = 300;
    private int imageStreamListInterval = 300;
    private static GlobalPluginConfigurationTimerTask TASK;
    private static ScheduledFuture<?> FUTURE;

    @DataBoundConstructor
    public GlobalPluginConfiguration(boolean enable, String server, String namespace, boolean foldersEnabled, String credentialsId, String jobNamePattern, String skipOrganizationPrefix, String skipBranchSuffix, int buildListInterval, int buildConfigListInterval, int configMapListInterval, int secretListInterval, int imageStreamListInterval, boolean useClusterMode, boolean syncConfigMaps, boolean syncSecrets, boolean syncImageStreams, boolean syncBuildsConfigAndBuilds, int maxConnections) {
        this.enabled = enable;
        this.server = server;
        this.namespaces = StringUtils.isBlank((String)namespace) ? null : namespace.split(" ");
        this.foldersEnabled = foldersEnabled;
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
        this.jobNamePattern = jobNamePattern;
        this.skipOrganizationPrefix = skipOrganizationPrefix;
        this.skipBranchSuffix = skipBranchSuffix;
        this.buildListInterval = buildListInterval;
        this.buildConfigListInterval = buildConfigListInterval;
        this.configMapListInterval = configMapListInterval;
        this.secretListInterval = secretListInterval;
        this.imageStreamListInterval = imageStreamListInterval;
        this.useClusterMode = useClusterMode;
        this.syncConfigMaps = syncConfigMaps;
        this.syncSecrets = syncSecrets;
        this.syncImageStreams = syncImageStreams;
        this.syncBuildConfigsAndBuilds = syncBuildsConfigAndBuilds;
        this.maxConnections = maxConnections;
        this.configChange();
    }

    public GlobalPluginConfiguration() {
        this.load();
        this.configChange();
    }

    public static GlobalPluginConfiguration get() {
        return (GlobalPluginConfiguration)((Object)GlobalConfiguration.all().get(GlobalPluginConfiguration.class));
    }

    private synchronized void configChange() {
        logger.info("OpenShift Sync Plugin processing a newly supplied configuration");
        this.stop();
        this.start();
    }

    private void start() {
        if (this.enabled) {
            OpenShiftUtils.initializeOpenShiftClient(this.server, this.maxConnections);
            this.namespaces = OpenShiftUtils.getNamespaceOrUseDefault(this.namespaces, OpenShiftUtils.getOpenShiftClient());
            TASK = new GlobalPluginConfigurationTimerTask(this.namespaces);
            FUTURE = Timer.get().schedule((Runnable)((Object)TASK), 1L, TimeUnit.SECONDS);
        } else {
            logger.info("OpenShift Sync Plugin has been disabled");
        }
    }

    private void stop() {
        boolean interrupted;
        if (FUTURE != null && (interrupted = FUTURE.cancel(true))) {
            logger.info("OpenShift Sync Plugin task has been interrupted");
        }
        if (TASK != null) {
            TASK.stop();
            TASK.cancel();
            TASK = null;
        }
        OpenShiftUtils.shutdownOpenShiftClient();
    }

    @POST
    public FormValidation doValidate(@QueryParameter(value="useClusterMode") boolean useClusterMode, @QueryParameter(value="syncConfigMaps") boolean syncConfigMaps, @QueryParameter(value="syncSecrets") boolean syncSecrets, @QueryParameter(value="syncImageStreams") boolean syncImageStreams, @QueryParameter(value="syncBuildConfigsAndBuilds") boolean syncBuildConfigsAndBuilds, @QueryParameter(value="maxConnections") int maxConnections, @QueryParameter(value="namespace") String namespace, @AncestorInPath Job job) throws IOException, ServletException {
        if (useClusterMode) {
            try {
                int secrets = ((SecretList)((AnyNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().secrets().inAnyNamespace()).list()).getItems().size();
                logger.info("Cluster secrets: " + secrets);
            }
            catch (Exception e) {
                StringBuilder message = new StringBuilder();
                message.append("The ServiceAccount used by Jenkins does not have cluster wide watch permissions.\n");
                message.append("To use cluster mode, you need to run the following commands an restart Jenkins: \n\n");
                message.append("oc create clusterrole jenkins-watcher --verb=get,list,watch \\\n");
                message.append("    --resource=configmaps,builds,buildconfigs,imagestreams,secrets\n\n");
                message.append("oc adm policy add-cluster-role-to-user jenkins-watcher -z jenkins\n");
                logger.severe("Error while trying to query secrets lists: " + String.valueOf(e));
                return FormValidation.error((String)message.toString());
            }
        } else {
            String[] namespaces;
            int namespacesCount;
            StringBuilder message = new StringBuilder();
            if (maxConnections > 200) {
                message.append("Cluster mode is recommended if max connections is greater than 200.");
            }
            int requiredConnectionsCount = 0;
            if (syncBuildConfigsAndBuilds) {
                requiredConnectionsCount += 2;
            }
            if (syncImageStreams) {
                ++requiredConnectionsCount;
            }
            if (syncSecrets) {
                ++requiredConnectionsCount;
            }
            if (syncConfigMaps) {
                ++requiredConnectionsCount;
            }
            if (maxConnections < (requiredConnectionsCount = (namespacesCount = (namespaces = StringUtils.isBlank((String)namespace) ? new String[]{} : namespace.split(" ")).length) * requiredConnectionsCount)) {
                message.append(String.format("Watching %s namespaces with your configuration requires %s connections.", namespacesCount, requiredConnectionsCount));
            }
            if (message.length() > 0) {
                return FormValidation.warning((String)message.toString());
            }
        }
        return FormValidation.ok((String)"Success");
    }

    public String getDisplayName() {
        return "OpenShift Jenkins Sync";
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.configChange();
        this.save();
        return true;
    }

    public static ListBoxModel doFillCredentialsIdItems(String credentialsId) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        StandardListBoxModel model = new StandardListBoxModel();
        if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
            return model.includeCurrentValue(credentialsId);
        }
        return model.includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)jenkins, OpenShiftToken.class).includeCurrentValue(credentialsId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getCredentialsId() {
        return this.credentialsId == null ? "" : this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public String getNamespace() {
        return this.namespaces == null ? "" : StringUtils.join((Object[])this.namespaces, (String)" ");
    }

    public void setNamespace(String namespace) {
        this.namespaces = StringUtils.isBlank((String)namespace) ? null : namespace.split(" ");
    }

    public boolean getFoldersEnabled() {
        return this.foldersEnabled;
    }

    public void setFoldersEnabled(boolean foldersEnabled) {
        this.foldersEnabled = foldersEnabled;
    }

    public String getJobNamePattern() {
        return this.jobNamePattern;
    }

    public void setJobNamePattern(String jobNamePattern) {
        this.jobNamePattern = jobNamePattern;
    }

    public String getSkipOrganizationPrefix() {
        return this.skipOrganizationPrefix;
    }

    public void setSkipOrganizationPrefix(String skipOrganizationPrefix) {
        this.skipOrganizationPrefix = skipOrganizationPrefix;
    }

    public String getSkipBranchSuffix() {
        return this.skipBranchSuffix;
    }

    public void setSkipBranchSuffix(String skipBranchSuffix) {
        this.skipBranchSuffix = skipBranchSuffix;
    }

    public int getBuildListInterval() {
        return this.buildListInterval;
    }

    public void setBuildListInterval(int buildListInterval) {
        this.buildListInterval = buildListInterval;
    }

    public int getBuildConfigListInterval() {
        return this.buildConfigListInterval;
    }

    public void setBuildConfigListInterval(int buildConfigListInterval) {
        this.buildConfigListInterval = buildConfigListInterval;
    }

    public int getSecretListInterval() {
        return this.secretListInterval;
    }

    public void setSecretListInterval(int secretListInterval) {
        this.secretListInterval = secretListInterval;
    }

    public int getConfigMapListInterval() {
        return this.configMapListInterval;
    }

    public void setConfigMapListInterval(int configMapListInterval) {
        this.configMapListInterval = configMapListInterval;
    }

    public int getImageStreamListInterval() {
        return this.imageStreamListInterval;
    }

    public void setImageStreamListInterval(int imageStreamListInterval) {
        this.imageStreamListInterval = imageStreamListInterval;
    }

    String[] getNamespaces() {
        return this.namespaces;
    }

    void setNamespaces(String[] namespaces) {
        this.namespaces = namespaces;
    }

    public boolean isUseClusterMode() {
        return this.useClusterMode;
    }

    public void setUseClusterMode(boolean useClusterMode) {
        this.useClusterMode = useClusterMode;
    }

    public boolean isSyncConfigMaps() {
        return this.syncConfigMaps;
    }

    public void setSyncConfigMaps(boolean syncConfigMaps) {
        this.syncConfigMaps = syncConfigMaps;
    }

    public boolean isSyncSecrets() {
        return this.syncSecrets;
    }

    public void setSyncSecrets(boolean syncSecrets) {
        this.syncSecrets = syncSecrets;
    }

    public boolean isSyncImageStreams() {
        return this.syncImageStreams;
    }

    public void setSyncImageStreams(boolean syncImageStreams) {
        this.syncImageStreams = syncImageStreams;
    }

    public boolean isSyncBuildConfigsAndBuilds() {
        return this.syncBuildConfigsAndBuilds;
    }

    public void setSyncBuildConfigsAndBuilds(boolean syncBuildConfigsAndBuilds) {
        this.syncBuildConfigsAndBuilds = syncBuildConfigsAndBuilds;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }
}

