/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import io.fabric8.jenkins.openshiftsync.Constants;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.Lifecyclable;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.PodTemplateUtils;
import io.fabric8.jenkins.openshiftsync.SecretInformer;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapClusterInformer
implements ResourceEventHandler<ConfigMap>,
Lifecyclable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SecretInformer.class.getName());
    private SharedIndexInformer<ConfigMap> informer;
    private Set<String> namespaces;

    public ConfigMapClusterInformer(String[] namespaces) {
        this.namespaces = new HashSet<String>(Arrays.asList(namespaces));
    }

    public int getListIntervalInSeconds() {
        return 1000 * GlobalPluginConfiguration.get().getConfigMapListInterval();
    }

    @Override
    public void start() {
        LOGGER.info("Starting ConfigMaps informer for namespaces: " + String.valueOf(this.namespaces) + "!!");
        OpenShiftClient client = OpenShiftUtils.getOpenShiftClient();
        this.informer = ((FilterWatchListDeletable)client.configMaps().withLabelIn("role", Constants.imageStreamAgentLabelValues())).inform();
        this.informer.addEventHandler((ResourceEventHandler)this);
        client.informers().startAllRegisteredInformers();
        LOGGER.info("ConfigMap informer started for namespaces: " + String.valueOf(this.namespaces));
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping informer " + String.valueOf(this.namespaces) + "!!");
        if (this.informer != null) {
            this.informer.stop();
        }
    }

    public void onAdd(ConfigMap obj) {
        LOGGER.debug("ConfigMap informer received add event for: " + String.valueOf(obj));
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String namespace = metadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                String name = metadata.getName();
                LOGGER.info("ConfigMap informer received add event for: " + name);
                List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(obj);
                String uid = metadata.getUid();
                PodTemplateUtils.addAgents(podTemplates, "ConfigMap", uid, name, namespace);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    public void onUpdate(ConfigMap oldObj, ConfigMap newObj) {
        LOGGER.debug("ConfigMap informer  received update event for: " + String.valueOf(oldObj) + " to: " + String.valueOf(newObj));
        if (oldObj != null) {
            ObjectMeta oldMetadata = oldObj.getMetadata();
            String namespace = oldMetadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                String oldRv = oldMetadata.getResourceVersion();
                ObjectMeta newMetadata = newObj.getMetadata();
                String newResourceVersion = newMetadata != null ? newMetadata.getResourceVersion() : null;
                LOGGER.info("Update event received resource versions: " + oldRv + " to: " + newResourceVersion);
                List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(newObj);
                ObjectMeta metadata = newMetadata;
                if (metadata != null) {
                    String uid = metadata.getUid();
                    String name = metadata.getName();
                    LOGGER.info("ConfigMap informer received update event for: {}", (Object)name);
                    PodTemplateUtils.updateAgents(podTemplates, "ConfigMap", uid, name, namespace);
                }
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    public void onDelete(ConfigMap obj, boolean deletedFinalStateUnknown) {
        LOGGER.debug("ConfigMap informer received delete event for: " + String.valueOf(obj));
        if (obj != null) {
            ObjectMeta metadata = obj.getMetadata();
            String namespace = metadata.getNamespace();
            if (this.namespaces.contains(namespace)) {
                List<PodTemplate> podTemplates = PodTemplateUtils.podTemplatesFromConfigMap(obj);
                String uid = metadata.getUid();
                String name = metadata.getName();
                PodTemplateUtils.deleteAgents(podTemplates, "ConfigMap", uid, name, namespace);
            } else {
                LOGGER.debug("Received event for a namespace we are not watching: {} ... ignoring", (Object)namespace);
            }
        }
    }

    private void onInit(List<ConfigMap> list) {
        if (list != null) {
            for (ConfigMap configMap : list) {
                PodTemplateUtils.addPodTemplateFromConfigMap(configMap);
            }
        }
    }

    private void waitInformerSync(SharedIndexInformer<ConfigMap> informer) {
        while (!informer.hasSynced()) {
            LOGGER.info("Waiting informer to sync for " + String.valueOf(this.namespaces));
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                LOGGER.info("Interrupted waiting thread: " + String.valueOf(e));
            }
        }
    }
}

