/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import hudson.model.Item;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.SCM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.lang.StringUtils;

final class BranchBuildStrategyHelper {
    private static final Logger LOGGER = Logger.getLogger(BranchBuildStrategyHelper.class.getName());
    private static final int HASH_LENGTH = 40;

    private BranchBuildStrategyHelper() {
    }

    static SCMFileSystem buildSCMFileSystem(SCMSource source, SCMHead head, SCMRevision currRevision, SCM scm, SCMSourceOwner owner) throws IOException, InterruptedException {
        GitSCMFileSystem.BuilderImpl builder = new GitSCMFileSystem.BuilderImpl();
        if (currRevision != null && !(currRevision instanceof AbstractGitSCMSource.SCMRevisionImpl)) {
            return builder.build(source, head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head, currRevision.toString().substring(0, 40)));
        }
        return builder.build((Item)owner, scm, currRevision);
    }

    static List<GitChangeSet> getGitChangeSetList(SCMFileSystem fileSystem, SCMHead head, SCMRevision revision) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (revision != null && !(revision instanceof AbstractGitSCMSource.SCMRevisionImpl)) {
            fileSystem.changesSince((SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head, revision.toString().substring(0, 40)), (OutputStream)out);
        } else {
            fileSystem.changesSince(revision, (OutputStream)out);
        }
        GitChangeLogParser parser = new GitChangeLogParser(null, false);
        return parser.parse((InputStream)new ByteArrayInputStream(out.toByteArray()));
    }

    static Set<String> getPatternsFromFile(SCMFileSystem fileSystem, String filePath) {
        try {
            LOGGER.info(() -> String.format("Looking for file: %s", filePath));
            SCMFile ignorefile = fileSystem.getRoot().child(filePath);
            if (!ignorefile.exists() || !ignorefile.isFile()) {
                LOGGER.severe(() -> String.format("File: %s not found", filePath));
                return Collections.emptySet();
            }
            return BranchBuildStrategyHelper.toPatterns(ignorefile.contentAsString());
        }
        catch (Exception e) {
            LOGGER.severe("Unexpected exception: " + String.valueOf(e));
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return Collections.emptySet();
        }
    }

    static Set<String> toPatterns(String value) {
        if (StringUtils.isBlank((String)value)) {
            return Collections.emptySet();
        }
        return Arrays.stream(value.split("\n")).filter(p -> !p.startsWith("#")).filter(StringUtils::isNotBlank).map(row -> {
            if (row.startsWith("/")) {
                return row.substring(1);
            }
            return row;
        }).map(String::trim).collect(Collectors.toSet());
    }
}

