/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.igalg.jenkins.plugins.multibranch.buildstrategy.BranchBuildStrategyHelper;
import com.igalg.jenkins.plugins.multibranch.buildstrategy.ExcludeRegionBranchBuildStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Set;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.scm.api.SCMFileSystem;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExcludeRegionByFileBranchBuildStrategy
extends ExcludeRegionBranchBuildStrategy {
    private final String excludeFilePath;

    @DataBoundConstructor
    public ExcludeRegionByFileBranchBuildStrategy(String excludeFilePath) {
        this.excludeFilePath = StringUtils.isBlank((String)excludeFilePath) ? ".jenkinsExcludeFile" : excludeFilePath;
    }

    public String getExcludeFilePath() {
        return this.excludeFilePath;
    }

    @Override
    Set<String> getPatterns(SCMFileSystem fileSystem) {
        return BranchBuildStrategyHelper.getPatternsFromFile(fileSystem, this.excludeFilePath);
    }

    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Cancel build by excluded regions strategy defined in file";
        }
    }
}

