/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoCovParser
extends CoverageParser {
    private static final long serialVersionUID = -4511292826873362408L;
    private static final PathUtil PATH_UTIL = new PathUtil();
    private static final Pattern PATH_SEPARATOR = Pattern.compile("/");
    private static final Pattern GO_MOD_MODULE_PATTERN = Pattern.compile("^\\s*module\\s+([^\\s]+)", 8);
    private static final Pattern LINE_PATTERN = Pattern.compile("(?<fullPath>[^:]+):(?<lineStart>\\d+)\\.(?<columnStart>\\d+),(?<lineEnd>\\d+)\\.(?<columnEnd>\\d+)\\s+(?<statements>\\d+)\\s+(?<executions>\\d+)");
    private transient ModuleRegistry moduleRegistry;

    public GoCovParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public GoCovParser(CoverageParser.ProcessingMode processingMode) {
        this(processingMode, new ModuleRegistry());
    }

    public GoCovParser(CoverageParser.ProcessingMode processingMode, ModuleRegistry moduleRegistry) {
        super(processingMode);
        this.moduleRegistry = moduleRegistry;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.moduleRegistry = new ModuleRegistry();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ModuleNode parseReport(Reader reader, String reportFile, FilteredLog log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String determineContainerName(String fullPath) {
        String normalizedPath = fullPath.replace('\\', '/');
        List<String> parts = Arrays.stream(PATH_SEPARATOR.split(normalizedPath)).toList();
        if (parts.isEmpty()) {
            return "";
        }
        if (parts.size() >= 3 && parts.get(0).contains(".")) {
            return parts.get(0) + "/" + parts.get(1);
        }
        return parts.get(0);
    }

    private void processLine(Matcher matcher, Set<ModuleNode> modules, TreeStringBuilder builder, FileDataCollector fileData) {
        String fullPath = matcher.group("fullPath");
        PathParts pathParts = this.parseGoPath(fullPath);
        String moduleName = pathParts.moduleName;
        ModuleNode module = this.findOrCreateModule(modules, moduleName);
        if (module == null) {
            module = new ModuleNode(moduleName);
            modules.add(module);
        }
        PackageNode packageNode = module.findOrCreatePackageNode(pathParts.packagePath);
        FileNode fileNode = packageNode.findOrCreateFileNode(pathParts.fileName, builder.intern(PATH_UTIL.getRelativePath(Path.of(pathParts.relativePath, new String[0]))));
        fileData.addFile(fileNode);
        this.recordCoverage(matcher, fileNode, fileData);
    }

    @CheckForNull
    private ModuleNode findOrCreateModule(Set<ModuleNode> modules, String moduleName) {
        return modules.stream().filter(m -> m.getName().equals(moduleName)).findFirst().orElse(null);
    }

    private void recordCoverage(Matcher matcher, FileNode fileNode, FileDataCollector fileData) {
        int instructions = this.asInt(matcher, "statements");
        LineRange range = new LineRange(this.asInt(matcher, "lineStart"), this.asInt(matcher, "lineEnd"));
        int executions = this.asInt(matcher, "executions");
        if (executions > 0) {
            fileData.addCovered(fileNode.getId(), range, instructions);
        } else {
            fileData.addMissed(fileNode.getId(), range, instructions);
        }
    }

    private PathParts parseGoPath(String fullPath) {
        String normalizedPath = fullPath.replace('\\', '/');
        ModuleInfo moduleMatch = this.moduleRegistry.findModuleForPath(normalizedPath);
        if (moduleMatch != null) {
            return this.createPathPartsFromModule(normalizedPath, moduleMatch);
        }
        List<String> parts = Arrays.stream(PATH_SEPARATOR.split(normalizedPath)).toList();
        if (parts.isEmpty()) {
            return new PathParts("", "", "", "");
        }
        String fileName = parts.get(parts.size() - 1);
        PathInfo pathInfo = this.guessPathStructure(parts);
        String packagePath = this.buildPackagePath(parts, pathInfo.packageStartIndex());
        String relativePath = this.buildRelativePath(parts, pathInfo.packageStartIndex());
        return new PathParts(pathInfo.moduleName(), packagePath, fileName, relativePath);
    }

    private PathParts createPathPartsFromModule(String fullPath, ModuleInfo moduleInfo) {
        String fileName;
        String packagePath;
        String relativePath;
        String moduleName = moduleInfo.name();
        if (fullPath.startsWith(moduleInfo.prefix())) {
            relativePath = fullPath.substring(moduleInfo.prefix().length());
            int lastSlash = relativePath.lastIndexOf(47);
            if (lastSlash >= 0) {
                packagePath = relativePath.substring(0, lastSlash);
                fileName = relativePath.substring(lastSlash + 1);
            } else {
                packagePath = "";
                fileName = relativePath;
            }
        } else if (fullPath.equals(moduleName)) {
            relativePath = "";
            packagePath = "";
            fileName = "";
        } else {
            relativePath = fullPath;
            packagePath = "";
            int lastSlash = fullPath.lastIndexOf(47);
            fileName = lastSlash >= 0 ? fullPath.substring(lastSlash + 1) : fullPath;
        }
        return new PathParts(moduleName, packagePath, fileName, relativePath);
    }

    private PathInfo guessPathStructure(List<String> parts) {
        if (parts.size() == 1) {
            return new PathInfo("", 0);
        }
        if (parts.size() == 2 || parts.size() == 3) {
            return new PathInfo(parts.get(0), 1);
        }
        return parts.get(0).contains(".") ? new PathInfo(parts.get(2), 3) : new PathInfo(parts.get(1), 2);
    }

    private String buildPackagePath(List<String> parts, int startIndex) {
        return this.buildPath(parts, startIndex, parts.size() - 1);
    }

    private String buildRelativePath(List<String> parts, int startIndex) {
        return this.buildPath(parts, startIndex, parts.size());
    }

    private String buildPath(List<String> parts, int startIndex, int endIndex) {
        return String.join((CharSequence)"/", parts.subList(startIndex, endIndex));
    }

    private int asInt(Matcher matcher, String group) {
        try {
            return Integer.parseInt(matcher.group(group));
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    public static class ModuleRegistry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<ModuleInfo> modules;

        public ModuleRegistry() {
            this.modules = new ArrayList<ModuleInfo>();
        }

        public ModuleRegistry(Collection<ModuleInfo> modules) {
            this.modules = new ArrayList<ModuleInfo>(modules);
            this.modules.sort((a, b) -> Integer.compare(b.name().length(), a.name().length()));
        }

        public void addModule(String name, String path) {
            this.modules.add(new ModuleInfo(name, path));
            this.modules.sort((a, b) -> Integer.compare(b.name().length(), a.name().length()));
        }

        public void parseAndAddGoMod(String goModContent, String modulePath) {
            Matcher matcher = GO_MOD_MODULE_PATTERN.matcher(goModContent);
            if (matcher.find()) {
                String moduleName = matcher.group(1);
                int commentIndex = moduleName.indexOf("//");
                if (commentIndex >= 0) {
                    moduleName = moduleName.substring(0, commentIndex).trim();
                }
                this.addModule(moduleName, modulePath);
            }
        }

        @CheckForNull
        public ModuleInfo findModuleForPath(String coveragePath) {
            for (ModuleInfo module : this.modules) {
                if (!coveragePath.equals(module.name()) && !coveragePath.startsWith(module.prefix())) continue;
                return module;
            }
            return null;
        }

        public List<ModuleInfo> getModules() {
            return new ArrayList<ModuleInfo>(this.modules);
        }

        public boolean isEmpty() {
            return this.modules.isEmpty();
        }
    }

    private static class FileDataCollector {
        private final Map<String, List<LineRange>> coveredRangesPerFile = new HashMap<String, List<LineRange>>();
        private final Map<String, Integer> coveredInstructionsPerFile = new HashMap<String, Integer>();
        private final Map<String, List<LineRange>> missedRangesPerFile = new HashMap<String, List<LineRange>>();
        private final Map<String, Integer> missedInstructionsPerFile = new HashMap<String, Integer>();
        private final Set<FileNode> files = new HashSet<FileNode>();

        private FileDataCollector() {
        }

        void addFile(FileNode file) {
            this.files.add(file);
        }

        void addCovered(String fileId, LineRange range, int instructions) {
            this.merge(this.coveredRangesPerFile, fileId, range);
            this.coveredInstructionsPerFile.merge(fileId, instructions, Integer::sum);
        }

        void addMissed(String fileId, LineRange range, int instructions) {
            this.merge(this.missedRangesPerFile, fileId, range);
            this.missedInstructionsPerFile.merge(fileId, instructions, Integer::sum);
        }

        void buildCoverages() {
            Coverage.CoverageBuilder lineBuilder = new Coverage.CoverageBuilder().withMetric(Metric.LINE);
            Coverage.CoverageBuilder instructionBuilder = new Coverage.CoverageBuilder().withMetric(Metric.INSTRUCTION);
            for (FileNode file : this.files) {
                Integer coveredInstructions = this.coveredInstructionsPerFile.getOrDefault(file.getId(), 0);
                Integer missedInstructions = this.missedInstructionsPerFile.getOrDefault(file.getId(), 0);
                file.addValue(instructionBuilder.withCovered(coveredInstructions).withMissed(missedInstructions).build());
                List<Integer> coveredLines = this.getLines(this.coveredRangesPerFile, file);
                ArrayList<Integer> missedLines = new ArrayList<Integer>(this.getLines(this.missedRangesPerFile, file));
                missedLines.removeAll(coveredLines);
                file.addValue(lineBuilder.withCovered(coveredLines.size()).withMissed(missedLines.size()).build());
                coveredLines.forEach(line -> file.addCounters((int)line, 1, 0));
                missedLines.forEach(line -> file.addCounters((int)line, 0, 1));
            }
        }

        private List<Integer> getLines(Map<String, List<LineRange>> rangesPerFile, FileNode file) {
            return rangesPerFile.getOrDefault(file.getId(), List.of()).stream().map(LineRange::getLines).flatMap(Collection::stream).toList();
        }

        private void merge(Map<String, List<LineRange>> map, String key, LineRange value) {
            map.merge(key, new ArrayList<LineRange>(List.of(value)), (? super V oldValue, ? super V newValue) -> {
                oldValue.addAll(newValue);
                return oldValue;
            });
        }
    }

    private record PathParts(String moduleName, String packagePath, String fileName, String relativePath) {
    }

    public record ModuleInfo(String name, String path, String prefix) implements Serializable
    {
        private static final long serialVersionUID = 1L;

        public ModuleInfo(String name, String path) {
            this(name, path, name + "/");
        }
    }

    private record PathInfo(String moduleName, int packageStartIndex) {
    }
}

