/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.hm.hafner.util.TreeString;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class Trace32Parser
extends CoverageParser {
    private static final long serialVersionUID = 1L;
    private static final QName LIST_FUNC = new QName("COVerage.EXPORT.ListFunc");
    private static final QName LIST_MODULE = new QName("COVerage.EXPORT.ListModule");
    private static final QName LIST_EXPORT = new QName("List.EXPORT");
    private static final QName MODULE = new QName("module");
    private static final QName FUNCTION = new QName("function");
    private static final QName TREE = new QName("tree");
    private static final QName MIXED = new QName("mixed");
    private static final QName SRCPATH = new QName("srcpath");
    private static final QName METRIC_ATTR = new QName("metric");
    private final HashMap<String, String> filesToProcess = new HashMap();

    public Trace32Parser() {
        super(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public Trace32Parser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        ModuleNode root = new ModuleNode("TRACE32 Coverage");
        try {
            this.parseFile(root, reader);
        }
        catch (XMLStreamException e) {
            throw new CoverageParser.ParsingException(e);
        }
        if (root.isEmpty()) {
            this.handleEmptyResults(fileName, log);
            return new ModuleNode("empty");
        }
        ClassNode rootFiles = root.createClassNode("TRACE32 Files");
        for (Map.Entry<String, String> entry : this.filesToProcess.entrySet()) {
            String fileNodeName;
            String filePath = entry.getValue();
            Path fileNodePath = Paths.get(filePath, new String[0]).getFileName();
            String string = fileNodeName = fileNodePath != null ? fileNodePath.toString() : "missing_file";
            if (rootFiles.hasChild(filePath + fileNodeName)) {
                log.logInfo("[TRACE32] Found duplicate file module: \"%s\", source: \"%s\"", new Object[]{entry.getKey(), filePath});
                continue;
            }
            log.logInfo("[TRACE32] Found file module: \"%s\", source: \"%s\"", new Object[]{entry.getKey(), filePath});
            root.addSource(filePath);
            FileNode fileNode = rootFiles.createFileNode(fileNodeName, TreeString.valueOf((String)filePath));
            Node moduleNode = this.getNodeTree(root, entry.getKey()).orElse(null);
            if (moduleNode == null) continue;
            ClassNode newNode = root.createClassNode(fileNodeName);
            newNode.addAllChildren(moduleNode.getChildren());
            moduleNode.getValues().forEach(value -> {
                newNode.addValue((Value)value);
                fileNode.addValue((Value)value);
            });
            moduleNode.getMetrics().forEach(metric -> moduleNode.replaceValue(new Coverage.CoverageBuilder((Metric)((Object)metric)).withTotal(0).withCovered(0).build()));
        }
        for (Metric metric2 : rootFiles.getMetrics()) {
            if (metric2 == Metric.FILE) continue;
            rootFiles.addValue(new Coverage.CoverageBuilder(metric2).withTotal(0).withCovered(0).build());
        }
        return root;
    }

    private boolean startElement(XMLEvent event, QName name) {
        return event.isStartElement() && event.asStartElement().getName().equals(name);
    }

    private boolean endElement(XMLEvent event, QName name) {
        return event.isEndElement() && event.asEndElement().getName().equals(name);
    }

    private Optional<Node> getNodeTree(Node root, String treeName) {
        Node lastNode = root;
        for (String name : treeName.split("[\\/\\\\]")) {
            if ((lastNode = (Node)lastNode.findClass(name).orElse(null)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(lastNode);
    }

    private Node makeNodeTree(Node root, String treeName) {
        Node lastNode = root;
        for (String name : treeName.split("[\\/\\\\]")) {
            lastNode = lastNode.findOrCreateClassNode(name);
        }
        return lastNode;
    }

    private void addOrReplaceMetric(Map<Fields, Integer> map, Node node, Metric metric, Fields total, Fields covered) {
        node.replaceValue(new Coverage.CoverageBuilder(metric).withTotal(map.getOrDefault((Object)total, 0)).withCovered(map.getOrDefault((Object)covered, 0)).build());
    }

    private String readMetric(XMLEventReader xml, Node root, String metric, QName element, boolean readFunction) throws XMLStreamException {
        XMLEvent event = xml.nextEvent();
        String treeName = "";
        EnumMap<Fields, Integer> map = new EnumMap<Fields, Integer>(Fields.class);
        while (!this.endElement(event, element)) {
            if (!event.isStartElement()) {
                event = xml.nextEvent();
                continue;
            }
            String data = xml.nextEvent().asCharacters().getData().trim();
            QName tag = event.asStartElement().getName();
            if (tag.equals(TREE)) {
                treeName = data.replace("\\\\", "").replace('\\', File.separatorChar);
            } else if (tag.equals(FUNCTION)) {
                if (!readFunction) break;
                this.readMetric(xml, root, metric, FUNCTION, false);
            } else {
                try {
                    map.put(Fields.fromTag(tag.toString()), Trace32Parser.parseInteger(data));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            event = xml.nextEvent();
        }
        if (treeName.isEmpty()) {
            return treeName;
        }
        Node node = this.makeNodeTree(root, treeName);
        this.addOrReplaceMetric(map, node, "object".equals(metric) ? Metric.OBJECT_CODE : Metric.BYTES, Fields.BYTES, Fields.BYTESOK);
        switch (metric) {
            case "func": {
                this.addOrReplaceMetric(map, node, Metric.FUNCTION, Fields.FUNCTIONS, Fields.FUNCTIONSOK);
                break;
            }
            case "stmt": {
                this.addOrReplaceMetric(map, node, Metric.STATEMENT, Fields.LINES, Fields.LINESOK);
                break;
            }
            case "mcdc": {
                this.addOrReplaceMetric(map, node, Metric.MCDC_PAIR, Fields.LINES, Fields.LINESOK);
                this.addOrReplaceMetric(map, node, Metric.DECISION, Fields.DECISIONS, Fields.DECISIONSOK);
                node.replaceValue(new Coverage.CoverageBuilder(Metric.CONDITION).withTotal(2 * map.getOrDefault((Object)Fields.CONDITIONS, 0)).withCovered(map.getOrDefault((Object)Fields.TRUE, 0) + map.getOrDefault((Object)Fields.FALSE, 0)).build());
                break;
            }
            case "call": {
                this.addOrReplaceMetric(map, node, Metric.FUNCTION_CALL, Fields.CALLS, Fields.CALLSOK);
                this.addOrReplaceMetric(map, node, Metric.FUNCTION, Fields.FUNCTIONS, Fields.FUNCTIONSOK);
                break;
            }
            case "cond": {
                this.addOrReplaceMetric(map, node, Metric.STMT_CC, Fields.LINES, Fields.LINESOK);
                node.replaceValue(new Coverage.CoverageBuilder(Metric.CONDITION).withTotal(2 * map.getOrDefault((Object)Fields.CONDITIONS, 0)).withCovered(map.getOrDefault((Object)Fields.TRUE, 0) + map.getOrDefault((Object)Fields.FALSE, 0)).build());
                break;
            }
            case "dec": {
                this.addOrReplaceMetric(map, node, Metric.STMT_DC, Fields.LINES, Fields.LINESOK);
                node.replaceValue(new Coverage.CoverageBuilder(Metric.DECISION).withTotal(2 * map.getOrDefault((Object)Fields.DECISIONS, 0)).withCovered(map.getOrDefault((Object)Fields.TRUE, 0) + map.getOrDefault((Object)Fields.FALSE, 0)).build());
                break;
            }
            default: {
                int total = 2 * (map.getOrDefault((Object)Fields.OK, 0) + map.getOrDefault((Object)Fields.TAKEN, 0) + map.getOrDefault((Object)Fields.NOTTAKEN, 0) + map.getOrDefault((Object)Fields.NEVER, 0));
                int covered = 2 * map.getOrDefault((Object)Fields.OK, 0) + map.getOrDefault((Object)Fields.TAKEN, 0) + map.getOrDefault((Object)Fields.NOTTAKEN, 0);
                node.replaceValue(new Coverage.CoverageBuilder(Metric.BRANCH).withTotal(total).withCovered(covered).build());
            }
        }
        return treeName;
    }

    private void parseFile(ModuleNode root, Reader reader) throws XMLStreamException {
        XMLEventReader xml = new SecureXmlParserFactory().createXmlEventReader(reader);
        while (xml.hasNext()) {
            XMLEvent event = xml.nextEvent();
            if (this.startElement(event, LIST_MODULE) || this.startElement(event, LIST_FUNC)) {
                String metric = event.asStartElement().getAttributeByName(METRIC_ATTR).getValue();
                event = xml.nextEvent();
                while (!this.endElement(event, LIST_MODULE) && !this.endElement(event, LIST_FUNC)) {
                    if (this.startElement(event, MODULE)) {
                        this.readMetric(xml, root, metric, MODULE, true);
                    }
                    event = xml.nextEvent();
                }
                continue;
            }
            if (!this.startElement(event, LIST_EXPORT)) continue;
            event = xml.nextEvent();
            while (!this.endElement(event, LIST_EXPORT)) {
                if (!this.startElement(event, MIXED)) {
                    event = xml.nextEvent();
                    continue;
                }
                Attribute moduleAttr = event.asStartElement().getAttributeByName(MODULE);
                Attribute pathAttr = event.asStartElement().getAttributeByName(SRCPATH);
                if (moduleAttr == null || pathAttr == null) {
                    event = xml.nextEvent();
                    continue;
                }
                char wrongSeparator = File.separatorChar == '\\' ? (char)'/' : '\\';
                String moduleName = moduleAttr.getValue().replace("\\\\", "").replace(wrongSeparator, File.separatorChar);
                String filePath = pathAttr.getValue().replace(wrongSeparator, File.separatorChar);
                this.filesToProcess.putIfAbsent(moduleName, filePath);
                event = xml.nextEvent();
            }
        }
        xml.close();
    }

    private static enum Fields {
        BYTES,
        BYTESOK,
        CALLS,
        CALLSOK,
        LINES,
        LINESOK,
        FUNCTIONS,
        FUNCTIONSOK,
        DECISIONS,
        DECISIONSOK,
        CONDITIONS,
        TRUE,
        FALSE,
        OK,
        TAKEN,
        NOTTAKEN,
        NEVER;


        static Fields fromTag(String tag) throws IllegalArgumentException {
            return Fields.valueOf(tag.toUpperCase(Locale.getDefault()));
        }
    }
}

