/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import org.apache.commons.lang3.math.Fraction;

public class SafeFraction {
    private final Fraction fraction;

    public SafeFraction(Fraction fraction) {
        this.fraction = fraction;
    }

    public SafeFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new IllegalArgumentException("Totals must be greater than zero.");
        }
        this.fraction = Fraction.getFraction((int)numerator, (int)denominator);
    }

    public Fraction multiplyBy(Fraction multiplier) {
        try {
            return this.fraction.multiplyBy(multiplier);
        }
        catch (ArithmeticException exception) {
            return Fraction.getFraction((double)(this.fraction.doubleValue() * multiplier.doubleValue()));
        }
    }

    public Fraction subtract(Fraction subtrahend) {
        try {
            return this.fraction.subtract(subtrahend);
        }
        catch (ArithmeticException exception) {
            return Fraction.getFraction((double)(this.fraction.doubleValue() - subtrahend.doubleValue()));
        }
    }

    public Fraction subtract(int numerator, int denominator) {
        if (denominator == 0) {
            throw new IllegalArgumentException("Totals must be greater than zero.");
        }
        return this.subtract(Fraction.getFraction((int)numerator, (int)denominator));
    }

    public Fraction add(Fraction summand) {
        try {
            return this.fraction.add(summand);
        }
        catch (ArithmeticException exception) {
            return Fraction.getFraction((double)(this.fraction.doubleValue() + summand.doubleValue()));
        }
    }
}

