/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.coverage.parser.CoberturaParser;
import edu.hm.hafner.util.FilteredLog;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class VectorCastParser
extends CoberturaParser {
    private static final long serialVersionUID = 598117573006409816L;
    private static final Pattern BRANCH_PATTERN = Pattern.compile(".*\\((?<covered>\\d+)/(?<total>\\d+)\\)");
    private static final Coverage DEFAULT_MCDCPAIR_COVERAGE = Coverage.nullObject(Metric.MCDC_PAIR);
    private static final Coverage DEFAULT_FUNCTION_COVERAGE = Coverage.nullObject(Metric.METHOD);
    private static final Coverage DEFAULT_FUNCTIONCALL_COVERAGE = Coverage.nullObject(Metric.FUNCTION_CALL);
    private static final QName CLASS = new QName("class");
    private static final QName METHOD = new QName("method");
    private static final QName LINE = new QName("line");
    private static final QName HITS = new QName("hits");
    private static final QName COMPLEXITY = new QName("complexity");
    private static final QName NUMBER = new QName("number");
    private static final QName MCDCPAIR_COVERAGE = new QName("mcdcpair-coverage");
    private static final QName FUNCTIONCALL_COVERAGE = new QName("functioncall-coverage");
    private static final QName FUNCTION_COVERAGE = new QName("function-coverage");

    public VectorCastParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    private Coverage processClassMethodStart(StartElement nextElement, Coverage functionCoverage) {
        Coverage localFunctionCoverage = functionCoverage;
        if (nextElement.getName().equals(METHOD)) {
            Coverage functionMethodCoverage = this.readFunctionCoverage(nextElement);
            localFunctionCoverage = localFunctionCoverage.add(functionMethodCoverage);
        }
        return localFunctionCoverage;
    }

    protected boolean processStartElement(StartElement nextElement, StartElement element, FileNode fileNode, Map<Metric, Coverage> coverageMap) throws XMLStreamException {
        boolean runReadClassOrMethod = false;
        if (LINE.equals(nextElement.getName())) {
            Coverage currentLineCoverage;
            Coverage lineBranchCoverage;
            Coverage mcdcPairLineCoverage = Coverage.nullObject(Metric.MCDC_PAIR);
            Coverage functionCallLineCoverage = Coverage.nullObject(Metric.FUNCTION_CALL);
            if (this.isBranchCoverage(nextElement)) {
                lineBranchCoverage = this.readBranchCoverage(nextElement);
                currentLineCoverage = this.computeLineCoverage(lineBranchCoverage.getCovered());
                coverageMap.merge(Metric.BRANCH, lineBranchCoverage, Coverage::add);
                if (VectorCastParser.getOptionalValueOf(nextElement, MCDCPAIR_COVERAGE).isPresent()) {
                    mcdcPairLineCoverage = this.readMcdcPairCoverage(nextElement);
                    coverageMap.merge(Metric.MCDC_PAIR, mcdcPairLineCoverage, Coverage::add);
                }
                if (VectorCastParser.getOptionalValueOf(nextElement, FUNCTIONCALL_COVERAGE).isPresent()) {
                    functionCallLineCoverage = this.readFunctionCallCoverage(nextElement);
                    coverageMap.merge(Metric.FUNCTION_CALL, functionCallLineCoverage, Coverage::add);
                }
            } else if (VectorCastParser.getOptionalValueOf(nextElement, FUNCTIONCALL_COVERAGE).isPresent()) {
                functionCallLineCoverage = this.readFunctionCallCoverage(nextElement);
                coverageMap.merge(Metric.FUNCTION_CALL, functionCallLineCoverage, Coverage::add);
                lineHits = VectorCastParser.getIntegerValueOf(nextElement, HITS);
                lineBranchCoverage = currentLineCoverage = this.computeLineCoverage(lineHits);
            } else {
                lineHits = VectorCastParser.getIntegerValueOf(nextElement, HITS);
                lineBranchCoverage = currentLineCoverage = this.computeLineCoverage(lineHits);
            }
            coverageMap.merge(Metric.LINE, currentLineCoverage, Coverage::add);
            if (CLASS.equals(element.getName())) {
                int lineNumber = VectorCastParser.getIntegerValueOf(nextElement, NUMBER);
                fileNode.addCounters(lineNumber, lineBranchCoverage.getCovered(), lineBranchCoverage.getMissed());
                fileNode.addMcdcPairCounters(lineNumber, mcdcPairLineCoverage.getCovered(), mcdcPairLineCoverage.getMissed());
                fileNode.addFunctionCallCounters(lineNumber, functionCallLineCoverage.getCovered(), functionCallLineCoverage.getMissed());
            }
        } else if (this.classOrMethodElement(nextElement)) {
            coverageMap.put(Metric.METHOD, this.processClassMethodStart(nextElement, this.getValueFromMap(coverageMap, Metric.METHOD)));
            runReadClassOrMethod = true;
        }
        return runReadClassOrMethod;
    }

    private Coverage getValueFromMap(Map<Metric, Coverage> coverageMap, Metric metric) {
        return coverageMap.getOrDefault((Object)metric, Coverage.nullObject(metric));
    }

    private boolean classOrMethodElement(StartElement nextElement) {
        return METHOD.equals(nextElement.getName()) || CLASS.equals(nextElement.getName());
    }

    protected void processClassMethodEnd(Node node, Map<Metric, Coverage> coverageMap) {
        node.addValue(this.getValueFromMap(coverageMap, Metric.LINE));
        List.of(Metric.MCDC_PAIR, Metric.FUNCTION_CALL, Metric.BRANCH).forEach(metric -> {
            Coverage coverage = this.getValueFromMap(coverageMap, (Metric)((Object)metric));
            if (coverage.isSet()) {
                node.addValue(coverage);
            }
        });
    }

    @Override
    protected void readClassOrMethod(XMLEventReader reader, FileNode fileNode, Node parentNode, StartElement element, String fileName, FilteredLog log) throws XMLStreamException {
        EnumMap<Metric, Coverage> coverageMap = new EnumMap<Metric, Coverage>(Metric.class);
        coverageMap.put(Metric.LINE, Coverage.nullObject(Metric.LINE));
        coverageMap.put(Metric.BRANCH, Coverage.nullObject(Metric.BRANCH));
        coverageMap.put(Metric.MCDC_PAIR, Coverage.nullObject(Metric.MCDC_PAIR));
        coverageMap.put(Metric.FUNCTION_CALL, Coverage.nullObject(Metric.FUNCTION_CALL));
        coverageMap.put(Metric.METHOD, Coverage.nullObject(Metric.METHOD));
        Node node = this.createNode(parentNode, element, log);
        VectorCastParser.getOptionalValueOf(element, COMPLEXITY).ifPresent(c -> node.addValue(new Value(Metric.CYCLOMATIC_COMPLEXITY, this.readComplexity((String)c))));
        VectorCastParser.getOptionalValueOf(element, FUNCTION_COVERAGE).map(this::fromFunctionCoverage).ifPresent(node::addValue);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (!this.processStartElement(nextElement, element, fileNode, coverageMap)) continue;
                this.readClassOrMethod(reader, fileNode, node, nextElement, fileName, log);
                continue;
            }
            if (!event.isEndElement() || !CLASS.equals((endElement = event.asEndElement()).getName()) && !METHOD.equals(endElement.getName())) continue;
            this.processClassMethodEnd(node, coverageMap);
            return;
        }
        throw VectorCastParser.createEofException(fileName);
    }

    private Coverage readMcdcPairCoverage(StartElement line) {
        return VectorCastParser.getOptionalValueOf(line, MCDCPAIR_COVERAGE).map(this::fromMcdcPairCoverage).orElse(DEFAULT_MCDCPAIR_COVERAGE);
    }

    private Coverage readFunctionCoverage(StartElement line) {
        return VectorCastParser.getOptionalValueOf(line, FUNCTION_COVERAGE).map(this::fromFunctionCoverage).orElse(DEFAULT_FUNCTION_COVERAGE);
    }

    private Coverage readFunctionCallCoverage(StartElement line) {
        return VectorCastParser.getOptionalValueOf(line, FUNCTIONCALL_COVERAGE).map(this::fromFunctionCallCoverage).orElse(DEFAULT_FUNCTIONCALL_COVERAGE);
    }

    private Coverage fromAllCoverages(String covAttrStr, Metric metric) {
        Matcher matcher = BRANCH_PATTERN.matcher(covAttrStr);
        if (matcher.matches()) {
            return new Coverage.CoverageBuilder().withMetric(metric).withCovered(matcher.group("covered")).withTotal(matcher.group("total")).build();
        }
        return Coverage.nullObject(metric);
    }

    private Coverage fromMcdcPairCoverage(String covAttrStr) {
        return this.fromAllCoverages(covAttrStr, Metric.MCDC_PAIR);
    }

    private Coverage fromFunctionCoverage(String covAttrStr) {
        return this.fromAllCoverages(covAttrStr, Metric.METHOD);
    }

    private Coverage fromFunctionCallCoverage(String covAttrStr) {
        return this.fromAllCoverages(covAttrStr, Metric.FUNCTION_CALL);
    }
}

