/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.registry;

import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.parser.CloverParser;
import edu.hm.hafner.coverage.parser.CoberturaParser;
import edu.hm.hafner.coverage.parser.GoCovParser;
import edu.hm.hafner.coverage.parser.JacocoParser;
import edu.hm.hafner.coverage.parser.JunitParser;
import edu.hm.hafner.coverage.parser.LcovParser;
import edu.hm.hafner.coverage.parser.MetricsParser;
import edu.hm.hafner.coverage.parser.NunitParser;
import edu.hm.hafner.coverage.parser.OpenCoverParser;
import edu.hm.hafner.coverage.parser.PitestParser;
import edu.hm.hafner.coverage.parser.VectorCastParser;
import edu.hm.hafner.coverage.parser.XunitParser;
import org.apache.commons.lang3.StringUtils;

public class ParserRegistry {
    public CoverageParser get(String parserName, CoverageParser.ProcessingMode processingMode) {
        try {
            return this.get(CoverageParserType.valueOf(StringUtils.upperCase((String)parserName)), processingMode);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Unknown parser name: " + parserName, exception);
        }
    }

    public CoverageParser get(CoverageParserType parser, CoverageParser.ProcessingMode processingMode) {
        return switch (parser.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new CloverParser(processingMode);
            case 0 -> new CoberturaParser(processingMode);
            case 2 -> new GoCovParser(processingMode);
            case 3 -> new JacocoParser(processingMode);
            case 4 -> new JunitParser(processingMode);
            case 5 -> new LcovParser(processingMode);
            case 6 -> new MetricsParser(processingMode);
            case 7 -> new NunitParser(processingMode);
            case 8 -> new OpenCoverParser(processingMode);
            case 9 -> new PitestParser(processingMode);
            case 11 -> new XunitParser(processingMode);
            case 10 -> new VectorCastParser(processingMode);
        };
    }

    public static enum CoverageParserType {
        COBERTURA,
        CLOVER,
        GO_COV,
        JACOCO,
        JUNIT,
        LCOV,
        METRICS,
        NUNIT,
        OPENCOVER,
        PIT,
        VECTORCAST,
        XUNIT;

    }
}

