/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.hm.hafner.util.TreeString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;

public class Trace32Parser
extends CoverageParser {
    private static final long serialVersionUID = 1L;
    private static final QName TRACE32 = new QName("TRACE32");
    private static final QName COVERAGE = new QName("coverage");
    private static final QName LIST_FUNC = new QName("COVerage.EXPORT.ListFunc");
    private static final QName LIST_MODULE = new QName("COVerage.EXPORT.ListModule");
    private static final QName LIST_EXPORT = new QName("List.EXPORT");
    private static final QName MODULE = new QName("module");
    private static final QName FUNCTION = new QName("function");
    private static final QName MIXED = new QName("mixed");
    private static final QName SRCPATH = new QName("srcpath");
    private static final QName METRIC_ATTR = new QName("metric");
    private final HashMap<String, String> filesToProcess = new HashMap();

    public Trace32Parser() {
        super(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public Trace32Parser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        ModuleNode root = new ModuleNode("Trace32 Coverage");
        log.logInfo("[TRACE32] Parsing files for listing...");
        Path fileParent = Paths.get(fileName, new String[0]).getParent();
        if (fileParent == null) {
            fileParent = Paths.get(".", new String[0]);
        }
        try (Stream<Path> paths = Files.walk(fileParent, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                if (path.toString().endsWith(".xml")) {
                    try {
                        this.parseListing(path.toString(), log);
                    }
                    catch (XMLStreamException xMLStreamException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException e) {
            throw new CoverageParser.ParsingException(e);
        }
        try {
            this.parseFile(root, 46 + File.separatorChar + fileName, Optional.of(reader), log);
        }
        catch (XMLStreamException e) {
            throw new CoverageParser.ParsingException(e);
        }
        if (root.isEmpty()) {
            this.handleEmptyResults(fileName, log);
            return new ModuleNode("empty");
        }
        ClassNode rootFiles = root.createClassNode("Trace32 Coverage Files");
        for (Map.Entry<String, String> entry : this.filesToProcess.entrySet()) {
            String fileNodeName;
            String filePath = entry.getValue();
            Path fileNodePath = Paths.get(filePath, new String[0]).getFileName();
            String string = fileNodeName = fileNodePath != null ? fileNodePath.toString() : "missing_file";
            if (rootFiles.hasChild(filePath + fileNodeName)) {
                log.logInfo("[TRACE32] Found duplicate file: \"%s\", source: \"%s\"", new Object[]{entry.getKey(), filePath});
                continue;
            }
            log.logInfo("[TRACE32] Found file: \"%s\", source: \"%s\"", new Object[]{entry.getKey(), filePath});
            FileNode fileNode = rootFiles.createFileNode(fileNodeName, TreeString.valueOf((String)filePath));
            String moduleName = this.resolveTreeName(entry.getKey());
            Optional<Node> moduleNode = this.getNodeTree(root, moduleName);
            if (!moduleNode.isPresent()) continue;
            for (Value value : moduleNode.get().getValues()) {
                fileNode.addValue(value);
            }
        }
        Set<Metric> fileMetricsBlacklist = Set.of(Metric.FILE, Metric.MODULE, Metric.PACKAGE, Metric.CLASS);
        for (Metric metric : root.getMetrics()) {
            if (fileMetricsBlacklist.contains((Object)metric)) continue;
            rootFiles.addValue(new Coverage.CoverageBuilder(metric).withTotal(0).withCovered(0).build());
        }
        return root;
    }

    private String resolveTreeName(String treeName) {
        for (Map.Entry<String, String> file : this.filesToProcess.entrySet()) {
            String moduleName = file.getKey();
            if (!treeName.startsWith(moduleName)) continue;
            Path fileName = Paths.get(file.getValue(), new String[0]).getFileName();
            Path moduleParent = Paths.get(moduleName, new String[0]).getParent();
            String replaceName = moduleParent != null ? moduleParent.resolve(fileName).toString() : fileName.toString();
            return treeName.replace(moduleName, replaceName);
        }
        return treeName;
    }

    private Optional<Node> getNodeTree(Node root, String treeName) {
        Node lastNode = root;
        for (String name : treeName.split("[\\/\\\\]")) {
            Optional<ClassNode> node = lastNode.findClass(name);
            if (node.isEmpty()) {
                return Optional.empty();
            }
            lastNode = node.get();
        }
        return Optional.of(lastNode);
    }

    private Node makeNodeTree(Node root, String treeName) {
        Node lastNode = root;
        for (String name : treeName.split("[\\/\\\\]")) {
            lastNode = lastNode.findOrCreateClassNode(name);
        }
        return lastNode;
    }

    private void addOrReplaceMetric(Map<Fields, Integer> map, Node node, Metric metric, Fields total, Fields covered) {
        node.replaceValue(new Coverage.CoverageBuilder(metric).withTotal(map.getOrDefault((Object)total, 0)).withCovered(map.getOrDefault((Object)covered, 0)).build());
    }

    private String readMetric(XMLEventReader xml, Node root, String metric, QName element) throws XMLStreamException {
        XMLEvent event;
        String treeName = "";
        EnumMap<Fields, Integer> map = new EnumMap<Fields, Integer>(Fields.class);
        block26: while (!(event = xml.nextEvent()).isEndElement() || !event.asEndElement().getName().equals(element)) {
            String tag;
            if (!event.isStartElement()) continue;
            String data = xml.nextEvent().asCharacters().getData().trim();
            switch (tag = event.asStartElement().getName().getLocalPart()) {
                case "function": {
                    this.readMetric(xml, root, metric, FUNCTION);
                    continue block26;
                }
                case "tree": {
                    treeName = data.replace("\\\\", "").replace('\\', File.separatorChar);
                    continue block26;
                }
            }
            try {
                map.put(Fields.fromTag(tag), Trace32Parser.parseInteger(data));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (!treeName.isEmpty()) {
            Node node = this.makeNodeTree(root, this.resolveTreeName(treeName));
            this.addOrReplaceMetric(map, node, "object".equals(metric) ? Metric.OBJECT_CODE : Metric.BYTES, Fields.BYTES, Fields.BYTESOK);
            switch (metric) {
                case "func": {
                    this.addOrReplaceMetric(map, node, Metric.FUNCTION, Fields.FUNCTIONS, Fields.FUNCTIONSOK);
                    break;
                }
                case "stmt": {
                    this.addOrReplaceMetric(map, node, Metric.STATEMENT, Fields.LINES, Fields.LINESOK);
                    break;
                }
                case "mcdc": {
                    this.addOrReplaceMetric(map, node, Metric.MCDC_PAIR, Fields.LINES, Fields.LINESOK);
                    this.addOrReplaceMetric(map, node, Metric.DECISION, Fields.DECISIONS, Fields.DECISIONSOK);
                    node.replaceValue(new Coverage.CoverageBuilder(Metric.CONDITION).withTotal(2 * map.getOrDefault((Object)Fields.CONDITIONS, 0)).withCovered(map.getOrDefault((Object)Fields.TRUE, 0) + map.getOrDefault((Object)Fields.FALSE, 0)).build());
                    break;
                }
                case "call": {
                    this.addOrReplaceMetric(map, node, Metric.FUNCTION_CALL, Fields.CALLS, Fields.CALLSOK);
                    this.addOrReplaceMetric(map, node, Metric.FUNCTION, Fields.FUNCTIONS, Fields.FUNCTIONSOK);
                    break;
                }
                case "cond": {
                    this.addOrReplaceMetric(map, node, Metric.STMT_CC, Fields.LINES, Fields.LINESOK);
                    node.replaceValue(new Coverage.CoverageBuilder(Metric.CONDITION).withTotal(2 * map.getOrDefault((Object)Fields.CONDITIONS, 0)).withCovered(map.getOrDefault((Object)Fields.TRUE, 0) + map.getOrDefault((Object)Fields.FALSE, 0)).build());
                    break;
                }
                case "dec": {
                    this.addOrReplaceMetric(map, node, Metric.STMT_DC, Fields.LINES, Fields.LINESOK);
                    node.replaceValue(new Coverage.CoverageBuilder(Metric.DECISION).withTotal(2 * map.getOrDefault((Object)Fields.DECISIONS, 0)).withCovered(map.getOrDefault((Object)Fields.TRUE, 0) + map.getOrDefault((Object)Fields.FALSE, 0)).build());
                    break;
                }
                default: {
                    int total = 2 * (map.getOrDefault((Object)Fields.OK, 0) + map.getOrDefault((Object)Fields.TAKEN, 0) + map.getOrDefault((Object)Fields.NOTTAKEN, 0) + map.getOrDefault((Object)Fields.NEVER, 0));
                    int covered = 2 * map.getOrDefault((Object)Fields.OK, 0) + map.getOrDefault((Object)Fields.TAKEN, 0) + map.getOrDefault((Object)Fields.NOTTAKEN, 0);
                    node.replaceValue(new Coverage.CoverageBuilder(Metric.BRANCH).withTotal(total).withCovered(covered).build());
                }
            }
        }
        return treeName;
    }

    private Optional<XMLEventReader> readFile(String filePath, Optional<Reader> reader, FilteredLog log) throws XMLStreamException {
        Reader xmlReader;
        block10: {
            if (reader.isEmpty()) {
                try (BufferedReader xmlModule = Files.newBufferedReader(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);){
                    String xmlContent = IOUtils.toString((Reader)xmlModule);
                    xmlReader = new StringReader(xmlContent);
                    log.logInfo("[TRACE32] Reading file: \"%s\"", new Object[]{filePath});
                    break block10;
                }
                catch (FileNotFoundException | NoSuchFileException unused) {
                    log.logInfo("[TRACE32] File \"%s\" does not exist.", new Object[]{filePath});
                    return Optional.empty();
                }
                catch (IOException e) {
                    throw new XMLStreamException("[TRACE32] Error reading file \"" + filePath + "\": " + e.getMessage(), e);
                }
            }
            xmlReader = reader.get();
        }
        return Optional.of(new SecureXmlParserFactory().createXmlEventReader(xmlReader));
    }

    private void parseFile(ModuleNode root, String filePath, Optional<Reader> reader, FilteredLog log) throws XMLStreamException {
        XMLEventReader xml = this.readFile(filePath, reader, log).orElse(null);
        if (xml == null) {
            return;
        }
        while (xml.hasNext()) {
            XMLEvent event = xml.nextEvent();
            if (!event.isStartElement() || !event.asStartElement().getName().equals(TRACE32)) continue;
            while (!(event = xml.nextEvent()).isEndElement() || !event.asEndElement().getName().equals(TRACE32)) {
                if (!event.isStartElement() || !event.asStartElement().getName().equals(COVERAGE)) continue;
                while (!(event = xml.nextEvent()).isEndElement() || !event.asEndElement().getName().equals(COVERAGE)) {
                    String metric;
                    if (!event.isStartElement()) continue;
                    QName name = event.asStartElement().getName();
                    if (name.equals(LIST_MODULE)) {
                        metric = event.asStartElement().getAttributeByName(METRIC_ATTR).getValue();
                        while (!(event = xml.nextEvent()).isEndElement() || !event.asEndElement().getName().equals(LIST_MODULE)) {
                            String treeName;
                            if (!event.isStartElement() || !event.asStartElement().getName().equals(MODULE) || (treeName = this.readMetric(xml, root, metric, MODULE)).isEmpty() || reader.isEmpty()) continue;
                            Path filePathParent = Paths.get(filePath, new String[0]).getParent();
                            if (filePathParent == null) {
                                filePathParent = Paths.get(".", new String[0]);
                            }
                            String modulePath = filePathParent.resolve(treeName).resolve("index.xml").toString();
                            this.parseFile(root, modulePath, Optional.empty(), log);
                        }
                        continue;
                    }
                    if (!name.equals(LIST_FUNC)) continue;
                    metric = event.asStartElement().getAttributeByName(METRIC_ATTR).getValue();
                    while (!(event = xml.nextEvent()).isEndElement() || !event.asEndElement().getName().equals(LIST_FUNC)) {
                        if (!event.isStartElement() || !event.asStartElement().getName().equals(MODULE)) continue;
                        this.readMetric(xml, root, metric, MODULE);
                    }
                }
            }
        }
        xml.close();
    }

    private void parseListing(String filePath, FilteredLog log) throws XMLStreamException {
        XMLEventReader xml = this.readFile(filePath, Optional.empty(), log).orElse(null);
        if (xml == null) {
            return;
        }
        while (xml.hasNext()) {
            XMLEvent event = xml.nextEvent();
            if (!event.isStartElement() || !event.asStartElement().getName().equals(TRACE32)) continue;
            while (!(event = xml.nextEvent()).isEndElement() || !event.asEndElement().getName().equals(TRACE32)) {
                if (!event.isStartElement() || !event.asStartElement().getName().equals(LIST_EXPORT)) continue;
                while (!(event = xml.nextEvent()).isEndElement() || !event.asEndElement().getName().equals(LIST_EXPORT)) {
                    if (!event.isStartElement() || !event.asStartElement().getName().equals(MIXED)) continue;
                    String moduleName = event.asStartElement().getAttributeByName(MODULE).getValue().replace("\\\\", "").replace('\\', File.separatorChar);
                    this.filesToProcess.putIfAbsent(moduleName, event.asStartElement().getAttributeByName(SRCPATH).getValue().replace(File.separatorChar == '\\' ? (char)'/' : '\\', File.separatorChar));
                }
            }
        }
        xml.close();
    }

    private static enum Fields {
        BYTES,
        BYTESOK,
        CALLS,
        CALLSOK,
        LINES,
        LINESOK,
        FUNCTIONS,
        FUNCTIONSOK,
        DECISIONS,
        DECISIONSOK,
        CONDITIONS,
        TRUE,
        FALSE,
        OK,
        TAKEN,
        NOTTAKEN,
        NEVER;


        static Fields fromTag(String tag) throws IllegalArgumentException {
            return Fields.valueOf(tag.toUpperCase(Locale.getDefault()));
        }
    }
}

