/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.MethodNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class OpenCoverParser
extends CoverageParser {
    private static final long serialVersionUID = -4819428317255612971L;
    private static final PathUtil PATH_UTIL = new PathUtil();
    private static final QName MODULE = new QName("Module");
    private static final QName CLASS = new QName("Class");
    private static final QName METHOD = new QName("Method");
    private static final QName CLASS_NAME = new QName("FullName");
    private static final QName METHOD_NAME = new QName("Name");
    private static final QName MODULE_NAME = new QName("ModuleName");
    private static final QName FILE = new QName("File");
    private static final QName FILE_REF = new QName("FileRef");
    private static final QName SUMMARY = new QName("Summary");
    private static final QName SEQUENCE_POINTS = new QName("SequencePoints");
    private static final QName SEQUENCE_POINT = new QName("SequencePoint");
    private static final QName BRANCH_POINTS = new QName("BranchPoints");
    private static final QName BRANCH_POINT = new QName("BranchPoint");
    private static final QName SOURCE_LINE_NUMBER = new QName("sl");
    private static final QName SOURCE_LINE_HINT = new QName("vc");
    private static final QName MODULE_SKIPPED = new QName("skippedDueTo");
    private static final QName METHOD_VISITED = new QName("visited");
    private static final QName UID = new QName("uid");
    private static final QName FULL_PATH = new QName("fullPath");
    private static final QName METHOD_INSTRUCTION_COVERED = new QName("visitedSequencePoints");
    private static final QName METHOD_INSTRUCTION_TOTAL = new QName("numSequencePoints");
    private static final QName METHOD_BRANCH_COVERED = new QName("visitedBranchPoints");
    private static final QName METHOD_BRANCH_TOTAL = new QName("numBranchPoints");
    private static final QName METHOD_CYCLOMATIC_COMPLEXITY = new QName("cyclomaticComplexity");

    public OpenCoverParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public OpenCoverParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        try {
            XMLEventReader eventReader = new SecureXmlParserFactory().createXmlEventReader(reader);
            ModuleNode root = new ModuleNode("-");
            while (eventReader.hasNext()) {
                boolean hasModule;
                StartElement startElement;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !MODULE.equals((startElement = event.asStartElement()).getName()) || startElement.getAttributeByName(MODULE_SKIPPED) != null || !(hasModule = !this.readModule(eventReader, root))) continue;
                return root;
            }
            this.handleEmptyResults(fileName, log);
            return new ModuleNode("empty");
        }
        catch (XMLStreamException exception) {
            throw new CoverageParser.ParsingException(exception);
        }
    }

    private boolean readModule(XMLEventReader reader, ModuleNode root) throws XMLStreamException {
        HashMap<String, String> files = new HashMap<String, String>();
        ArrayList<CoverageClassHolder> classes = new ArrayList<CoverageClassHolder>();
        boolean isEmpty = true;
        PackageNode packageNode = new PackageNode("-");
        while (reader.hasNext()) {
            XMLEvent nextElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                nextElement = event.asStartElement();
                if (CLASS.equals(nextElement.getName())) {
                    classes.add(this.readClass(reader));
                    continue;
                }
                if (FILE.equals(nextElement.getName())) {
                    String fileName = OpenCoverParser.getValueOf((StartElement)nextElement, FULL_PATH);
                    String uid = OpenCoverParser.getValueOf((StartElement)nextElement, UID);
                    String relativePath = PATH_UTIL.getRelativePath(fileName);
                    files.put(uid, relativePath);
                    continue;
                }
                if (!MODULE_NAME.equals(nextElement.getName())) continue;
                String moduleName = reader.nextEvent().asCharacters().getData();
                ModuleNode moduleNode = new ModuleNode(moduleName);
                packageNode = moduleNode.findOrCreatePackageNode("-");
                root.addChild(moduleNode);
                isEmpty = false;
                continue;
            }
            if (!event.isEndElement() || !MODULE.equals((nextElement = event.asEndElement()).getName())) continue;
            break;
        }
        if (isEmpty) {
            return true;
        }
        this.createNodes(files, packageNode, classes);
        return false;
    }

    private void createNodes(Map<String, String> files, PackageNode packageNode, List<CoverageClassHolder> classes) {
        for (Map.Entry<String, String> file : files.entrySet()) {
            FileNode fileNode = packageNode.findOrCreateFileNode(this.getFileName(file.getValue()), this.getTreeStringBuilder().intern(file.getValue()));
            for (CoverageClassHolder clazz : classes) {
                if (!clazz.hasMethods() || clazz.getFileId() == null || !clazz.getFileId().equals(file.getKey())) continue;
                this.createClassWithMethods(clazz, fileNode);
            }
        }
    }

    private void createClassWithMethods(CoverageClassHolder clazz, FileNode fileNode) {
        ClassNode classNode = fileNode.createClassNode(clazz.getClassName());
        for (CoverageMethod method : clazz.getMethods()) {
            if (!classNode.findMethod(method.getMethodName(), method.getMethodName()).isEmpty()) continue;
            this.createPoints(fileNode, classNode, method);
        }
    }

    private void createPoints(FileNode fileNode, ClassNode classNode, CoverageMethod method) {
        MethodNode methodNode = classNode.createMethodNode(method.getMethodName(), method.getMethodName());
        Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder();
        Coverage branchCoverage = builder.withMetric(Metric.BRANCH).withCovered(method.getBranchCovered()).withMissed(method.getBranchMissed()).build();
        Coverage instructionCoverage = builder.withMetric(Metric.INSTRUCTION).withCovered(method.getInstructionCovered()).withMissed(method.getInstructionMissed()).build();
        Coverage lineCoverage = builder.withMetric(Metric.LINE).withCovered(method.getInstructionCovered()).withMissed(method.getInstructionMissed()).build();
        methodNode.addValue(lineCoverage);
        methodNode.addValue(branchCoverage);
        methodNode.addValue(instructionCoverage);
        methodNode.addValue(new Value(Metric.CYCLOMATIC_COMPLEXITY, method.getComplexity()));
        LinkedHashMap<Integer, Pair> points = new LinkedHashMap<Integer, Pair>();
        for (CoverageHint coverageHint : method.getSequencePoints()) {
            points.put(coverageHint.getLineNumber(), Pair.of((Object)coverageHint.getHint(), (Object)0));
        }
        for (CoverageHint coverageHint : method.getBranchPoints()) {
            if (!points.containsKey(coverageHint.getLineNumber())) continue;
            points.put(coverageHint.getLineNumber(), Pair.of((Object)((Integer)((Pair)points.get(coverageHint.getLineNumber())).getLeft()), (Object)((Integer)coverageHint.getRight())));
        }
        for (Map.Entry entry : points.entrySet()) {
            this.addCounters(fileNode, (Integer)entry.getKey(), (Integer)((Pair)entry.getValue()).getLeft(), (Integer)((Pair)entry.getValue()).getRight());
        }
    }

    private CoverageClassHolder readClass(XMLEventReader reader) throws XMLStreamException {
        String className = "";
        ArrayList<CoverageMethod> methods = new ArrayList<CoverageMethod>();
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (CLASS_NAME.equals(nextElement.getName())) {
                    className = reader.nextEvent().asCharacters().getData();
                }
                Attribute visited = nextElement.getAttributeByName(METHOD_VISITED);
                if (!METHOD.equals(nextElement.getName()) || visited != null && !"true".equals(visited.getValue())) continue;
                methods.add(this.readMethod(reader, nextElement));
                continue;
            }
            if (!event.isEndElement() || !CLASS.equals((endElement = event.asEndElement()).getName())) continue;
            break;
        }
        return new CoverageClassHolder(className, methods);
    }

    private CoverageMethod readMethod(XMLEventReader reader, StartElement parentElement) throws XMLStreamException {
        CoverageMethod coverageMethod = new CoverageMethod();
        coverageMethod.setComplexity(OpenCoverParser.getIntegerValueOf(parentElement, METHOD_CYCLOMATIC_COMPLEXITY));
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (METHOD_NAME.equals(nextElement.getName())) {
                    coverageMethod.setMethodName(reader.nextEvent().asCharacters().getData());
                }
                if (SUMMARY.equals(nextElement.getName())) {
                    this.readMethodSummary(coverageMethod, nextElement);
                }
                if (BRANCH_POINTS.equals(nextElement.getName())) {
                    this.readBranchPoints(reader, coverageMethod);
                }
                if (SEQUENCE_POINTS.equals(nextElement.getName())) {
                    this.readSequencePoints(reader, coverageMethod);
                }
                if (!FILE_REF.equals(nextElement.getName())) continue;
                coverageMethod.setFileId(OpenCoverParser.getValueOf(nextElement, UID));
                continue;
            }
            if (!event.isEndElement() || !METHOD.equals((endElement = event.asEndElement()).getName())) continue;
            break;
        }
        return coverageMethod;
    }

    private void readMethodSummary(CoverageMethod coverageMethod, StartElement startElement) {
        coverageMethod.setBranchCovered(OpenCoverParser.getIntegerValueOf(startElement, METHOD_BRANCH_COVERED));
        coverageMethod.setBranchMissed(OpenCoverParser.getIntegerValueOf(startElement, METHOD_BRANCH_TOTAL) - coverageMethod.getBranchCovered());
        coverageMethod.setInstructionCovered(OpenCoverParser.getIntegerValueOf(startElement, METHOD_INSTRUCTION_COVERED));
        coverageMethod.setInstructionMissed(OpenCoverParser.getIntegerValueOf(startElement, METHOD_INSTRUCTION_TOTAL) - coverageMethod.getInstructionCovered());
    }

    private void readSequencePoints(XMLEventReader reader, CoverageMethod coverageMethod) throws XMLStreamException {
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (!SEQUENCE_POINT.equals(nextElement.getName()) || nextElement.getAttributeByName(SOURCE_LINE_NUMBER) == null) continue;
                coverageMethod.getSequencePoints().add(new CoverageHint(OpenCoverParser.getIntegerValueOf(nextElement, SOURCE_LINE_NUMBER), OpenCoverParser.getIntegerValueOf(nextElement, SOURCE_LINE_HINT)));
                continue;
            }
            if (!event.isEndElement() || !SEQUENCE_POINT.equals((endElement = event.asEndElement()).getName()) && !SEQUENCE_POINTS.equals(endElement.getName())) continue;
            break;
        }
    }

    private void readBranchPoints(XMLEventReader reader, CoverageMethod coverageMethod) throws XMLStreamException {
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (!BRANCH_POINT.equals(nextElement.getName()) || nextElement.getAttributeByName(SOURCE_LINE_NUMBER) == null) continue;
                coverageMethod.getBranchPoints().add(new CoverageHint(OpenCoverParser.getIntegerValueOf(nextElement, SOURCE_LINE_NUMBER), OpenCoverParser.getIntegerValueOf(nextElement, SOURCE_LINE_HINT)));
                continue;
            }
            if (!event.isEndElement() || !BRANCH_POINT.equals((endElement = event.asEndElement()).getName()) && !BRANCH_POINTS.equals(endElement.getName())) continue;
            break;
        }
    }

    private void addCounters(FileNode fileNode, int lineNumber, int coveredInstructions, int coveredBranches) {
        int missed;
        int covered;
        if (coveredBranches == 0) {
            covered = coveredInstructions > 0 ? 1 : 0;
            missed = covered > 0 ? 0 : 1;
        } else {
            covered = coveredBranches;
            missed = coveredBranches - coveredInstructions;
        }
        fileNode.addCounters(lineNumber, covered, missed);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String getFileName(String relativePath) {
        return Path.of(PATH_UTIL.getAbsolutePath(relativePath), new String[0]).getFileName().toString();
    }

    private static class CoverageClassHolder
    extends MutablePair<String, List<CoverageMethod>> {
        private static final long serialVersionUID = 1L;

        CoverageClassHolder(String className, List<CoverageMethod> methods) {
            super((Object)className, methods);
        }

        boolean hasMethods() {
            return !this.getMethods().isEmpty();
        }

        List<CoverageMethod> getMethods() {
            return (List)this.getRight();
        }

        String getClassName() {
            return (String)this.getLeft();
        }

        String getFileId() {
            return this.getMethods().get(0).getFileId();
        }
    }

    private static class CoverageMethod {
        private String methodName = "";
        private String fileId = "";
        private int instructionCovered;
        private int instructionMissed;
        private int branchCovered;
        private int branchMissed;
        private int complexity;
        private final List<CoverageHint> sequencePoints = new ArrayList<CoverageHint>();
        private final List<CoverageHint> branchPoints = new ArrayList<CoverageHint>();

        private CoverageMethod() {
        }

        String getMethodName() {
            return this.methodName;
        }

        void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        String getFileId() {
            return this.fileId;
        }

        void setFileId(String fileId) {
            this.fileId = fileId;
        }

        int getInstructionCovered() {
            return this.instructionCovered;
        }

        void setInstructionCovered(int instructionCovered) {
            this.instructionCovered = instructionCovered;
        }

        int getInstructionMissed() {
            return this.instructionMissed;
        }

        void setInstructionMissed(int instructionMissed) {
            this.instructionMissed = instructionMissed;
        }

        int getBranchCovered() {
            return this.branchCovered;
        }

        void setBranchCovered(int branchCovered) {
            this.branchCovered = branchCovered;
        }

        int getBranchMissed() {
            return this.branchMissed;
        }

        void setBranchMissed(int branchMissed) {
            this.branchMissed = branchMissed;
        }

        int getComplexity() {
            return this.complexity;
        }

        void setComplexity(int complexity) {
            this.complexity = complexity;
        }

        List<CoverageHint> getSequencePoints() {
            return this.sequencePoints;
        }

        List<CoverageHint> getBranchPoints() {
            return this.branchPoints;
        }
    }

    private static class CoverageHint
    extends MutablePair<Integer, Integer> {
        private static final long serialVersionUID = 1L;

        CoverageHint(Integer lineNumber, Integer hint) {
            super((Object)lineNumber, (Object)hint);
        }

        Integer getLineNumber() {
            return (Integer)this.getLeft();
        }

        Integer getHint() {
            return (Integer)this.getRight();
        }
    }
}

