/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.MethodNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.hm.hafner.util.TreeString;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class CoberturaParser
extends CoverageParser {
    private static final long serialVersionUID = -3625341318291829577L;
    private static final Pattern BRANCH_PATTERN = Pattern.compile(".*\\((?<covered>\\d+)/(?<total>\\d+)\\)");
    private static final PathUtil PATH_UTIL = new PathUtil();
    private static final String DETERMINISTIC_PATH_PREFIX = "/_/";
    private static final Coverage DEFAULT_BRANCH_COVERAGE = new Coverage.CoverageBuilder(Metric.BRANCH).withCovered(2).withMissed(0).build();
    private static final Coverage LINE_COVERED = new Coverage.CoverageBuilder(Metric.LINE).withCovered(1).withMissed(0).build();
    private static final Coverage LINE_MISSED = new Coverage.CoverageBuilder(Metric.LINE).withCovered(0).withMissed(1).build();
    private static final QName SOURCE = new QName("source");
    private static final QName PACKAGE = new QName("package");
    private static final QName CLASS = new QName("class");
    private static final QName METHOD = new QName("method");
    private static final QName LINE = new QName("line");
    private static final QName NAME = new QName("name");
    private static final QName FILE_NAME = new QName("filename");
    private static final QName SIGNATURE = new QName("signature");
    private static final QName HITS = new QName("hits");
    private static final QName COMPLEXITY = new QName("complexity");
    private static final QName NUMBER = new QName("number");
    private static final QName BRANCH = new QName("branch");
    private static final QName CONDITION_COVERAGE = new QName("condition-coverage");

    public CoberturaParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public CoberturaParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        try {
            XMLEventReader eventReader = new SecureXmlParserFactory().createXmlEventReader(reader);
            ModuleNode root = new ModuleNode("-");
            this.handleEmptyResults(fileName, log, this.readModule(eventReader, root, fileName, log));
            return root;
        }
        catch (XMLStreamException exception) {
            throw new CoverageParser.ParsingException(exception);
        }
    }

    private boolean readModule(XMLEventReader eventReader, ModuleNode root, String fileName, FilteredLog log) throws XMLStreamException {
        boolean isEmpty = true;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement startElement = event.asStartElement();
            QName tagName = startElement.getName();
            if (SOURCE.equals(tagName)) {
                this.readSource(eventReader, root);
                continue;
            }
            if (!PACKAGE.equals(tagName)) continue;
            this.readPackage(eventReader, root, this.readName(startElement), fileName, log);
            isEmpty = false;
        }
        return isEmpty;
    }

    private void readPackage(XMLEventReader reader, ModuleNode root, String packageName, String fileName, FilteredLog log) throws XMLStreamException {
        PackageNode packageNode = root.findOrCreatePackageNode(packageName);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement element = event.asStartElement();
                if (!CLASS.equals(element.getName())) continue;
                FileNode fileNode = this.createFileNode(element, packageNode);
                this.readClassOrMethod(reader, fileNode, fileNode, element, fileName, log);
                continue;
            }
            if (!event.isEndElement()) continue;
            return;
        }
    }

    private FileNode createFileNode(StartElement element, PackageNode packageNode) {
        String fileName = CoberturaParser.getValueOf(element, FILE_NAME);
        String relativePath = Strings.CS.removeStart(PATH_UTIL.getRelativePath(fileName), (CharSequence)DETERMINISTIC_PATH_PREFIX);
        TreeString path = this.getTreeStringBuilder().intern(relativePath);
        return packageNode.findOrCreateFileNode(this.getFileName(fileName), path);
    }

    private String getFileName(String relativePath) {
        Path path = Path.of(PATH_UTIL.getAbsolutePath(relativePath), new String[0]).getFileName();
        if (path == null) {
            return relativePath;
        }
        return path.toString();
    }

    protected void readClassOrMethod(XMLEventReader reader, FileNode fileNode, Node parentNode, StartElement element, String fileName, FilteredLog log) throws XMLStreamException {
        Coverage lineCoverage = Coverage.nullObject(Metric.LINE);
        Coverage branchCoverage = Coverage.nullObject(Metric.BRANCH);
        Node node = this.createNode(parentNode, element, log);
        CoberturaParser.getOptionalValueOf(element, COMPLEXITY).ifPresent(c -> node.addValue(new Value(Metric.CYCLOMATIC_COMPLEXITY, this.readComplexity((String)c))));
        HashMap<Integer, Coverage> coveragePerLine = new HashMap<Integer, Coverage>();
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (LINE.equals(nextElement.getName())) {
                    Coverage currentLineCoverage;
                    Coverage coverage2;
                    if (this.isBranchCoverage(nextElement)) {
                        coverage2 = this.readBranchCoverage(nextElement);
                        currentLineCoverage = this.computeLineCoverage(coverage2.getCovered());
                        branchCoverage = branchCoverage.add(coverage2);
                    } else {
                        int lineHits = CoberturaParser.getIntegerValueOf(nextElement, HITS);
                        coverage2 = currentLineCoverage = this.computeLineCoverage(lineHits);
                    }
                    lineCoverage = lineCoverage.add(currentLineCoverage);
                    if (!CLASS.equals(element.getName())) continue;
                    int lineNumber2 = CoberturaParser.getIntegerValueOf(nextElement, NUMBER);
                    coveragePerLine.merge(lineNumber2, coverage2, this::mergeDuplicateLines);
                    continue;
                }
                if (!METHOD.equals(nextElement.getName())) continue;
                this.readClassOrMethod(reader, fileNode, node, nextElement, fileName, log);
                continue;
            }
            if (!event.isEndElement() || !CLASS.equals((endElement = event.asEndElement()).getName()) && !METHOD.equals(endElement.getName())) continue;
            coveragePerLine.forEach((lineNumber, coverage) -> fileNode.addCounters((int)lineNumber, coverage.getCovered(), coverage.getMissed()));
            node.addValue(lineCoverage);
            if (branchCoverage.isSet()) {
                node.addValue(branchCoverage);
            }
            return;
        }
        throw CoberturaParser.createEofException(fileName);
    }

    private Coverage mergeDuplicateLines(Coverage existing, Coverage newCoverage) {
        if (existing.getTotal() == 1 && newCoverage.getTotal() == 1) {
            if (existing.getCovered() > 0 || newCoverage.getCovered() > 0) {
                return LINE_COVERED;
            }
            return LINE_MISSED;
        }
        if (newCoverage.getCovered() > existing.getCovered()) {
            return newCoverage;
        }
        return existing;
    }

    protected Coverage computeLineCoverage(int coverage) {
        return coverage > 0 ? LINE_COVERED : LINE_MISSED;
    }

    protected Node createNode(Node parentNode, StartElement element, FilteredLog log) {
        String name = this.readName(element);
        if (CLASS.equals(element.getName())) {
            return this.createClassNode(parentNode, log, name);
        }
        return this.createMethodNode(parentNode, element, log, name);
    }

    private MethodNode createMethodNode(Node parentNode, StartElement element, FilteredLog log, String name) {
        Object methodName = name;
        String signature = CoberturaParser.getValueOf(element, SIGNATURE);
        if (parentNode.findMethod((String)methodName, signature).isPresent() && this.ignoreErrors()) {
            log.logError("Found a duplicate method '%s' with signature '%s' in '%s'", new Object[]{methodName, signature, parentNode.getName()});
            methodName = name + "-" + this.createId();
        }
        return parentNode.createMethodNode((String)methodName, signature);
    }

    private ClassNode createClassNode(Node parentNode, FilteredLog log, String name) {
        Object className = name;
        if (parentNode.hasChild((String)className) && this.ignoreErrors()) {
            log.logError("Found a duplicate class '%s' in '%s'", new Object[]{className, parentNode.getName()});
            className = name + "-" + this.createId();
        }
        return parentNode.createClassNode((String)className);
    }

    private String readName(StartElement element) {
        return (String)StringUtils.defaultIfBlank((CharSequence)CoberturaParser.getValueOf(element, NAME), (CharSequence)this.createId());
    }

    private String createId() {
        return UUID.randomUUID().toString();
    }

    protected int readComplexity(String c) {
        try {
            return Math.round(Float.parseFloat(c));
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    protected boolean isBranchCoverage(StartElement line) {
        return CoberturaParser.getOptionalValueOf(line, BRANCH).map(Boolean::parseBoolean).orElse(false);
    }

    private void readSource(XMLEventReader reader, ModuleNode root) throws XMLStreamException {
        StringBuilder aggregatedContent = new StringBuilder();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isCharacters()) {
                aggregatedContent.append(event.asCharacters().getData());
                continue;
            }
            if (!event.isEndElement()) continue;
            root.addSource(new PathUtil().getRelativePath(aggregatedContent.toString()));
            return;
        }
    }

    protected Coverage readBranchCoverage(StartElement line) {
        return CoberturaParser.getOptionalValueOf(line, CONDITION_COVERAGE).map(this::fromConditionCoverage).orElse(DEFAULT_BRANCH_COVERAGE);
    }

    private Coverage fromConditionCoverage(String conditionCoverageAttribute) {
        Matcher matcher = BRANCH_PATTERN.matcher(conditionCoverageAttribute);
        if (matcher.matches()) {
            return new Coverage.CoverageBuilder().withMetric(Metric.BRANCH).withCovered(matcher.group("covered")).withTotal(matcher.group("total")).build();
        }
        return Coverage.nullObject(Metric.BRANCH);
    }
}

