/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.SafeFraction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.Fraction;

public final class Percentage
implements Serializable {
    private static final long serialVersionUID = 3324942976687883481L;
    public static final Percentage ZERO = new Percentage(0, 1);
    public static final Percentage HUNDRED = new Percentage(1, 1);
    private static final Percentage ALMOST_HUNDRED = new Percentage(9999, 10000);
    static final String TOTALS_ZERO_MESSAGE = "Totals must not greater than zero.";
    private static final int ALMOST_PERFECT_INTEGER = 99;
    private static final double ALMOST_PERFECT_DOUBLE = 99.99;
    private final int items;
    private final int total;

    public static Percentage valueOf(Fraction fraction) {
        return new Percentage(fraction.getNumerator(), fraction.getDenominator());
    }

    public static Percentage valueOf(int items, int total) {
        return new Percentage(items, total);
    }

    public static Percentage valueOf(String stringRepresentation) {
        try {
            String cleanedFormat = StringUtils.deleteWhitespace((String)stringRepresentation);
            if (Strings.CS.contains((CharSequence)cleanedFormat, (CharSequence)"/")) {
                String extractedNumerator = StringUtils.substringBefore((String)cleanedFormat, (String)"/");
                String extractedDenominator = StringUtils.substringAfter((String)cleanedFormat, (String)"/");
                int numerator = Integer.parseInt(extractedNumerator);
                int denominator = Integer.parseInt(extractedDenominator);
                return new Percentage(numerator, denominator);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Cannot convert %s to a valid Percentage instance.".formatted(stringRepresentation));
    }

    private Percentage(int items, int total) {
        if (total <= 0) {
            throw new IllegalArgumentException(TOTALS_ZERO_MESSAGE);
        }
        if (items > total) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The number of items %d must be less or equal the total number %d.", items, total));
        }
        this.items = items;
        this.total = total;
    }

    public double toDouble() {
        return (double)this.items * 100.0 / (double)this.total;
    }

    public double toRounded() {
        BigDecimal value = BigDecimal.valueOf(this.toDouble());
        double rounded = value.setScale(2, RoundingMode.HALF_UP).doubleValue();
        if (rounded == 100.0 && this.isNotPerfect()) {
            return 99.99;
        }
        return rounded;
    }

    public int toInt() {
        int value = Math.round((float)this.items * 100.0f / (float)this.total);
        if (value == 100 && this.isNotPerfect()) {
            return 99;
        }
        return value;
    }

    public String formatPercentage() {
        return this.formatPercentage(Locale.ENGLISH);
    }

    public String formatPercentage(Locale locale) {
        String formatted = String.format(locale, "%.2f%%", this.toDouble());
        if (formatted.startsWith("100") && this.isNotPerfect()) {
            return ALMOST_HUNDRED.formatPercentage(locale);
        }
        return formatted;
    }

    private boolean isNotPerfect() {
        return this.items != this.total;
    }

    public Fraction subtract(Percentage subtrahend) {
        return new SafeFraction(this.items, this.total).subtract(subtrahend.getItems(), subtrahend.getTotal());
    }

    public String formatDeltaPercentage(Locale locale) {
        return String.format(locale, "%+.2f%%", this.toDouble());
    }

    public int getItems() {
        return this.items;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Percentage that = (Percentage)o;
        return this.items == that.items && this.total == that.total;
    }

    public int hashCode() {
        return Objects.hash(this.items, this.total);
    }

    public String serializeToString() {
        return String.format(Locale.ENGLISH, "%d/%d", this.getItems(), this.getTotal());
    }

    public String toString() {
        return this.formatPercentage(Locale.ENGLISH);
    }
}

